/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher.download.cache;

import com.cleanroommc.relauncher.CleanroomRelauncher;
import com.cleanroommc.relauncher.download.CleanroomMultiMcPack;
import com.cleanroommc.relauncher.download.CleanroomRelease;
import com.cleanroommc.relauncher.download.GlobalDownloader;
import com.cleanroommc.relauncher.download.schema.Version;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;

public class CleanroomCache {
    private final Path directory;
    private final CleanroomRelease release;
    private final String version;

    public static CleanroomCache of(CleanroomRelease release) {
        return new CleanroomCache(release);
    }

    private CleanroomCache(CleanroomRelease release) {
        this.directory = CleanroomRelauncher.CACHE_DIR.resolve(release.tagName);
        this.release = release;
        this.version = release.tagName;
    }

    public List<Version> download() throws IOException {
        if (!Files.isDirectory(this.directory, new LinkOption[0])) {
            Files.createDirectories(this.directory, new FileAttribute[0]);
        }
        Path multiMcPackZip = this.getMultiMcPackZip();
        Path lwjglJson = this.getLwjglVersionJson();
        Path forgeJson = this.getForgeJson();
        Path minecraftJson = this.getMinecraftJson();
        Path universalJar = this.getUniversalJar();
        Path librariesDirectory = this.getLibrariesDirectory();
        Path nativesDirectory = this.getNativesDirectory();
        CleanroomMultiMcPack multiMcPack = CleanroomMultiMcPack.of(this.version, multiMcPackZip);
        multiMcPack.install(this.release.getMultiMcPackArtifact().downloadUrl);
        if (!(Files.exists(lwjglJson, new LinkOption[0]) && Files.exists(forgeJson, new LinkOption[0]) && Files.exists(minecraftJson, new LinkOption[0]) && Files.exists(universalJar, new LinkOption[0]))) {
            multiMcPack.extract(this);
        }
        ArrayList<Version> versions = new ArrayList<Version>();
        Version forgeJsonVersion = Version.parse(forgeJson);
        forgeJsonVersion.libraryPaths.add(this.getUniversalJar().toAbsolutePath().toString());
        Version minecraftJsonVersion = Version.parse(minecraftJson);
        Version lwjglJsonVersion = Version.parse(lwjglJson);
        versions.add(forgeJsonVersion);
        versions.add(minecraftJsonVersion);
        versions.add(lwjglJsonVersion);
        for (Version version : versions) {
            version.downloadLibraries(librariesDirectory);
        }
        GlobalDownloader.INSTANCE.blockUntilFinished();
        for (Version version : versions) {
            version.extractNatives(librariesDirectory, nativesDirectory);
        }
        return versions;
    }

    public Path getInstallerJar() {
        return this.directory.resolve("installer.jar");
    }

    public Path getUniversalJar() {
        return this.directory.resolve("universal.jar");
    }

    public Path getLibrariesDirectory() {
        return CleanroomRelauncher.CACHE_DIR.resolve("libraries/");
    }

    public Path getNativesDirectory() {
        return CleanroomRelauncher.CACHE_DIR.resolve("natives/");
    }

    public Path getVersionJson() {
        return this.directory.resolve("version.json");
    }

    @Deprecated
    public Path getMultiMcPackZip() {
        return this.directory.resolve("mmc.zip");
    }

    @Deprecated
    public Path getLwjglVersionJson() {
        return this.directory.resolve("org.lwjgl3.json");
    }

    @Deprecated
    public Path getForgeJson() {
        return this.directory.resolve("net.minecraftforge.json");
    }

    @Deprecated
    public Path getMinecraftJson() {
        return this.directory.resolve("net.minecraft.json");
    }
}

