/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.fancy_entity_renderer.api.entity.player;

import com.mojang.blaze3d.vertex.PoseStack;
import it.crystalnest.fancy_entity_renderer.api.entity.player.layer.FancyCapeLayer;
import it.crystalnest.fancy_entity_renderer.api.entity.player.model.FancyPlayerModel;
import it.crystalnest.fancy_entity_renderer.api.entity.player.state.FancyPlayerRenderState;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class FancyPlayerRenderer
extends PlayerRenderer {
    private static final EntityRendererProvider.Context RENDER_CONTEXT = new EntityRendererProvider.Context(Minecraft.getInstance().getEntityRenderDispatcher(), Minecraft.getInstance().getItemModelResolver(), Minecraft.getInstance().getMapRenderer(), Minecraft.getInstance().getBlockRenderer(), Minecraft.getInstance().getResourceManager(), Minecraft.getInstance().getEntityModels(), Minecraft.getInstance().getEntityRenderDispatcher().equipmentAssets, Minecraft.getInstance().font);
    private final FancyPlayerModel adultModel;
    private final FancyPlayerModel babyModel;

    public FancyPlayerRenderer(FancyPlayerRenderState state, boolean isSlim) {
        super(RENDER_CONTEXT, isSlim);
        this.entityRenderDispatcher.overrideCameraOrientation(new Quaternionf());
        this.entityRenderDispatcher.setRenderShadow(false);
        this.entityRenderDispatcher.setRenderHitBoxes(false);
        this.adultModel = new FancyPlayerModel(RENDER_CONTEXT.getModelSet(), isSlim, false);
        this.babyModel = new FancyPlayerModel(RENDER_CONTEXT.getModelSet(), isSlim, true);
        this.model = this.adultModel;
        this.reusedState = state;
        this.layers.replaceAll(layer -> {
            RenderLayer renderLayer = layer;
            Objects.requireNonNull(renderLayer);
            RenderLayer selector0$temp = renderLayer;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HumanoidArmorLayer.class, CapeLayer.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    HumanoidArmorLayer l = (HumanoidArmorLayer)selector0$temp;
                    yield new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new HumanoidArmorModel(RENDER_CONTEXT.bakeLayer(isSlim ? ModelLayers.PLAYER_SLIM_INNER_ARMOR : ModelLayers.PLAYER_INNER_ARMOR)), (HumanoidModel)new HumanoidArmorModel(RENDER_CONTEXT.bakeLayer(isSlim ? ModelLayers.PLAYER_SLIM_OUTER_ARMOR : ModelLayers.PLAYER_OUTER_ARMOR)), (HumanoidModel)new HumanoidArmorModel(FancyPlayerModel.getBabyArmorModel(true)), (HumanoidModel)new HumanoidArmorModel(FancyPlayerModel.getBabyArmorModel(false)), RENDER_CONTEXT.getEquipmentRenderer());
                }
                case 1 -> {
                    CapeLayer l = (CapeLayer)selector0$temp;
                    yield new FancyCapeLayer((RenderLayerParent<PlayerRenderState, PlayerModel>)this, RENDER_CONTEXT.getModelSet(), RENDER_CONTEXT.getEquipmentAssets());
                }
                default -> layer;
            };
        });
    }

    private FancyPlayerRenderState state() {
        return (FancyPlayerRenderState)this.reusedState;
    }

    public void render(@NotNull PlayerRenderState state, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        this.model = state.isBaby ? this.babyModel : this.adultModel;
        super.render(state, poseStack, bufferSource, packedLight);
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        poseStack.rotateAround(new Quaternionf().rotateX(this.state().bodyRot.getX()).rotateY(-this.state().bodyRot.getY()).rotateZ(this.state().bodyRot.getZ()), 0.0f, 0.0f, 0.0f);
        this.entityRenderDispatcher.render(null, 0.0, 0.0, 0.0, 0.0f, poseStack, bufferSource, packedLight, (EntityRenderer)this);
    }

    protected void renderNameTag(@NotNull PlayerRenderState renderState, @NotNull Component nameTag, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        FancyPlayerRenderState state = this.state();
        if (state.showPlayerName) {
            float scale = state.scale * 0.025f;
            Font font = this.getFont();
            poseStack.pushPose();
            poseStack.translate(state.nameTagAttachment);
            poseStack.scale(scale, -scale, scale);
            font.drawInBatch(nameTag, (float)(-font.width((FormattedText)nameTag)) / 2.0f, -state.boundingBoxHeight / scale, state.isDiscrete ? -2130706433 : -1, false, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, (int)(Minecraft.getInstance().options.getBackgroundOpacity(0.25f) * 255.0f) << 24, packedLight);
            poseStack.popPose();
        }
    }

    public void extractRenderState(@Nullable AbstractClientPlayer player, @NotNull PlayerRenderState renderState, float partialTick) {
        FancyPlayerRenderState state = this.state();
        renderState.walkAnimationPos = 0.0f;
        renderState.walkAnimationSpeed = 0.0f;
        renderState.eyeHeight = 1.62f;
        renderState.isDiscrete = state.isCrouching;
        renderState.ageInTicks = state.isMoving ? (renderState.ageInTicks += 1.0f) : 3000.0f;
        renderState.boundingBoxWidth = state.boundingBoxWidth;
        renderState.boundingBoxHeight = state.boundingBoxHeight;
        renderState.scale = state.scale;
        renderState.pose = Pose.STANDING;
        renderState.nameTag = Component.literal((String)state.name);
        renderState.nameTagAttachment = new Vec3(0.0, (double)(0.5f * state.scale), 0.0);
        renderState.skin = state.skin;
        renderState.parrotOnLeftShoulder = state.parrotOnLeftShoulder;
        renderState.parrotOnRightShoulder = state.parrotOnRightShoulder;
        renderState.isBaby = state.isBaby;
        if (state.rightHandHeldItem != null) {
            Minecraft.getInstance().getItemModelResolver().updateForTopItem(state.rightHandItem, state.rightHandHeldItem.getDefaultInstance(), ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, false, null, null, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND.ordinal());
        }
        if (state.leftHandHeldItem != null) {
            Minecraft.getInstance().getItemModelResolver().updateForTopItem(state.leftHandItem, state.leftHandHeldItem.getDefaultInstance(), ItemDisplayContext.THIRD_PERSON_LEFT_HAND, true, null, null, ItemDisplayContext.THIRD_PERSON_LEFT_HAND.ordinal());
        }
        renderState.headEquipment = state.headEquipment;
        renderState.chestEquipment = state.chestEquipment;
        renderState.legsEquipment = state.legsEquipment;
        renderState.feetEquipment = state.feetEquipment;
        renderState.isSpectator = state.isSpectator;
        renderState.appearsGlowing = state.appearsGlowing;
        renderState.displayFireAnimation = state.displayFireAnimation;
        renderState.elytraRotX = 0.19634955f;
        renderState.elytraRotZ = 0.31415927f;
    }
}

