/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.fancy_entity_renderer.api.entity.player;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.math.Axis;
import it.crystalnest.fancy_entity_renderer.Constants;
import it.crystalnest.fancy_entity_renderer.api.Rotation;
import it.crystalnest.fancy_entity_renderer.api.entity.player.FancyPlayerRenderer;
import it.crystalnest.fancy_entity_renderer.api.entity.player.FancyProfileFetcher;
import it.crystalnest.fancy_entity_renderer.api.entity.player.state.FancyPlayerRenderState;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class FancyPlayerWidget
extends AbstractWidget {
    public static final float PLAYER_RENDER_HEIGHT = 1.875f;
    private final FancyPlayerRenderState renderState = new FancyPlayerRenderState();
    private final FancyPlayerRenderer wideRenderer = new FancyPlayerRenderer(this.renderState, false);
    private final FancyPlayerRenderer slimRenderer = new FancyPlayerRenderer(this.renderState, true);
    private FancyPlayerRenderer renderer;
    private final OverridableProperties properties;
    private final Random random;

    public FancyPlayerWidget(int x, int y, int width, int height) {
        super(x, y, width, height, CommonComponents.EMPTY);
        this.renderer = this.renderState.isSlim ? this.slimRenderer : this.wideRenderer;
        this.properties = new OverridableProperties(this.renderState.name);
        this.random = new Random();
    }

    private static void handlePlayerCopyError(String source) {
        Constants.LOGGER.error("Failed to copy player \"{}\"", (Object)source);
    }

    private static <T> Optional<T> handlePlayerCopyError(Throwable error) {
        Constants.LOGGER.error("Copy of player failed with error!", error);
        return Optional.empty();
    }

    protected void renderWidget(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        this.updateRenderState(this.getX(), this.getY(), this.getWidth(), this.getHeight(), mouseX, mouseY, partialTick);
        gfx.pose().pushPose();
        gfx.pose().translate((float)this.getX() + (float)this.getWidth() / 2.0f, (float)this.getY() + (float)this.getHeight(), 100.0f);
        gfx.flush();
        gfx.pose().scale(1.0f, -1.0f, 1.0f);
        Lighting.setupForEntityInInventory((Quaternionf)Axis.XP.rotationDegrees(this.renderState.bodyRot.getX()));
        gfx.drawSpecial(bufferSource -> this.renderer.render(gfx.pose(), (MultiBufferSource)bufferSource, 0xF000F0));
        gfx.flush();
        gfx.pose().popPose();
    }

    public void playDownSound(@NotNull SoundManager soundManager) {
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput output) {
    }

    public FancyPlayerWidget setBodyFollowsMouse(boolean followsMouse) {
        this.renderState.bodyFollowsMouse = followsMouse;
        if (followsMouse) {
            this.properties.bodyRot.copy(this.renderState.bodyRot);
        } else {
            this.renderState.bodyRot.copy(this.properties.bodyRot);
        }
        return this;
    }

    public FancyPlayerWidget setHeadFollowsMouse(boolean followsMouse) {
        this.renderState.headFollowsMouse = followsMouse;
        if (followsMouse) {
            this.properties.headRot.copy(this.renderState.headRot);
        } else {
            this.renderState.headRot.copy(this.properties.headRot);
        }
        return this;
    }

    public FancyPlayerWidget setHeadRotation(Rotation rotation) {
        this.properties.headRot.copy(rotation);
        this.renderState.headRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setHeadRotation(float x, float y, float z) {
        this.properties.headRot.updateDeg(x, y, z);
        this.renderState.headRot.updateDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setBodyRotation(Rotation rotation) {
        this.properties.bodyRot.copy(rotation);
        this.renderState.bodyRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setBodyRotation(float x, float y, float z) {
        this.properties.bodyRot.updateDeg(x, y, z);
        this.renderState.bodyRot.updateDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setLeftArmRotation(Rotation rotation) {
        this.renderState.leftArmRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setLeftArmRotation(float x, float y, float z) {
        this.renderState.leftArmRot.updateDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setRightArmRotation(Rotation rotation) {
        this.renderState.rightArmRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setRightArmRotation(float x, float y, float z) {
        this.renderState.rightArmRot.updateDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setLeftLegRotation(Rotation rotation) {
        this.renderState.leftLegRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setLeftLegRotation(float x, float y, float z) {
        this.renderState.leftLegRot.updateDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setRightLegRotation(Rotation rotation) {
        this.renderState.rightLegRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setRightLegRotation(float x, float y, float z) {
        this.renderState.rightLegRot.updateDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setSlim(boolean isSlim) {
        this.properties.isSlim = isSlim;
        if (!this.renderState.copyingPlayer && this.properties.skin == null) {
            this.updateIsSlim(this.properties.isSlim);
            this.renderer = isSlim ? this.slimRenderer : this.wideRenderer;
        }
        return this;
    }

    public FancyPlayerWidget setSkin(@Nullable PlayerSkin skin) {
        this.properties.skin = skin;
        if (!this.renderState.copyingPlayer) {
            this.updateSkin(skin);
        }
        return this;
    }

    public FancyPlayerWidget copyLocalPlayer() {
        this.renderState.copyingPlayer = true;
        this.copyPlayer(Minecraft.getInstance().getGameProfile());
        return this;
    }

    public FancyPlayerWidget setName(String name) {
        this.properties.name = name;
        if (!this.renderState.copyingPlayer) {
            this.renderState.name = name;
        }
        return this;
    }

    public FancyPlayerWidget setShowName(boolean showName) {
        this.renderState.showPlayerName = showName;
        return this;
    }

    public FancyPlayerWidget setUpsideDown(boolean isUpsideDown) {
        this.renderState.isUpsideDown = isUpsideDown;
        return this;
    }

    @ApiStatus.Experimental
    public FancyPlayerWidget setSpectator(boolean isSpectator) {
        this.renderState.isSpectator = isSpectator;
        return this;
    }

    @ApiStatus.Experimental
    public FancyPlayerWidget setGlowing(boolean isGlowing) {
        this.renderState.appearsGlowing = isGlowing;
        return this;
    }

    @ApiStatus.Experimental
    public FancyPlayerWidget setMoving(boolean isMoving) {
        this.renderState.isMoving = isMoving;
        return this;
    }

    @ApiStatus.Experimental
    public FancyPlayerWidget setOnFire(boolean onFire) {
        this.renderState.displayFireAnimation = onFire;
        return this;
    }

    public FancyPlayerWidget setBaby(boolean isBaby) {
        this.renderState.isBaby = isBaby;
        if (isBaby) {
            this.properties.parrotOnLeftShoulder = this.renderState.parrotOnLeftShoulder;
            this.properties.parrotOnRightShoulder = this.renderState.parrotOnRightShoulder;
        } else {
            this.renderState.parrotOnLeftShoulder = this.properties.parrotOnLeftShoulder;
            this.renderState.parrotOnRightShoulder = this.properties.parrotOnRightShoulder;
        }
        return this;
    }

    @Deprecated(since="0.1.0", forRemoval=true)
    public FancyPlayerWidget setCrouching(boolean isCrouching) {
        this.renderState.isCrouching = isCrouching;
        return this;
    }

    public FancyPlayerWidget setRightHandItem(@Nullable Item item) {
        this.renderState.rightHandHeldItem = item;
        return this;
    }

    public FancyPlayerWidget setLeftHandItem(@Nullable Item item) {
        this.renderState.leftHandHeldItem = item;
        return this;
    }

    public FancyPlayerWidget setHeadWearable(@Nullable Item item) {
        this.renderState.headEquipment = item == null ? ItemStack.EMPTY : item.getDefaultInstance();
        return this;
    }

    public FancyPlayerWidget setChestWearable(@Nullable Item item) {
        this.renderState.chestEquipment = item == null ? ItemStack.EMPTY : item.getDefaultInstance();
        return this;
    }

    public FancyPlayerWidget setLegsWearable(@Nullable Item item) {
        this.renderState.legsEquipment = item == null ? ItemStack.EMPTY : item.getDefaultInstance();
        return this;
    }

    public FancyPlayerWidget setFeetWearable(@Nullable Item item) {
        this.renderState.feetEquipment = item == null ? ItemStack.EMPTY : item.getDefaultInstance();
        return this;
    }

    public FancyPlayerWidget setHeadWearable(@Nullable ItemStack item) {
        this.renderState.headEquipment = item == null ? ItemStack.EMPTY : item;
        return this;
    }

    public FancyPlayerWidget setChestWearable(@Nullable ItemStack item) {
        this.renderState.chestEquipment = item == null ? ItemStack.EMPTY : item;
        return this;
    }

    public FancyPlayerWidget setLegsWearable(@Nullable ItemStack item) {
        this.renderState.legsEquipment = item == null ? ItemStack.EMPTY : item;
        return this;
    }

    public FancyPlayerWidget setFeetWearable(@Nullable ItemStack item) {
        this.renderState.feetEquipment = item == null ? ItemStack.EMPTY : item;
        return this;
    }

    public FancyPlayerWidget copyPlayer(String profileName) {
        return this.copyPlayer(FancyProfileFetcher.fetchProfile(profileName), profileName);
    }

    public FancyPlayerWidget copyPlayer(UUID profileId) {
        return this.copyPlayer(FancyProfileFetcher.fetchProfile(profileId), profileId.toString());
    }

    public FancyPlayerWidget uncopyPlayer() {
        this.renderState.copyingPlayer = false;
        this.updateSkin(this.properties.skin);
        this.renderState.name = this.properties.name;
        return this;
    }

    public boolean isCopyingPlayer() {
        return this.renderState.copyingPlayer;
    }

    private FancyPlayerWidget copyPlayer(CompletableFuture<Optional<GameProfile>> result, String source) {
        ((CompletableFuture)result.exceptionally(FancyPlayerWidget::handlePlayerCopyError)).thenAccept(profile -> profile.ifPresentOrElse(this::copyPlayer, () -> FancyPlayerWidget.handlePlayerCopyError(source)));
        return this;
    }

    private FancyPlayerWidget copyPlayer(GameProfile profile) {
        ((CompletableFuture)Minecraft.getInstance().getSkinManager().getOrLoad(profile).exceptionally(FancyPlayerWidget::handlePlayerCopyError)).thenAccept(skin -> {
            this.renderState.copyingPlayer = true;
            this.properties.name = this.renderState.name;
            this.renderState.name = profile.getName();
            skin.ifPresentOrElse(this::updateSkin, () -> FancyPlayerWidget.handlePlayerCopyError(this.renderState.name));
        });
        return this;
    }

    private void updateSkin(@Nullable PlayerSkin skin) {
        if (skin != null) {
            this.renderState.isSlim = skin.model() == PlayerSkin.Model.SLIM;
            this.renderState.skin = skin;
        } else {
            this.updateIsSlim(this.properties.isSlim);
        }
        this.renderer = this.renderState.isSlim ? this.slimRenderer : this.wideRenderer;
    }

    private void updateIsSlim(boolean isSlim) {
        this.renderState.isSlim = isSlim;
        this.renderState.skin = DefaultPlayerSkin.DEFAULT_SKINS[this.random.nextInt(9) + (isSlim ? 0 : 9)];
    }

    private void updateRenderState(int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
        this.renderState.boundingBoxWidth = width;
        this.renderState.boundingBoxHeight = height;
        this.renderState.scale = (float)height / 1.875f;
        if (this.renderState.bodyFollowsMouse || this.renderState.headFollowsMouse) {
            float eyeY = this.renderState.isBaby ? (float)y + (float)height / 2.0f + 0.255f * (float)height / 1.875f / 2.0f : (float)y + 0.255f * (float)height / 1.875f;
            float eyeX = (float)x + (float)width / 2.0f;
            double mouseXRelative = (float)mouseX - eyeX;
            double mouseYRelative = (float)mouseY - eyeY;
            double xRot = Math.atan(mouseYRelative / 40.0) * 20.0;
            double yRot = -Math.atan(mouseXRelative / 40.0) * 20.0;
            if (this.renderState.isUpsideDown) {
                xRot = -xRot;
                yRot = -yRot;
            }
            if (this.renderState.bodyFollowsMouse) {
                this.renderState.bodyRot.setXDeg(xRot);
                this.renderState.bodyRot.setYDeg(yRot);
                this.renderState.bodyRot.setZ(0.0);
            }
            if (this.renderState.headFollowsMouse) {
                this.renderState.headRot.setXDeg(xRot);
                this.renderState.headRot.setYDeg(yRot);
                this.renderState.headRot.setZ(0.0);
            }
        }
    }

    private static final class OverridableProperties {
        final Rotation headRot = new Rotation();
        final Rotation bodyRot = new Rotation();
        boolean isSlim;
        @NotNull
        String name;
        @Nullable
        PlayerSkin skin;
        @Nullable
        Parrot.Variant parrotOnLeftShoulder;
        @Nullable
        Parrot.Variant parrotOnRightShoulder;

        private OverridableProperties(@NotNull String name) {
            this.name = name;
        }
    }
}

