/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.fancy_entity_renderer.api.entity.player.model;

import it.crystalnest.fancy_entity_renderer.api.entity.player.state.FancyPlayerRenderState;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.LayerDefinitions;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import org.jetbrains.annotations.NotNull;

public class FancyPlayerModel
extends PlayerModel {
    public FancyPlayerModel(EntityModelSet modelSet, boolean isSlim, boolean isBaby) {
        super(FancyPlayerModel.getModelPart(modelSet, isSlim, isBaby), isSlim);
    }

    private static ModelPart getModelPart(EntityModelSet modelSet, boolean isSlim, boolean isBaby) {
        LayerDefinition layerDefinition = (LayerDefinition)modelSet.roots.get(isSlim ? ModelLayers.PLAYER_SLIM : ModelLayers.PLAYER);
        if (isBaby) {
            layerDefinition = layerDefinition.apply(BABY_TRANSFORMER);
        }
        return layerDefinition.bakeRoot();
    }

    public static ModelPart getBabyArmorModel(boolean isInner) {
        return LayerDefinition.create((MeshDefinition)HumanoidArmorModel.createBodyLayer((CubeDeformation)(isInner ? LayerDefinitions.INNER_ARMOR_DEFORMATION : LayerDefinitions.OUTER_ARMOR_DEFORMATION)), (int)64, (int)32).apply(HumanoidModel.BABY_TRANSFORMER).bakeRoot();
    }

    public void setupAnim(@NotNull PlayerRenderState state) {
        super.setupAnim(state);
        this.update((FancyPlayerRenderState)state);
    }

    private void update(@NotNull FancyPlayerRenderState state) {
        this.leftArm.offsetRotation(state.leftArmRot.getOffset());
        this.rightArm.offsetRotation(state.rightArmRot.getOffset());
        this.leftLeg.offsetRotation(state.leftLegRot.getOffset());
        this.rightLeg.offsetRotation(state.rightLegRot.getOffset());
        this.head.offsetRotation(state.headRot.getOffset());
    }
}

