/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.fancy_entity_renderer.api.entity.player.mock;

import it.crystalnest.fancy_entity_renderer.platform.Services;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import org.jetbrains.annotations.NotNull;

public class FancyFrozenRegistryAccessMock
implements RegistryAccess.Frozen {
    private final Map<ResourceKey<? extends Registry<?>>, Registry<?>> registries = new ConcurrentHashMap();

    @NotNull
    public <E> Optional<Registry<E>> registry(@NotNull ResourceKey<? extends Registry<? extends E>> resourceKey) {
        return Optional.of(this.registries.computeIfAbsent(resourceKey, k -> Services.REGISTRY.mockRegistry(resourceKey)));
    }

    @NotNull
    public <E> Registry<E> registryOrThrow(@NotNull ResourceKey<? extends Registry<? extends E>> registryKey) {
        return this.registries.computeIfAbsent(registryKey, k -> Services.REGISTRY.mockRegistry(registryKey));
    }

    @NotNull
    public Stream<RegistryAccess.RegistryEntry<?>> registries() {
        return Stream.empty();
    }
}

