/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.fancy_entity_renderer.api.entity.player.mock;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Lifecycle;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FancyRegistryMock<T>
implements Registry<T> {
    private final ResourceKey<? extends Registry<T>> key;
    private final HolderLookup.RegistryLookup<T> lookup;

    public FancyRegistryMock(ResourceKey<? extends Registry<? extends T>> key) {
        this.key = key;
        this.lookup = new HolderLookup.RegistryLookup<T>(){

            @NotNull
            public ResourceKey<? extends Registry<? extends T>> key() {
                return FancyRegistryMock.this.key;
            }

            @NotNull
            public Lifecycle registryLifecycle() {
                return FancyRegistryMock.this.registryLifecycle();
            }

            @NotNull
            public Optional<Holder.Reference<T>> get(@NotNull ResourceKey<T> key) {
                return FancyRegistryMock.this.getHolder(key);
            }

            @NotNull
            public Optional<HolderSet.Named<T>> get(@NotNull TagKey<T> key) {
                return FancyRegistryMock.this.getTag(key);
            }

            @NotNull
            public Stream<Holder.Reference<T>> listElements() {
                return FancyRegistryMock.this.holders();
            }

            @NotNull
            public Stream<HolderSet.Named<T>> listTags() {
                return FancyRegistryMock.this.getTags().map(Pair::getSecond);
            }
        };
    }

    @NotNull
    public Iterator<T> iterator() {
        return Collections.emptyIterator();
    }

    @NotNull
    public ResourceKey<? extends Registry<T>> key() {
        return this.key;
    }

    @Nullable
    public ResourceLocation getKey(@NotNull T key) {
        return null;
    }

    @NotNull
    public Optional<ResourceKey<T>> getResourceKey(@NotNull T key) {
        return Optional.empty();
    }

    public int getId(@Nullable T key) {
        return 0;
    }

    @Nullable
    public T get(@Nullable ResourceKey<T> resourceKey) {
        return null;
    }

    @Nullable
    public T get(@Nullable ResourceLocation resourceLocation) {
        return null;
    }

    @NotNull
    public Optional<RegistrationInfo> registrationInfo(@NotNull ResourceKey<T> resourceKey) {
        return Optional.empty();
    }

    @NotNull
    public Lifecycle registryLifecycle() {
        return Lifecycle.stable();
    }

    @NotNull
    public Optional<Holder.Reference<T>> getAny() {
        return Optional.empty();
    }

    @NotNull
    public Set<ResourceLocation> keySet() {
        return Set.of();
    }

    @NotNull
    public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
        return Set.of();
    }

    @NotNull
    public Set<ResourceKey<T>> registryKeySet() {
        return Set.of();
    }

    @NotNull
    public Optional<Holder.Reference<T>> getRandom(@NotNull RandomSource randomSource) {
        return Optional.empty();
    }

    public boolean containsKey(@NotNull ResourceLocation resourceLocation) {
        return false;
    }

    public boolean containsKey(@NotNull ResourceKey<T> resourceKey) {
        return false;
    }

    @NotNull
    public Registry<T> freeze() {
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Holder.Reference<T> createIntrusiveHolder(@NotNull T key) {
        throw new IllegalStateException("This registry can't create intrusive holders");
    }

    @NotNull
    public Optional<Holder.Reference<T>> getHolder(int i) {
        return Optional.empty();
    }

    @NotNull
    public Optional<Holder.Reference<T>> getHolder(@NotNull ResourceLocation resourceLocation) {
        return Optional.empty();
    }

    @NotNull
    public Optional<Holder.Reference<T>> getHolder(@NotNull ResourceKey<T> resourceKey) {
        return Optional.empty();
    }

    @NotNull
    public Holder<T> wrapAsHolder(@NotNull T key) {
        return Holder.direct(key);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Holder.Reference<T> getHolderOrThrow(@NotNull ResourceKey<T> key) {
        return Holder.Reference.createStandAlone(this.holderOwner(), key);
    }

    @NotNull
    public Stream<Holder.Reference<T>> holders() {
        return Stream.empty();
    }

    @NotNull
    public Optional<HolderSet.Named<T>> getTag(@NotNull TagKey<T> tagKey) {
        return Optional.empty();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull HolderSet.Named<T> getOrCreateTag(@NotNull TagKey<T> tagKey) {
        return HolderSet.emptyNamed(this.holderOwner(), tagKey);
    }

    @NotNull
    public Stream<Pair<TagKey<T>, HolderSet.Named<T>>> getTags() {
        return Stream.empty();
    }

    @NotNull
    public Stream<TagKey<T>> getTagNames() {
        return Stream.empty();
    }

    public void resetTags() {
    }

    public void bindTags(@NotNull Map<TagKey<T>, List<Holder<T>>> map) {
    }

    @NotNull
    public HolderOwner<T> holderOwner() {
        return this.lookup;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.RegistryLookup<T> asLookup() {
        return this.lookup;
    }

    @Nullable
    public T byId(int i) {
        return null;
    }

    public int size() {
        return 0;
    }
}

