/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.fancy_entity_renderer.api;

import java.util.Objects;
import org.joml.Vector3f;

public class Rotation {
    private float x;
    private float y;
    private float z;

    public Rotation(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Rotation() {
        this(0.0f, 0.0f, 0.0f);
    }

    public static Rotation fromRad(float x, float y, float z) {
        return new Rotation(x, y, z);
    }

    public static Rotation fromDeg(float x, float y, float z) {
        return new Rotation().setXDeg(x).setYDeg(y).setZDeg(z);
    }

    public float getX() {
        return this.x;
    }

    public Rotation setX(double x) {
        this.x = (float)x;
        return this;
    }

    public float getXDeg() {
        return (float)Math.toDegrees(this.x);
    }

    public Rotation setXDeg(double x) {
        this.setX(Math.toRadians(x));
        return this;
    }

    public float getY() {
        return this.y;
    }

    public Rotation setY(double y) {
        this.y = (float)y;
        return this;
    }

    public float getYDeg() {
        return (float)Math.toDegrees(this.y);
    }

    public Rotation setYDeg(double y) {
        this.setY(Math.toRadians(y));
        return this;
    }

    public float getZ() {
        return this.z;
    }

    public Rotation setZ(double z) {
        this.z = (float)z;
        return this;
    }

    public float getZDeg() {
        return (float)Math.toDegrees(this.z);
    }

    public Rotation setZDeg(double z) {
        this.setZ(Math.toRadians(z));
        return this;
    }

    public Vector3f getOffset() {
        return new Vector3f(this.getX(), this.getY(), this.getZ());
    }

    public Vector3f getOffsetDeg() {
        return new Vector3f(this.getXDeg(), this.getYDeg(), this.getZDeg());
    }

    public Rotation copy(Rotation rotation) {
        return this.setX(rotation.getX()).setY(rotation.getY()).setZ(rotation.getZ());
    }

    public Rotation set(double x, double y, double z) {
        return this.setX(x).setY(y).setZ(z);
    }

    public Rotation setDeg(double x, double y, double z) {
        return this.setXDeg(x).setYDeg(y).setZDeg(z);
    }

    public Rotation add(double x, double y, double z) {
        return this.set((double)this.getX() + x, (double)this.getY() + y, (double)this.getZ() + z);
    }

    public Rotation addDegrees(double x, double y, double z) {
        return this.set((double)this.getX() + x, (double)this.getY() + y, (double)this.getZ() + z);
    }

    public Rotation add(Rotation rotation) {
        return this.set(this.getX() + rotation.getX(), this.getY() + rotation.getY(), this.getZ() + rotation.getZ());
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Rotation)) {
            return false;
        }
        Rotation rotation = (Rotation)o;
        return Float.compare(this.x, rotation.x) == 0 && Float.compare(this.y, rotation.y) == 0 && Float.compare(this.z, rotation.z) == 0;
    }

    public String toString() {
        return "Rotation{xr=" + this.getX() + ", yr=" + this.getY() + ", zr=" + this.getZ() + ", xd=" + this.getXDeg() + ", yd=" + this.getYDeg() + ", zd=" + this.getZDeg() + "}";
    }
}

