/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.fancy_entity_renderer.api.entity.player;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.crystalnest.fancy_entity_renderer.api.entity.player.layer.FancyCapeLayer;
import it.crystalnest.fancy_entity_renderer.api.entity.player.model.FancyPlayerModel;
import it.crystalnest.fancy_entity_renderer.api.entity.player.state.FancyPlayerRenderState;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.ArmorModelSet;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class FancyPlayerRenderer
extends AvatarRenderer<AbstractClientPlayer> {
    private final FancyPlayerModel adultModel;
    private final FancyPlayerModel babyModel;

    public FancyPlayerRenderer(EntityRendererProvider.Context context, boolean isSlim) {
        super(context, isSlim);
        this.adultModel = new FancyPlayerModel(context.getModelSet(), isSlim, false);
        this.babyModel = new FancyPlayerModel(context.getModelSet(), isSlim, true);
        this.model = this.adultModel;
        this.layers.replaceAll(layer -> {
            RenderLayer renderLayer = layer;
            Objects.requireNonNull(renderLayer);
            RenderLayer selector0$temp = renderLayer;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HumanoidArmorLayer.class, CapeLayer.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    HumanoidArmorLayer l = (HumanoidArmorLayer)selector0$temp;
                    yield new HumanoidArmorLayer((RenderLayerParent)this, ArmorModelSet.bake((ArmorModelSet)(isSlim ? ModelLayers.PLAYER_SLIM_ARMOR : ModelLayers.PLAYER_ARMOR), (EntityModelSet)context.getModelSet(), part -> new PlayerModel(part, isSlim)), FancyPlayerModel.getBabyArmorModel(isSlim), context.getEquipmentRenderer());
                }
                case 1 -> {
                    CapeLayer l = (CapeLayer)selector0$temp;
                    yield new FancyCapeLayer((RenderLayerParent<AvatarRenderState, PlayerModel>)this, context.getModelSet(), context.getEquipmentAssets());
                }
                default -> layer;
            };
        });
    }

    protected void submitNameTag(@NotNull AvatarRenderState renderState, @NotNull PoseStack poseStack, @NotNull SubmitNodeCollector submitNodeCollector, @NotNull CameraRenderState camera) {
        if (renderState instanceof FancyPlayerRenderState) {
            FancyPlayerRenderState state = (FancyPlayerRenderState)renderState;
            if (state.nameTag != null && state.nameTagAttachment != null) {
                FormattedCharSequence text = state.nameTag.getVisualOrderText();
                Minecraft minecraft = Minecraft.getInstance();
                poseStack.pushPose();
                float scale = state.scale * 0.025f;
                float height = state.isBaby && state.pose != Pose.SPIN_ATTACK ? state.boundingBoxHeight * 0.5f : state.boundingBoxHeight;
                float offsetY = (state.pose == Pose.SLEEPING || state.pose == Pose.SWIMMING ? state.boundingBoxWidth : height) / scale + (float)state.nameTagAttachment.y;
                poseStack.scale(scale, -scale, scale);
                if (state.pinName) {
                    poseStack.rotateAround((Quaternionfc)new Quaternionf().rotateY(state.modelRot.getY()), 0.0f, 0.0f, 0.0f);
                }
                poseStack.translate(0.0f, -offsetY, 0.0f);
                if (state.deathTime > 1.0f) {
                    poseStack.rotateAround((Quaternionfc)Axis.ZP.rotationDegrees(Math.min(Mth.sqrt((float)((state.deathTime - 1.0f) / 20.0f * 1.6f)), 1.0f) * 90.0f), 0.0f, offsetY, 0.0f);
                }
                float x = (float)(-minecraft.font.width(text)) / 2.0f;
                submitNodeCollector.submitText(poseStack, x, 0.0f, text, false, Font.DisplayMode.SEE_THROUGH, state.lightCoords, -2130706433, (int)(minecraft.options.getBackgroundOpacity(0.25f) * 255.0f) << 24, 0);
                submitNodeCollector.submitText(poseStack, x, 0.0f, text, false, Font.DisplayMode.NORMAL, LightTexture.lightCoordsWithEmission((int)state.lightCoords, (int)2), state.isDiscrete ? -2130706433 : -1, 0, 0);
                poseStack.popPose();
            }
        }
    }

    @NotNull
    public FancyPlayerRenderState createRenderState() {
        return new FancyPlayerRenderState();
    }

    public void extractRenderState(@Nullable AbstractClientPlayer player, @NotNull AvatarRenderState renderState, float partialTick) {
        if (renderState instanceof FancyPlayerRenderState) {
            FancyPlayerRenderState state = (FancyPlayerRenderState)renderState;
            if (state.mimickedPlayer != null) {
                float height = state.boundingBoxHeight;
                boolean isBaby = state.isBaby;
                boolean isUpsideDown = state.isUpsideDown;
                super.extractRenderState((Avatar)state.mimickedPlayer, renderState, partialTick);
                this.mimicRenderState(state, height, isBaby, isUpsideDown);
            } else {
                this.updateRenderState(state);
            }
        }
    }

    protected void setupRotations(@NotNull AvatarRenderState state, @NotNull PoseStack poseStack, float bodyRot, float scale) {
        if (state.pose == Pose.SPIN_ATTACK) {
            poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(90.0f));
        }
        super.setupRotations(state, poseStack, bodyRot, scale);
        if (state.isUpsideDown) {
            if (state.pose == Pose.DYING || state.pose == Pose.SPIN_ATTACK) {
                poseStack.translate(0.0f, (state.boundingBoxHeight + 0.1f) / scale, 0.0f);
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
            } else if (state.pose == Pose.SLEEPING) {
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
            }
        }
    }

    public void submit(@NotNull AvatarRenderState state, @NotNull PoseStack poseStack, @NotNull SubmitNodeCollector submitNodeCollector, @NotNull CameraRenderState camera) {
        this.model = state.isBaby ? this.babyModel : this.adultModel;
        super.submit(state, poseStack, submitNodeCollector, camera);
    }

    protected void mimicRenderState(@NotNull FancyPlayerRenderState state, float height, boolean isBaby, boolean isUpsideDown) {
        state.updateScale(height);
        state.bodyRot = 0.0f;
        if (!state.allowedPoses.contains(state.pose)) {
            state.pose = Pose.STANDING;
        }
        state.isFallFlying = state.pose == Pose.FALL_FLYING;
        state.isAutoSpinAttack = state.pose == Pose.SPIN_ATTACK;
        state.isCrouching = state.pose == Pose.CROUCHING;
        boolean bl = state.isVisuallySwimming = state.pose == Pose.SWIMMING;
        if (!state.isVisuallySwimming) {
            state.swimAmount = 0.0f;
        }
        boolean bl2 = state.hasRedOverlay = state.pose == Pose.DYING;
        if (!state.hasRedOverlay) {
            state.deathTime = 0.0f;
        }
        if (state.pose != Pose.STANDING && state.pose != Pose.CROUCHING) {
            state.displayFireAnimation = false;
        }
        if (state.pose == Pose.SWIMMING) {
            state.parrotOnLeftShoulder = null;
            state.parrotOnRightShoulder = null;
        }
        state.isBaby = isBaby;
        state.isUpsideDown = isUpsideDown;
    }

    protected void updateRenderState(@NotNull FancyPlayerRenderState state) {
        state.eyeHeight = ((EntityDimensions)Avatar.POSES.get(state.pose)).eyeHeight();
        boolean bl = state.isDiscrete = state.isCrouching || state.isInvisible;
        if (state.isMoving && state.pose != Pose.DYING) {
            float step = state.speedValue * 0.33f;
            state.ageInTicks += step;
            state.walkAnimationPos += step;
            state.walkAnimationSpeed = state.pose != Pose.SPIN_ATTACK && state.pose != Pose.SLEEPING ? state.walkSpeed : 0.0f;
        } else {
            state.ageInTicks = 3000.0f;
            state.walkAnimationPos = 0.0f;
            state.walkAnimationSpeed = 0.0f;
        }
        state.nameTag = state.showPlayerName && !state.isInvisibleToPlayer ? Component.literal((String)state.name) : null;
        state.nameTagAttachment = state.pose == Pose.SLEEPING ? new Vec3((double)(((EntityDimensions)Avatar.POSES.get(state.pose)).eyeHeight() * state.scale - state.boundingBoxHeight / 1.35f), 0.0, 0.0) : new Vec3(0.0, (double)(0.25f * state.scale), 0.0);
        if (state.rightHandHeldItem != null) {
            this.itemModelResolver.updateForTopItem(state.rightHandItem, state.rightHandHeldItem, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, null, null, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND.ordinal());
        }
        if (state.leftHandHeldItem != null) {
            this.itemModelResolver.updateForTopItem(state.leftHandItem, state.leftHandHeldItem, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, null, null, ItemDisplayContext.THIRD_PERSON_LEFT_HAND.ordinal());
        }
        state.elytraRotX = 0.19634955f;
        state.elytraRotZ = 0.31415927f;
    }
}

