/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.fancy_entity_renderer.api.entity.player.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import it.crystalnest.fancy_entity_renderer.api.entity.player.model.FancyPlayerCapeModel;
import java.util.Optional;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.EquipmentAssetManager;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.ClientAsset;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;
import org.jetbrains.annotations.NotNull;

public class FancyCapeLayer
extends RenderLayer<AvatarRenderState, PlayerModel> {
    private final HumanoidModel<AvatarRenderState> adultModel;
    private final HumanoidModel<AvatarRenderState> babyModel;
    private final EquipmentAssetManager equipmentAssets;

    public FancyCapeLayer(RenderLayerParent<AvatarRenderState, PlayerModel> renderer, EntityModelSet modelSet, EquipmentAssetManager equipmentAssets) {
        super(renderer);
        this.adultModel = new FancyPlayerCapeModel(modelSet, false);
        this.babyModel = new FancyPlayerCapeModel(modelSet, true);
        this.equipmentAssets = equipmentAssets;
    }

    private boolean hasLayer(ItemStack stack, EquipmentClientInfo.LayerType layer) {
        Equippable equippable = (Equippable)stack.get(DataComponents.EQUIPPABLE);
        if (equippable != null) {
            Optional assetId = equippable.assetId();
            return assetId.isPresent() && !this.equipmentAssets.get((ResourceKey)assetId.get()).getLayers(layer).isEmpty();
        }
        return false;
    }

    public void submit(@NotNull PoseStack poseStack, @NotNull SubmitNodeCollector submitNodeCollector, int i, AvatarRenderState renderState, float v, float v1) {
        ClientAsset.Texture capeTexture;
        if (!renderState.isInvisible && renderState.showCape && (capeTexture = renderState.skin.cape()) != null && !this.hasLayer(renderState.chestEquipment, EquipmentClientInfo.LayerType.WINGS)) {
            poseStack.pushPose();
            if (this.hasLayer(renderState.chestEquipment, EquipmentClientInfo.LayerType.HUMANOID)) {
                poseStack.translate(0.0f, -0.053125f, 0.06875f);
            }
            HumanoidModel<AvatarRenderState> model = renderState.isBaby ? this.babyModel : this.adultModel;
            model.setupAnim((HumanoidRenderState)renderState);
            submitNodeCollector.submitModel(model, (Object)renderState, poseStack, RenderType.entitySolid((ResourceLocation)capeTexture.texturePath()), i, OverlayTexture.NO_OVERLAY, renderState.outlineColor, null);
            poseStack.popPose();
        }
    }
}

