/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.fancy_entity_renderer.api.entity.player;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.crystalnest.fancy_entity_renderer.Constants;
import it.crystalnest.fancy_entity_renderer.api.Rotation;
import it.crystalnest.fancy_entity_renderer.api.entity.RenderMode;
import it.crystalnest.fancy_entity_renderer.api.entity.player.FancyPlayerRenderer;
import it.crystalnest.fancy_entity_renderer.api.entity.player.FancyProfileFetcher;
import it.crystalnest.fancy_entity_renderer.api.entity.player.state.FancyPlayerRenderState;
import it.crystalnest.fancy_entity_renderer.compat.Prometheus;
import it.crystalnest.fancy_entity_renderer.platform.Services;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.class_10017;
import net.minecraft.class_10055;
import net.minecraft.class_1068;
import net.minecraft.class_1144;
import net.minecraft.class_1306;
import net.minecraft.class_1453;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2290;
import net.minecraft.class_2291;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5244;
import net.minecraft.class_572;
import net.minecraft.class_6382;
import net.minecraft.class_7225;
import net.minecraft.class_742;
import net.minecraft.class_8685;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class FancyPlayerWidget
extends class_339 {
    public static final float PLAYER_RENDER_HEIGHT = 1.875f;
    public static final float PLAYER_CROUCHING_EYE_HEIGHT = ((class_4048)class_1657.field_18134.get(class_4050.field_18081)).comp_2187();
    public static final float PLAYER_SIZE_RATIO = 2.9999998f;
    protected final FancyPlayerRenderState renderState = new FancyPlayerRenderState();
    protected final Random random = new Random();
    private final FancyPlayerRenderer wideRenderer = new FancyPlayerRenderer(this.renderState, false);
    private final FancyPlayerRenderer slimRenderer = new FancyPlayerRenderer(this.renderState, true);
    protected FancyPlayerRenderer renderer;
    private final OverridableProperties properties;

    public FancyPlayerWidget(int x, int y, int width, int height) {
        super(x, y, width, height, class_5244.field_39003);
        this.renderer = this.renderState.isSlim ? this.slimRenderer : this.wideRenderer;
        this.properties = new OverridableProperties(this.renderState.field_53529);
    }

    private static void handlePlayerCopyError(String source) {
        Constants.LOGGER.error("Failed to copy player \"{}\"", (Object)source);
    }

    private static <T> Optional<T> handlePlayerCopyError(Throwable error) {
        Constants.LOGGER.error("Copy of player failed with error!", error);
        return Optional.empty();
    }

    protected void method_48579(@NotNull class_332 gfx, int mouseX, int mouseY, float partialTick) {
        this.updateRenderState(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), mouseX, mouseY, partialTick);
        float offsetX = 0.0f;
        float offsetY = (float)this.renderer.method_23206((class_10055)this.renderState).field_1351;
        if (this.renderState.field_53465 == class_4050.field_18078) {
            offsetX += 1.875f * this.renderState.field_53453 / 2.0f;
            offsetY -= 0.25f * this.renderState.field_53453;
            if (this.renderState.field_53457) {
                offsetX /= 1.75f;
                offsetY /= 1.5f;
            }
        }
        this.renderState.renderer = this.renderer;
        gfx.method_70856((class_10017)this.renderState, 1.0f, new Vector3f(offsetX - (float)(class_310.method_1551().method_22683().method_4486() - this.method_25368()) / 2.0f + (float)this.method_46426(), offsetY - (float)class_310.method_1551().method_22683().method_4502() / 2.0f + (float)this.method_46427() + (float)this.method_25364(), 0.0f), new Quaternionf().rotateXYZ(this.renderState.modelRot.getX(), -this.renderState.modelRot.getY(), this.renderState.modelRot.getZ()), new Quaternionf().rotateXYZ(-this.renderState.modelRot.getX(), this.renderState.modelRot.getY(), -this.renderState.modelRot.getZ()), 0, 0, class_310.method_1551().method_22683().method_4486(), class_310.method_1551().method_22683().method_4502());
    }

    public void method_25354(@NotNull class_1144 soundManager) {
    }

    protected void method_47399(@NotNull class_6382 output) {
    }

    public FancyPlayerWidget setBodyFollowsMouse(boolean followsMouse) {
        if (this.renderState.field_53465 == class_4050.field_18076 || this.renderState.field_53465 == class_4050.field_18081 || this.renderState.field_53465 == class_4050.field_18080) {
            this.renderState.bodyFollowsMouse = followsMouse;
            if (followsMouse) {
                this.properties.bodyRot.copy(this.renderState.modelRot);
            } else {
                this.renderState.modelRot.copy(this.properties.bodyRot);
            }
        } else {
            this.properties.bodyFollowsMouse = followsMouse;
        }
        return this;
    }

    public FancyPlayerWidget setHeadFollowsMouse(boolean followsMouse) {
        if (this.renderState.field_53465 == class_4050.field_18076 || this.renderState.field_53465 == class_4050.field_18081 || this.renderState.field_53465 == class_4050.field_18080) {
            this.renderState.headFollowsMouse = followsMouse;
            if (followsMouse) {
                this.properties.headRot.copy(this.renderState.headRot);
            } else {
                this.renderState.headRot.copy(this.properties.headRot);
            }
        } else {
            this.properties.headFollowsMouse = followsMouse;
        }
        return this;
    }

    public FancyPlayerWidget setHeadRotation(Rotation rotation) {
        this.properties.headRot.copy(rotation);
        this.renderState.headRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setHeadRotation(float x, float y, float z) {
        this.properties.headRot.setDeg(x, y, z);
        this.renderState.headRot.setDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setBodyRotation(Rotation rotation) {
        this.properties.bodyRot.copy(rotation);
        this.renderState.modelRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setBodyRotation(float x, float y, float z) {
        this.properties.bodyRot.setDeg(x, y, z);
        this.renderState.modelRot.setDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setLeftArmRotation(Rotation rotation) {
        this.renderState.leftArmRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setLeftArmRotation(float x, float y, float z) {
        this.renderState.leftArmRot.setDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setRightArmRotation(Rotation rotation) {
        this.renderState.rightArmRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setRightArmRotation(float x, float y, float z) {
        this.renderState.rightArmRot.setDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setLeftLegRotation(Rotation rotation) {
        this.renderState.leftLegRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setLeftLegRotation(float x, float y, float z) {
        this.renderState.leftLegRot.setDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setRightLegRotation(Rotation rotation) {
        this.renderState.rightLegRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setRightLegRotation(float x, float y, float z) {
        this.renderState.rightLegRot.setDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setSlim(boolean isSlim) {
        this.properties.isSlim = isSlim;
        if (!this.renderState.copyingPlayer && this.properties.skin == null) {
            this.updateIsSlim(this.properties.isSlim);
            this.renderer = isSlim ? this.slimRenderer : this.wideRenderer;
        }
        return this;
    }

    public FancyPlayerWidget setSkin(@Nullable class_8685 skin) {
        this.properties.skin = skin;
        if (!this.renderState.copyingPlayer) {
            this.updateSkin(skin);
        }
        return this;
    }

    public FancyPlayerWidget copyLocalPlayer() {
        this.renderState.copyingPlayer = true;
        this.copyPlayer(class_310.method_1551().method_53462());
        return this;
    }

    public FancyPlayerWidget setName(String name) {
        this.properties.name = name;
        if (!this.renderState.copyingPlayer) {
            this.renderState.field_53529 = name;
        }
        return this;
    }

    public FancyPlayerWidget setPinName(boolean pinName) {
        this.renderState.pinName = pinName;
        return this;
    }

    public FancyPlayerWidget setShowName(boolean showName) {
        this.renderState.showPlayerName = showName;
        return this;
    }

    public FancyPlayerWidget setShowCape(boolean showCape) {
        this.renderState.field_53532 = showCape;
        return this;
    }

    public FancyPlayerWidget setShowLeftArm(boolean showLeftArm) {
        this.renderState.showLeftArm = showLeftArm;
        return this;
    }

    public FancyPlayerWidget setShowLeftSleeve(boolean showLeftSleeve) {
        this.renderState.field_53530 = showLeftSleeve;
        return this;
    }

    public FancyPlayerWidget setShowRightArm(boolean showRightArm) {
        this.renderState.showRightArm = showRightArm;
        return this;
    }

    public FancyPlayerWidget setShowRightSleeve(boolean showRightSleeve) {
        this.renderState.field_53531 = showRightSleeve;
        return this;
    }

    public FancyPlayerWidget setShowLeftLeg(boolean showLeftLeg) {
        this.renderState.showLeftLeg = showLeftLeg;
        return this;
    }

    public FancyPlayerWidget setShowLeftPants(boolean showLeftPants) {
        this.renderState.field_53545 = showLeftPants;
        return this;
    }

    public FancyPlayerWidget setShowRightLeg(boolean showRightLeg) {
        this.renderState.showRightLeg = showRightLeg;
        return this;
    }

    public FancyPlayerWidget setShowRightPants(boolean showRightPants) {
        this.renderState.field_53546 = showRightPants;
        return this;
    }

    public FancyPlayerWidget setShowHead(boolean showHead) {
        this.renderState.showHead = showHead;
        return this;
    }

    public FancyPlayerWidget setShowHat(boolean showHat) {
        this.renderState.field_53543 = showHat;
        return this;
    }

    public FancyPlayerWidget setShowBody(boolean showBody) {
        this.renderState.showBody = showBody;
        return this;
    }

    public FancyPlayerWidget setShowJacket(boolean showJacket) {
        this.renderState.field_53544 = showJacket;
        return this;
    }

    public FancyPlayerWidget setShowOuterLayer(boolean showOuterLayer) {
        this.setShowLeftSleeve(showOuterLayer);
        this.setShowRightSleeve(showOuterLayer);
        this.setShowLeftPants(showOuterLayer);
        this.setShowRightPants(showOuterLayer);
        this.setShowHat(showOuterLayer);
        this.setShowJacket(showOuterLayer);
        return this;
    }

    public FancyPlayerWidget setShowInnerLayer(boolean showInnerLayer) {
        this.setShowLeftArm(showInnerLayer);
        this.setShowRightArm(showInnerLayer);
        this.setShowLeftLeg(showInnerLayer);
        this.setShowRightLeg(showInnerLayer);
        this.setShowHead(showInnerLayer);
        this.setShowBody(showInnerLayer);
        return this;
    }

    public FancyPlayerWidget setUpsideDown(boolean isUpsideDown) {
        this.renderState.field_53455 = isUpsideDown;
        return this;
    }

    public FancyPlayerWidget setRenderMode(RenderMode mode) {
        this.renderState.field_53542 = RenderMode.SPECTATOR == mode;
        this.renderState.field_53333 = RenderMode.NORMAL != mode;
        this.renderState.field_53461 = RenderMode.INVISIBLE == mode;
        return this;
    }

    @ApiStatus.Experimental
    public FancyPlayerWidget setGlowing(boolean isGlowing) {
        this.renderState.field_53462 = isGlowing;
        return this;
    }

    public FancyPlayerWidget setMoving(boolean isMoving) {
        this.renderState.isMoving = isMoving;
        return this;
    }

    public FancyPlayerWidget setOnFire(boolean onFire) {
        if (this.renderState.field_53465 == class_4050.field_18076 || this.renderState.field_53465 == class_4050.field_18081) {
            this.renderState.field_53335 = onFire;
        } else {
            this.properties.displayFireAnimation = onFire;
        }
        return this;
    }

    public FancyPlayerWidget setOnFire(boolean onFire, class_2960 fireType) {
        if (Services.PLATFORM.isModLoaded("prometheus")) {
            Prometheus.setOnFire((class_10017)this.renderState, fireType);
        }
        return this.setOnFire(onFire);
    }

    public FancyPlayerWidget setArrowCount(int count) {
        this.renderState.field_53539 = count;
        return this;
    }

    public FancyPlayerWidget setStingerCount(int count) {
        this.renderState.field_53540 = count;
        return this;
    }

    public FancyPlayerWidget setLeftParrot(@Nullable class_1453.class_7989 parrot) {
        if (this.renderState.field_53457 || this.renderState.field_53465 == class_4050.field_18079) {
            this.properties.parrotOnLeftShoulder = parrot;
        } else {
            this.renderState.field_53526 = parrot;
        }
        return this;
    }

    public FancyPlayerWidget setRightParrot(@Nullable class_1453.class_7989 parrot) {
        if (this.renderState.field_53457 || this.renderState.field_53465 == class_4050.field_18079) {
            this.properties.parrotOnRightShoulder = parrot;
        } else {
            this.renderState.field_53527 = parrot;
        }
        return this;
    }

    public FancyPlayerWidget setParrots(@Nullable class_1453.class_7989 left, @Nullable class_1453.class_7989 right) {
        if (this.renderState.field_53457 || this.renderState.field_53465 == class_4050.field_18079) {
            this.properties.parrotOnLeftShoulder = left;
            this.properties.parrotOnRightShoulder = right;
        } else {
            this.renderState.field_53526 = left;
            this.renderState.field_53527 = right;
        }
        return this;
    }

    public FancyPlayerWidget setBaby(boolean isBaby) {
        this.renderState.field_53457 = isBaby;
        if (isBaby) {
            this.properties.parrotOnLeftShoulder = this.renderState.field_53526;
            this.properties.parrotOnRightShoulder = this.renderState.field_53527;
        } else {
            this.renderState.field_53526 = this.properties.parrotOnLeftShoulder;
            this.renderState.field_53527 = this.properties.parrotOnRightShoulder;
        }
        return this;
    }

    public FancyPlayerWidget setPose(class_4050 pose) {
        if (class_1657.field_18134.containsKey(pose) && pose != class_4050.field_18077) {
            this.renderState.field_53465 = pose;
            this.renderState.field_53459 = pose == class_4050.field_18080;
            this.renderState.field_53410 = pose == class_4050.field_18081;
            this.renderState.field_53412 = pose == class_4050.field_18079;
            this.renderState.field_53403 = this.renderState.field_53412 ? 1.0f : 0.0f;
            this.renderState.field_53460 = pose == class_4050.field_18082;
            float f = this.renderState.field_53449 = this.renderState.field_53460 ? 5.0f : 0.0f;
            if (pose == class_4050.field_18076 || pose == class_4050.field_18081) {
                this.renderState.field_53335 = this.properties.displayFireAnimation;
            } else {
                this.properties.displayFireAnimation = this.renderState.field_53335;
                this.renderState.field_53335 = false;
            }
            if (pose == class_4050.field_18076 || pose == class_4050.field_18081 || pose == class_4050.field_18080) {
                this.renderState.headFollowsMouse = this.properties.headFollowsMouse;
                this.renderState.bodyFollowsMouse = this.properties.bodyFollowsMouse;
            } else {
                this.properties.headFollowsMouse = this.renderState.headFollowsMouse;
                this.properties.bodyFollowsMouse = this.renderState.bodyFollowsMouse;
                this.renderState.headFollowsMouse = false;
                this.renderState.bodyFollowsMouse = false;
            }
            if (pose == class_4050.field_18079) {
                this.properties.parrotOnLeftShoulder = this.renderState.field_53526;
                this.properties.parrotOnRightShoulder = this.renderState.field_53527;
                this.renderState.field_53526 = null;
                this.renderState.field_53527 = null;
            } else {
                this.renderState.field_53526 = this.properties.parrotOnLeftShoulder;
                this.renderState.field_53527 = this.properties.parrotOnRightShoulder;
            }
        } else {
            Constants.LOGGER.warn("Pose {} is not supported for Player entity!", (Object)pose);
        }
        return this;
    }

    public FancyPlayerWidget setRightArmPose(class_572.class_573 pose) {
        this.renderState.field_55304 = pose;
        return this;
    }

    public FancyPlayerWidget setLeftArmPose(class_572.class_573 pose) {
        this.renderState.field_55306 = pose;
        return this;
    }

    public FancyPlayerWidget setMovementSpeed(float speed) {
        this.renderState.field_53405 = speed;
        return this;
    }

    public FancyPlayerWidget setWalkingSpeed(float speed) {
        this.renderState.walkSpeed = speed;
        return this;
    }

    public FancyPlayerWidget setRightHandItem(@Nullable String item, class_7225.class_7874 provider) {
        this.renderState.rightHandHeldItem = this.getNullableItem(item, i -> this.parseItem((String)i, provider));
        return this;
    }

    public FancyPlayerWidget setLeftHandItem(@Nullable String item, class_7225.class_7874 provider) {
        this.renderState.leftHandHeldItem = this.getNullableItem(item, i -> this.parseItem((String)i, provider));
        return this;
    }

    public FancyPlayerWidget setRightHandItem(@Nullable class_1792 item) {
        this.renderState.rightHandHeldItem = this.getNullableItem(item, class_1792::method_7854);
        return this;
    }

    public FancyPlayerWidget setLeftHandItem(@Nullable class_1792 item) {
        this.renderState.leftHandHeldItem = this.getNullableItem(item, class_1792::method_7854);
        return this;
    }

    public FancyPlayerWidget setRightHandItem(@Nullable class_1799 item) {
        this.renderState.rightHandHeldItem = this.getNullableItem(item, i -> i);
        return this;
    }

    public FancyPlayerWidget setLeftHandItem(@Nullable class_1799 item) {
        this.renderState.leftHandHeldItem = this.getNullableItem(item, i -> i);
        return this;
    }

    public FancyPlayerWidget setHeadWearable(@Nullable String item, class_7225.class_7874 provider) {
        this.renderState.field_55309 = this.getNullableItem(item, i -> this.parseItem((String)i, provider));
        return this;
    }

    public FancyPlayerWidget setChestWearable(@Nullable String item, class_7225.class_7874 provider) {
        this.renderState.field_53418 = this.getNullableItem(item, i -> this.parseItem((String)i, provider));
        return this;
    }

    public FancyPlayerWidget setLegsWearable(@Nullable String item, class_7225.class_7874 provider) {
        this.renderState.field_53419 = this.getNullableItem(item, i -> this.parseItem((String)i, provider));
        return this;
    }

    public FancyPlayerWidget setFeetWearable(@Nullable String item, class_7225.class_7874 provider) {
        this.renderState.field_53420 = this.getNullableItem(item, i -> this.parseItem((String)i, provider));
        return this;
    }

    public FancyPlayerWidget setHeadWearable(@Nullable class_1792 item) {
        this.renderState.field_55309 = this.getNullableItem(item, class_1792::method_7854);
        return this;
    }

    public FancyPlayerWidget setChestWearable(@Nullable class_1792 item) {
        this.renderState.field_53418 = this.getNullableItem(item, class_1792::method_7854);
        return this;
    }

    public FancyPlayerWidget setLegsWearable(@Nullable class_1792 item) {
        this.renderState.field_53419 = this.getNullableItem(item, class_1792::method_7854);
        return this;
    }

    public FancyPlayerWidget setFeetWearable(@Nullable class_1792 item) {
        this.renderState.field_53420 = this.getNullableItem(item, class_1792::method_7854);
        return this;
    }

    public FancyPlayerWidget setHeadWearable(@Nullable class_1799 item) {
        this.renderState.field_55309 = this.getNullableItem(item, i -> i);
        return this;
    }

    public FancyPlayerWidget setChestWearable(@Nullable class_1799 item) {
        this.renderState.field_53418 = this.getNullableItem(item, i -> i);
        return this;
    }

    public FancyPlayerWidget setLegsWearable(@Nullable class_1799 item) {
        this.renderState.field_53419 = this.getNullableItem(item, i -> i);
        return this;
    }

    public FancyPlayerWidget setFeetWearable(@Nullable class_1799 item) {
        this.renderState.field_53420 = this.getNullableItem(item, i -> i);
        return this;
    }

    public FancyPlayerWidget setAttackTime(float attackTime) {
        if (attackTime >= 0.0f) {
            this.renderState.field_53404 = attackTime % 1.0f;
        }
        return this;
    }

    public FancyPlayerWidget setAttackArm(class_1306 attackArm) {
        this.renderState.field_53408 = attackArm;
        return this;
    }

    public FancyPlayerWidget mimicLocalPlayer() {
        return this.mimicPlayer((class_742)class_310.method_1551().field_1724);
    }

    public FancyPlayerWidget mimicPlayer(@Nullable class_742 player) {
        this.renderState.mimickedPlayer = player;
        return this;
    }

    public FancyPlayerWidget unmimicPlayer() {
        this.renderState.mimickedPlayer = null;
        return this;
    }

    public boolean isMimickingPlayer() {
        return this.renderState.mimickedPlayer != null;
    }

    public FancyPlayerWidget setAllowedPoses(List<class_4050> poses) {
        this.renderState.allowedPoses = poses;
        return this;
    }

    private <T> class_1799 getNullableItem(T item, Function<T, class_1799> getter) {
        return item == null ? class_1799.field_8037 : getter.apply(item);
    }

    private class_1799 parseItem(String item, class_7225.class_7874 provider) {
        try {
            class_2291.class_7215 result = new class_2291(provider).method_9789(new StringReader(item));
            return new class_2290(result.comp_628(), result.comp_2439()).method_9781(1, false);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Error parsing {}", (Object)item, (Object)e);
            return class_1799.field_8037;
        }
    }

    public FancyPlayerWidget copyPlayer(String profileName) {
        return this.copyPlayer(FancyProfileFetcher.fetchProfile(profileName), profileName);
    }

    public FancyPlayerWidget copyPlayer(UUID profileId) {
        return this.copyPlayer(FancyProfileFetcher.fetchProfile(profileId), profileId.toString());
    }

    public FancyPlayerWidget uncopyPlayer() {
        this.renderState.copyingPlayer = false;
        this.updateSkin(this.properties.skin);
        this.renderState.field_53529 = this.properties.name;
        return this;
    }

    public boolean isCopyingPlayer() {
        return this.renderState.copyingPlayer;
    }

    private FancyPlayerWidget copyPlayer(CompletableFuture<Optional<GameProfile>> result, String source) {
        ((CompletableFuture)result.exceptionally(FancyPlayerWidget::handlePlayerCopyError)).thenAccept(profile -> profile.ifPresentOrElse(this::copyPlayer, () -> FancyPlayerWidget.handlePlayerCopyError(source)));
        return this;
    }

    private FancyPlayerWidget copyPlayer(GameProfile profile) {
        ((CompletableFuture)class_310.method_1551().method_1582().method_52863(profile).exceptionally(FancyPlayerWidget::handlePlayerCopyError)).thenAccept(skin -> {
            this.renderState.copyingPlayer = true;
            this.properties.name = this.renderState.field_53529;
            this.renderState.field_53529 = profile.getName();
            skin.ifPresentOrElse(this::updateSkin, () -> FancyPlayerWidget.handlePlayerCopyError(this.renderState.field_53529));
        });
        return this;
    }

    private void updateSkin(@Nullable class_8685 skin) {
        if (skin != null) {
            this.renderState.isSlim = skin.comp_1629() == class_8685.class_7920.field_41122;
            this.renderState.field_53520 = skin;
        } else {
            this.updateIsSlim(this.properties.isSlim);
        }
        this.renderer = this.renderState.isSlim ? this.slimRenderer : this.wideRenderer;
    }

    private void updateIsSlim(boolean isSlim) {
        this.renderState.isSlim = isSlim;
        this.renderState.field_53520 = class_1068.field_41121[this.random.nextInt(9) + (isSlim ? 0 : 9)];
    }

    protected void updateRenderState(int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
        this.renderState.updateScale(height);
        if (this.renderState.bodyFollowsMouse || this.renderState.headFollowsMouse) {
            float renderHeight = this.renderState.field_53465 == class_4050.field_18081 ? 1.5f : 1.875f;
            float eyeHeight = this.renderState.field_53465 == class_4050.field_18081 ? PLAYER_CROUCHING_EYE_HEIGHT : 1.62f;
            float adultEyeY = (renderHeight - eyeHeight) * (float)height / renderHeight;
            float eyeY = (float)y + (this.renderState.field_53457 ? ((float)height + adultEyeY) * 0.5f : adultEyeY);
            float eyeX = (float)x + (float)width / 2.0f;
            double mouseXRelative = (float)mouseX - eyeX;
            double mouseYRelative = (float)mouseY - eyeY;
            double xRot = Math.atan(mouseYRelative / 40.0) * 20.0;
            double yRot = -Math.atan(mouseXRelative / 40.0) * 20.0;
            if (this.renderState.field_53455) {
                xRot = -xRot;
                yRot = -yRot;
            }
            if (this.renderState.bodyFollowsMouse) {
                this.renderState.modelRot.setXDeg(xRot);
                this.renderState.modelRot.setYDeg(yRot);
                this.renderState.modelRot.setZ(0.0);
            }
            if (this.renderState.headFollowsMouse) {
                this.renderState.headRot.setXDeg(xRot);
                this.renderState.headRot.setYDeg(yRot);
                this.renderState.headRot.setZ(0.0);
            }
        }
    }

    private static final class OverridableProperties {
        final Rotation headRot = new Rotation();
        final Rotation bodyRot = new Rotation();
        public boolean bodyFollowsMouse;
        public boolean headFollowsMouse;
        boolean isSlim;
        @NotNull
        String name;
        @Nullable
        class_8685 skin;
        @Nullable
        class_1453.class_7989 parrotOnLeftShoulder;
        @Nullable
        class_1453.class_7989 parrotOnRightShoulder;
        boolean displayFireAnimation;

        private OverridableProperties(@NotNull String name) {
            this.name = name;
        }
    }
}

