/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.fancy_entity_renderer.api.entity.player;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.io.File;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_3544;
import net.minecraft.class_7497;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FancyProfileFetcher {
    @Nullable
    private static LoadingCache<String, CompletableFuture<Optional<GameProfile>>> profileCacheByName;
    @Nullable
    private static LoadingCache<UUID, CompletableFuture<Optional<GameProfile>>> profileCacheById;

    private FancyProfileFetcher() {
    }

    public static void setup() {
        class_310 minecraft = class_310.method_1551();
        final class_7497 services = class_7497.method_44143((YggdrasilAuthenticationService)minecraft.field_39420, (File)minecraft.field_1697);
        services.comp_840().method_37157((Executor)minecraft);
        profileCacheByName = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(256L).build((CacheLoader)new CacheLoader<String, CompletableFuture<Optional<GameProfile>>>(){

            @NotNull
            public CompletableFuture<Optional<GameProfile>> load(@NotNull String username) {
                return FancyProfileFetcher.fetchProfile(username, services);
            }
        });
        profileCacheById = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(256L).build((CacheLoader)new CacheLoader<UUID, CompletableFuture<Optional<GameProfile>>>(){

            @NotNull
            public CompletableFuture<Optional<GameProfile>> load(@NotNull UUID id) {
                return FancyProfileFetcher.fetchProfile(id, services, () -> profileCacheById == null);
            }
        });
    }

    static CompletableFuture<Optional<GameProfile>> fetchProfile(String name, class_7497 services) {
        return services.comp_840().method_37156(name).thenCompose(cached -> {
            LoadingCache<UUID, CompletableFuture<Optional<GameProfile>>> loadingcache = profileCacheById;
            return loadingcache != null && cached.isPresent() ? ((CompletableFuture)loadingcache.getUnchecked((Object)((GameProfile)cached.get()).getId())).thenApply(profile -> profile.or(() -> cached)) : CompletableFuture.completedFuture(Optional.empty());
        });
    }

    static CompletableFuture<Optional<GameProfile>> fetchProfile(UUID id, class_7497 services, BooleanSupplier cacheUninitialized) {
        return CompletableFuture.supplyAsync(() -> cacheUninitialized.getAsBoolean() ? Optional.empty() : Optional.ofNullable(services.comp_837().fetchProfile(id, true)).map(ProfileResult::profile), class_156.method_18349().method_64116("fetchProfile"));
    }

    public static CompletableFuture<Optional<GameProfile>> fetchProfile(String profileName) {
        LoadingCache<String, CompletableFuture<Optional<GameProfile>>> loadingcache = profileCacheByName;
        return loadingcache != null && class_3544.method_57179((String)profileName) ? (CompletableFuture)loadingcache.getUnchecked((Object)profileName) : CompletableFuture.completedFuture(Optional.empty());
    }

    public static CompletableFuture<Optional<GameProfile>> fetchProfile(UUID profileId) {
        LoadingCache<UUID, CompletableFuture<Optional<GameProfile>>> loadingcache = profileCacheById;
        return loadingcache != null ? (CompletableFuture)loadingcache.getUnchecked((Object)profileId) : CompletableFuture.completedFuture(Optional.empty());
    }
}

