/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.fancy_entity_renderer.mixin.client;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_11228;
import net.minecraft.class_11235;
import net.minecraft.class_11239;
import net.minecraft.class_11246;
import net.minecraft.class_11252;
import net.minecraft.class_11256;
import net.minecraft.class_310;
import net.minecraft.class_4597;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_11228.class})
public abstract class GuiRendererMixin {
    @Unique
    private final Set<class_11252> preparedGuiEntityRenderStates = new ReferenceOpenHashSet();
    @Final
    @Shadow
    class_11246 field_59914;
    @Unique
    class_11235 guiEntityRenderer;
    @Unique
    private Object2ObjectMap<class_11252, class_11235> renderersLastFrame = new Object2ObjectOpenHashMap();
    @Unique
    private Object2ObjectMap<class_11252, class_11235> renderersThisFrame = new Object2ObjectOpenHashMap();
    @Final
    @Shadow
    private Map<Class<? extends class_11256>, class_11239<?>> field_59918;

    private GuiRendererMixin() {
    }

    @Shadow
    protected abstract <T extends class_11256> void method_70888(T var1, int var2);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onInit(class_11246 renderState, class_4597.class_4598 bufferSource, List<class_11239<?>> renderers, CallbackInfo ci) {
        this.guiEntityRenderer = (class_11235)this.field_59918.get(class_11252.class);
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void onRender(CallbackInfo ci) {
        this.renderersLastFrame.values().forEach(class_11239::close);
        this.renderersLastFrame.clear();
        Object2ObjectMap<class_11252, class_11235> tmp = this.renderersLastFrame;
        this.renderersLastFrame = this.renderersThisFrame;
        this.renderersThisFrame = tmp;
    }

    @Overwrite
    private void method_70893() {
        int i = class_310.method_1551().method_22683().method_4495();
        this.preparedGuiEntityRenderStates.clear();
        this.field_59914.method_71071(state -> {
            if (state instanceof class_11252) {
                class_11252 guiEntityRenderState = (class_11252)state;
                if (this.prepareGuiEntityRenderState(guiEntityRenderState, i, true)) {
                    this.preparedGuiEntityRenderStates.add(guiEntityRenderState);
                }
            } else {
                this.method_70888(state, i);
            }
        });
        this.field_59914.method_71071(state -> {
            class_11252 guiEntityRenderState;
            if (state instanceof class_11252 && this.preparedGuiEntityRenderStates.add(guiEntityRenderState = (class_11252)state)) {
                this.prepareGuiEntityRenderState(guiEntityRenderState, i, false);
            }
        });
        this.preparedGuiEntityRenderStates.clear();
    }

    @Unique
    private boolean prepareGuiEntityRenderState(class_11252 state, int guiScale, boolean first) {
        class_11235 renderer = this.getGuiEntityRenderer(state, guiScale, first);
        if (renderer != null) {
            renderer.method_70913((class_11256)state, this.field_59914, guiScale);
            return true;
        }
        return false;
    }

    @Inject(method={"close"}, at={@At(value="INVOKE", target="Ljava/util/Collection;forEach(Ljava/util/function/Consumer;)V", ordinal=0)})
    private void onClose(CallbackInfo ci) {
        this.renderersThisFrame.values().forEach(class_11239::close);
        this.renderersLastFrame.values().forEach(class_11239::close);
    }

    @Unique
    @Nullable
    private class_11235 getGuiEntityRenderer(class_11252 state, int guiScale, boolean first) {
        class_11235 renderer;
        int width = (state.comp_4124() - state.comp_4122()) * guiScale;
        int height = (state.comp_4125() - state.comp_4123()) * guiScale;
        if (first) {
            class_11235 renderer2 = (class_11235)this.renderersLastFrame.get((Object)state);
            if (renderer2 != null && this.canBeReusedFor(renderer2, state, width, height)) {
                this.renderersLastFrame.remove((Object)state);
                this.renderersThisFrame.put((Object)state, (Object)renderer2);
                return renderer2;
            }
            return null;
        }
        ObjectIterator it = this.renderersLastFrame.values().iterator();
        while (it.hasNext()) {
            renderer = (class_11235)it.next();
            if (!this.canBeReusedFor(renderer, state, width, height)) continue;
            it.remove();
            this.renderersThisFrame.put((Object)state, (Object)renderer);
            return renderer;
        }
        renderer = new class_11235(this.guiEntityRenderer.field_59933, this.guiEntityRenderer.field_59932);
        this.renderersThisFrame.put((Object)state, (Object)renderer);
        return renderer;
    }

    @Unique
    private boolean canBeReusedFor(class_11235 renderer, class_11252 state, int width, int height) {
        return renderer.field_59935 == null || renderer.field_59935.getWidth(0) == width && renderer.field_59935.getHeight(0) == height;
    }
}

