/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.fancy_entity_renderer.api.entity.player;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.crystalnest.fancy_entity_renderer.api.entity.player.layer.FancyCapeLayer;
import it.crystalnest.fancy_entity_renderer.api.entity.player.model.FancyPlayerModel;
import it.crystalnest.fancy_entity_renderer.api.entity.player.state.FancyPlayerRenderState;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class FancyPlayerRenderer
extends PlayerRenderer {
    private static final EntityRendererProvider.Context RENDER_CONTEXT = new EntityRendererProvider.Context(Minecraft.getInstance().getEntityRenderDispatcher(), Minecraft.getInstance().getItemModelResolver(), Minecraft.getInstance().getMapRenderer(), Minecraft.getInstance().getBlockRenderer(), Minecraft.getInstance().getResourceManager(), Minecraft.getInstance().getEntityModels(), Minecraft.getInstance().getEntityRenderDispatcher().equipmentAssets, Minecraft.getInstance().font);
    private final FancyPlayerModel adultModel;
    private final FancyPlayerModel babyModel;

    public FancyPlayerRenderer(FancyPlayerRenderState state, boolean isSlim) {
        super(RENDER_CONTEXT, isSlim);
        this.entityRenderDispatcher.overrideCameraOrientation(new Quaternionf());
        this.adultModel = new FancyPlayerModel(RENDER_CONTEXT.getModelSet(), isSlim, false);
        this.babyModel = new FancyPlayerModel(RENDER_CONTEXT.getModelSet(), isSlim, true);
        this.model = this.adultModel;
        this.reusedState = state;
        this.layers.replaceAll(layer -> {
            RenderLayer renderLayer = layer;
            Objects.requireNonNull(renderLayer);
            RenderLayer selector0$temp = renderLayer;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HumanoidArmorLayer.class, CapeLayer.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    HumanoidArmorLayer l = (HumanoidArmorLayer)selector0$temp;
                    yield new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new HumanoidArmorModel(RENDER_CONTEXT.bakeLayer(isSlim ? ModelLayers.PLAYER_SLIM_INNER_ARMOR : ModelLayers.PLAYER_INNER_ARMOR)), (HumanoidModel)new HumanoidArmorModel(RENDER_CONTEXT.bakeLayer(isSlim ? ModelLayers.PLAYER_SLIM_OUTER_ARMOR : ModelLayers.PLAYER_OUTER_ARMOR)), (HumanoidModel)new HumanoidArmorModel(FancyPlayerModel.getBabyArmorModel(true)), (HumanoidModel)new HumanoidArmorModel(FancyPlayerModel.getBabyArmorModel(false)), RENDER_CONTEXT.getEquipmentRenderer());
                }
                case 1 -> {
                    CapeLayer l = (CapeLayer)selector0$temp;
                    yield new FancyCapeLayer((RenderLayerParent<PlayerRenderState, PlayerModel>)this, RENDER_CONTEXT.getModelSet(), RENDER_CONTEXT.getEquipmentAssets());
                }
                default -> layer;
            };
        });
    }

    private FancyPlayerRenderState state() {
        return (FancyPlayerRenderState)this.reusedState;
    }

    public void render(@NotNull PlayerRenderState state, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        this.model = state.isBaby ? this.babyModel : this.adultModel;
        super.render(state, poseStack, bufferSource, packedLight);
    }

    protected void renderNameTag(@NotNull PlayerRenderState renderState, @NotNull Component nameTag, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        FancyPlayerRenderState state = this.state();
        if (state.showPlayerName && !state.isInvisibleToPlayer) {
            float scale = state.scale * 0.025f;
            Font font = this.getFont();
            poseStack.pushPose();
            float height = renderState.isBaby && renderState.pose != Pose.SPIN_ATTACK ? state.boundingBoxHeight * 0.5f : state.boundingBoxHeight;
            float offsetY = (state.pose == Pose.SLEEPING || state.pose == Pose.SWIMMING ? state.boundingBoxWidth : height) / scale + (float)state.nameTagAttachment.y;
            float offsetX = state.pose == Pose.SLEEPING ? -((float)state.nameTagAttachment.x) : (float)font.width((FormattedText)nameTag) / 2.0f;
            poseStack.scale(scale, -scale, scale);
            if (state.pinName) {
                poseStack.rotateAround((Quaternionfc)new Quaternionf().rotateY(state.modelRot.getY()), 0.0f, 0.0f, 0.0f);
            }
            poseStack.translate(-offsetX, -offsetY, 0.0f);
            if (renderState.isUpsideDown) {
                poseStack.scale(1.0f, -1.0f, 1.0f);
            }
            if (renderState.deathTime > 1.0f) {
                poseStack.rotateAround((Quaternionfc)Axis.ZP.rotationDegrees(Math.min(Mth.sqrt((float)((renderState.deathTime - 1.0f) / 20.0f * 1.6f)), 1.0f) * this.getFlipDegrees()), offsetX, offsetY, 0.0f);
            }
            font.drawInBatch(nameTag, 0.0f, 0.0f, -2130706433, false, poseStack.last().pose(), bufferSource, Font.DisplayMode.SEE_THROUGH, (int)(Minecraft.getInstance().options.getBackgroundOpacity(0.25f) * 255.0f) << 24, packedLight);
            font.drawInBatch(nameTag, 0.0f, 0.0f, renderState.isDiscrete ? -2130706433 : -1, false, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, LightTexture.lightCoordsWithEmission((int)packedLight, (int)2));
            poseStack.popPose();
        }
    }

    public void extractRenderState(@Nullable AbstractClientPlayer player, @NotNull PlayerRenderState renderState, float partialTick) {
        FancyPlayerRenderState state = this.state();
        if (state.mimickedPlayer != null) {
            float height = state.boundingBoxHeight;
            boolean isBaby = state.isBaby;
            boolean isUpsideDown = state.isUpsideDown;
            super.extractRenderState(state.mimickedPlayer, renderState, partialTick);
            ((FancyPlayerRenderState)renderState).updateScale(height);
            renderState.bodyRot = 0.0f;
            if (!state.allowedPoses.contains(renderState.pose)) {
                renderState.pose = Pose.STANDING;
            }
            renderState.isFallFlying = renderState.pose == Pose.FALL_FLYING;
            renderState.isAutoSpinAttack = renderState.pose == Pose.SPIN_ATTACK;
            renderState.isCrouching = renderState.pose == Pose.CROUCHING;
            boolean bl = renderState.isVisuallySwimming = renderState.pose == Pose.SWIMMING;
            if (!renderState.isVisuallySwimming) {
                renderState.swimAmount = 0.0f;
            }
            boolean bl2 = renderState.hasRedOverlay = renderState.pose == Pose.DYING;
            if (!renderState.hasRedOverlay) {
                renderState.deathTime = 0.0f;
            }
            if (renderState.pose != Pose.STANDING && renderState.pose != Pose.CROUCHING) {
                renderState.displayFireAnimation = false;
            }
            if (renderState.pose == Pose.SWIMMING) {
                renderState.parrotOnLeftShoulder = null;
                renderState.parrotOnRightShoulder = null;
            }
            renderState.isBaby = isBaby;
            renderState.isUpsideDown = isUpsideDown;
        } else {
            renderState.eyeHeight = ((EntityDimensions)Player.POSES.get(state.pose)).eyeHeight();
            boolean bl = renderState.isDiscrete = state.isCrouching || state.isInvisible;
            if (state.isMoving && state.pose != Pose.DYING) {
                float step = renderState.speedValue * 0.33f;
                renderState.ageInTicks += step;
                renderState.walkAnimationPos += step;
                renderState.walkAnimationSpeed = state.pose != Pose.SPIN_ATTACK && state.pose != Pose.SLEEPING ? state.walkSpeed : 0.0f;
            } else {
                renderState.ageInTicks = 3000.0f;
                renderState.walkAnimationPos = 0.0f;
                renderState.walkAnimationSpeed = 0.0f;
            }
            renderState.nameTag = Component.literal((String)state.name);
            renderState.nameTagAttachment = state.pose == Pose.SLEEPING ? new Vec3((double)(((EntityDimensions)Player.POSES.get(state.pose)).eyeHeight() * state.scale - state.boundingBoxHeight / 1.35f), 0.0, 0.0) : new Vec3(0.0, (double)(0.25f * state.scale), 0.0);
            if (state.rightHandHeldItem != null) {
                this.itemModelResolver.updateForTopItem(state.rightHandItem, state.rightHandHeldItem, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, null, null, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND.ordinal());
            }
            if (state.leftHandHeldItem != null) {
                this.itemModelResolver.updateForTopItem(state.leftHandItem, state.leftHandHeldItem, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, null, null, ItemDisplayContext.THIRD_PERSON_LEFT_HAND.ordinal());
            }
            renderState.elytraRotX = 0.19634955f;
            renderState.elytraRotZ = 0.31415927f;
        }
    }

    protected void setupRotations(@NotNull PlayerRenderState state, @NotNull PoseStack poseStack, float bodyRot, float scale) {
        if (state.pose == Pose.SPIN_ATTACK) {
            poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(90.0f));
        }
        super.setupRotations(state, poseStack, bodyRot, scale);
        if (state.isUpsideDown) {
            if (state.pose == Pose.DYING || state.pose == Pose.SPIN_ATTACK) {
                poseStack.translate(0.0f, (state.boundingBoxHeight + 0.1f) / scale, 0.0f);
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
            } else if (state.pose == Pose.SLEEPING) {
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
            }
        }
    }
}

