/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.fancy_entity_renderer.api.entity.player;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.crystalnest.fancy_entity_renderer.Constants;
import it.crystalnest.fancy_entity_renderer.api.Rotation;
import it.crystalnest.fancy_entity_renderer.api.entity.RenderMode;
import it.crystalnest.fancy_entity_renderer.api.entity.player.state.FancyPlayerRenderState;
import it.crystalnest.fancy_entity_renderer.compat.Prometheus;
import it.crystalnest.fancy_entity_renderer.platform.Services;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.player.PlayerModelType;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class FancyPlayerWidget
extends AbstractWidget {
    public static final float PLAYER_RENDER_HEIGHT = 1.875f;
    public static final float PLAYER_CROUCHING_EYE_HEIGHT = ((EntityDimensions)Avatar.POSES.get(Pose.CROUCHING)).eyeHeight();
    public static final float PLAYER_SIZE_RATIO = 2.9999998f;
    protected final FancyPlayerRenderState renderState = new FancyPlayerRenderState();
    protected final Random random = new Random();
    private final OverridableProperties properties;

    public FancyPlayerWidget(int x, int y, int width, int height) {
        super(x, y, width, height, CommonComponents.EMPTY);
        this.properties = new OverridableProperties(this.renderState.name);
        this.renderState.lightCoords = 0xF000F0;
    }

    private static void handlePlayerCopyError(String source) {
        Constants.LOGGER.error("Failed to copy player \"{}\"", (Object)source);
    }

    private static <T> Optional<T> handlePlayerCopyError(Throwable error) {
        Constants.LOGGER.error("Copy of player failed with error!", error);
        return Optional.empty();
    }

    private static <T> ItemStack getNullableItem(T item, Function<T, ItemStack> getter) {
        return item == null ? ItemStack.EMPTY : getter.apply(item);
    }

    private static ItemStack parseItem(String item, HolderLookup.Provider provider) {
        try {
            ItemParser.ItemResult result = new ItemParser(provider).parse(new StringReader(item));
            return new ItemInput(result.item(), result.components()).createItemStack(1, false);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Error parsing {}", (Object)item, (Object)e);
            return ItemStack.EMPTY;
        }
    }

    protected void renderWidget(@NotNull GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        float offsetY;
        this.updateRenderState(this.getX(), this.getY(), this.getWidth(), this.getHeight(), mouseX, mouseY, partialTick);
        float offsetX = 0.0f;
        float f = offsetY = this.renderState.isCrouching ? this.renderState.scale / -8.0f : 0.0f;
        if (this.renderState.pose == Pose.SLEEPING) {
            offsetX += 1.875f * this.renderState.scale / 2.0f;
            offsetY -= 0.25f * this.renderState.scale;
            if (this.renderState.isBaby) {
                offsetX /= 1.75f;
                offsetY /= 1.5f;
            }
        }
        gfx.submitEntityRenderState((EntityRenderState)this.renderState, 1.0f, new Vector3f(offsetX - (float)(Minecraft.getInstance().getWindow().getGuiScaledWidth() - this.getWidth()) / 2.0f + (float)this.getX(), offsetY - (float)Minecraft.getInstance().getWindow().getGuiScaledHeight() / 2.0f + (float)this.getY() + (float)this.getHeight(), 0.0f), new Quaternionf().rotateXYZ(this.renderState.modelRot.getX(), -this.renderState.modelRot.getY(), this.renderState.modelRot.getZ()), new Quaternionf().rotateXYZ(-this.renderState.modelRot.getX(), this.renderState.modelRot.getY(), -this.renderState.modelRot.getZ()), 0, 0, Minecraft.getInstance().getWindow().getGuiScaledWidth(), Minecraft.getInstance().getWindow().getGuiScaledHeight());
    }

    public void playDownSound(@NotNull SoundManager soundManager) {
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput output) {
    }

    public FancyPlayerWidget setBodyFollowsMouse(boolean followsMouse) {
        if (this.renderState.pose == Pose.STANDING || this.renderState.pose == Pose.CROUCHING || this.renderState.pose == Pose.SPIN_ATTACK) {
            this.renderState.bodyFollowsMouse = followsMouse;
            if (followsMouse) {
                this.properties.bodyRot.copy(this.renderState.modelRot);
            } else {
                this.renderState.modelRot.copy(this.properties.bodyRot);
            }
        } else {
            this.properties.bodyFollowsMouse = followsMouse;
        }
        return this;
    }

    public FancyPlayerWidget setHeadFollowsMouse(boolean followsMouse) {
        if (this.renderState.pose == Pose.STANDING || this.renderState.pose == Pose.CROUCHING || this.renderState.pose == Pose.SPIN_ATTACK) {
            this.renderState.headFollowsMouse = followsMouse;
            if (followsMouse) {
                this.properties.headRot.copy(this.renderState.headRot);
            } else {
                this.renderState.headRot.copy(this.properties.headRot);
            }
        } else {
            this.properties.headFollowsMouse = followsMouse;
        }
        return this;
    }

    public FancyPlayerWidget setHeadRotation(Rotation rotation) {
        this.properties.headRot.copy(rotation);
        this.renderState.headRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setHeadRotation(float x, float y, float z) {
        this.properties.headRot.setDeg(x, y, z);
        this.renderState.headRot.setDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setBodyRotation(Rotation rotation) {
        this.properties.bodyRot.copy(rotation);
        this.renderState.modelRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setBodyRotation(float x, float y, float z) {
        this.properties.bodyRot.setDeg(x, y, z);
        this.renderState.modelRot.setDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setLeftArmRotation(Rotation rotation) {
        this.renderState.leftArmRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setLeftArmRotation(float x, float y, float z) {
        this.renderState.leftArmRot.setDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setRightArmRotation(Rotation rotation) {
        this.renderState.rightArmRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setRightArmRotation(float x, float y, float z) {
        this.renderState.rightArmRot.setDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setLeftLegRotation(Rotation rotation) {
        this.renderState.leftLegRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setLeftLegRotation(float x, float y, float z) {
        this.renderState.leftLegRot.setDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setRightLegRotation(Rotation rotation) {
        this.renderState.rightLegRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setRightLegRotation(float x, float y, float z) {
        this.renderState.rightLegRot.setDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setSlim(boolean isSlim) {
        this.properties.isSlim = isSlim;
        if (!this.renderState.copyingPlayer && this.properties.skin == null) {
            this.updateIsSlim(this.properties.isSlim);
        }
        return this;
    }

    public FancyPlayerWidget setSkin(@Nullable PlayerSkin skin) {
        this.properties.skin = skin;
        if (!this.renderState.copyingPlayer) {
            this.updateSkin(skin);
        }
        return this;
    }

    public FancyPlayerWidget copyLocalPlayer() {
        this.renderState.copyingPlayer = true;
        this.copyPlayer(Minecraft.getInstance().getGameProfile());
        return this;
    }

    public FancyPlayerWidget setName(String name) {
        this.properties.name = name;
        if (!this.renderState.copyingPlayer) {
            this.renderState.name = name;
        }
        return this;
    }

    public FancyPlayerWidget setPinName(boolean pinName) {
        this.renderState.pinName = pinName;
        return this;
    }

    public FancyPlayerWidget setShowName(boolean showName) {
        this.renderState.showPlayerName = showName;
        return this;
    }

    public FancyPlayerWidget setShowCape(boolean showCape) {
        this.renderState.showCape = showCape;
        return this;
    }

    public FancyPlayerWidget setShowLeftArm(boolean showLeftArm) {
        this.renderState.showLeftArm = showLeftArm;
        return this;
    }

    public FancyPlayerWidget setShowLeftSleeve(boolean showLeftSleeve) {
        this.renderState.showLeftSleeve = showLeftSleeve;
        return this;
    }

    public FancyPlayerWidget setShowRightArm(boolean showRightArm) {
        this.renderState.showRightArm = showRightArm;
        return this;
    }

    public FancyPlayerWidget setShowRightSleeve(boolean showRightSleeve) {
        this.renderState.showRightSleeve = showRightSleeve;
        return this;
    }

    public FancyPlayerWidget setShowLeftLeg(boolean showLeftLeg) {
        this.renderState.showLeftLeg = showLeftLeg;
        return this;
    }

    public FancyPlayerWidget setShowLeftPants(boolean showLeftPants) {
        this.renderState.showLeftPants = showLeftPants;
        return this;
    }

    public FancyPlayerWidget setShowRightLeg(boolean showRightLeg) {
        this.renderState.showRightLeg = showRightLeg;
        return this;
    }

    public FancyPlayerWidget setShowRightPants(boolean showRightPants) {
        this.renderState.showRightPants = showRightPants;
        return this;
    }

    public FancyPlayerWidget setShowHead(boolean showHead) {
        this.renderState.showHead = showHead;
        return this;
    }

    public FancyPlayerWidget setShowHat(boolean showHat) {
        this.renderState.showHat = showHat;
        return this;
    }

    public FancyPlayerWidget setShowBody(boolean showBody) {
        this.renderState.showBody = showBody;
        return this;
    }

    public FancyPlayerWidget setShowJacket(boolean showJacket) {
        this.renderState.showJacket = showJacket;
        return this;
    }

    public FancyPlayerWidget setShowOuterLayer(boolean showOuterLayer) {
        this.setShowLeftSleeve(showOuterLayer);
        this.setShowRightSleeve(showOuterLayer);
        this.setShowLeftPants(showOuterLayer);
        this.setShowRightPants(showOuterLayer);
        this.setShowHat(showOuterLayer);
        this.setShowJacket(showOuterLayer);
        return this;
    }

    public FancyPlayerWidget setShowInnerLayer(boolean showInnerLayer) {
        this.setShowLeftArm(showInnerLayer);
        this.setShowRightArm(showInnerLayer);
        this.setShowLeftLeg(showInnerLayer);
        this.setShowRightLeg(showInnerLayer);
        this.setShowHead(showInnerLayer);
        this.setShowBody(showInnerLayer);
        return this;
    }

    public FancyPlayerWidget setUpsideDown(boolean isUpsideDown) {
        this.renderState.isUpsideDown = isUpsideDown;
        return this;
    }

    public FancyPlayerWidget setRenderMode(RenderMode mode) {
        this.renderState.isSpectator = RenderMode.SPECTATOR == mode;
        this.renderState.isInvisible = RenderMode.NORMAL != mode;
        this.renderState.isInvisibleToPlayer = RenderMode.INVISIBLE == mode;
        return this;
    }

    @ApiStatus.Experimental
    public FancyPlayerWidget setGlowing(int color) {
        this.renderState.outlineColor = color;
        return this;
    }

    public FancyPlayerWidget setMoving(boolean isMoving) {
        this.renderState.isMoving = isMoving;
        return this;
    }

    public FancyPlayerWidget setOnFire(boolean onFire) {
        if (this.renderState.pose == Pose.STANDING || this.renderState.pose == Pose.CROUCHING) {
            this.renderState.displayFireAnimation = onFire;
        } else {
            this.properties.displayFireAnimation = onFire;
        }
        return this;
    }

    public FancyPlayerWidget setOnFire(boolean onFire, ResourceLocation fireType) {
        if (Services.PLATFORM.isModLoaded("prometheus")) {
            Prometheus.setOnFire((EntityRenderState)this.renderState, fireType);
        }
        return this.setOnFire(onFire);
    }

    public FancyPlayerWidget setArrowCount(int count) {
        this.renderState.arrowCount = count;
        return this;
    }

    public FancyPlayerWidget setStingerCount(int count) {
        this.renderState.stingerCount = count;
        return this;
    }

    public FancyPlayerWidget setLeftParrot(@Nullable Parrot.Variant parrot) {
        if (this.renderState.isBaby || this.renderState.pose == Pose.SWIMMING) {
            this.properties.parrotOnLeftShoulder = parrot;
        } else {
            this.renderState.parrotOnLeftShoulder = parrot;
        }
        return this;
    }

    public FancyPlayerWidget setRightParrot(@Nullable Parrot.Variant parrot) {
        if (this.renderState.isBaby || this.renderState.pose == Pose.SWIMMING) {
            this.properties.parrotOnRightShoulder = parrot;
        } else {
            this.renderState.parrotOnRightShoulder = parrot;
        }
        return this;
    }

    public FancyPlayerWidget setParrots(@Nullable Parrot.Variant left, @Nullable Parrot.Variant right) {
        if (this.renderState.isBaby || this.renderState.pose == Pose.SWIMMING) {
            this.properties.parrotOnLeftShoulder = left;
            this.properties.parrotOnRightShoulder = right;
        } else {
            this.renderState.parrotOnLeftShoulder = left;
            this.renderState.parrotOnRightShoulder = right;
        }
        return this;
    }

    public FancyPlayerWidget setBaby(boolean isBaby) {
        this.renderState.isBaby = isBaby;
        if (isBaby) {
            this.properties.parrotOnLeftShoulder = this.renderState.parrotOnLeftShoulder;
            this.properties.parrotOnRightShoulder = this.renderState.parrotOnRightShoulder;
        } else {
            this.renderState.parrotOnLeftShoulder = this.properties.parrotOnLeftShoulder;
            this.renderState.parrotOnRightShoulder = this.properties.parrotOnRightShoulder;
        }
        return this;
    }

    public FancyPlayerWidget setRightArmPose(HumanoidModel.ArmPose pose) {
        this.renderState.rightArmPose = pose;
        return this;
    }

    public FancyPlayerWidget setLeftArmPose(HumanoidModel.ArmPose pose) {
        this.renderState.leftArmPose = pose;
        return this;
    }

    public FancyPlayerWidget setMovementSpeed(float speed) {
        this.renderState.speedValue = speed;
        return this;
    }

    public FancyPlayerWidget setWalkingSpeed(float speed) {
        this.renderState.walkSpeed = speed;
        return this;
    }

    public FancyPlayerWidget setRightHandItem(@Nullable String item, HolderLookup.Provider provider) {
        this.renderState.rightHandHeldItem = FancyPlayerWidget.getNullableItem(item, i -> FancyPlayerWidget.parseItem(i, provider));
        return this;
    }

    public FancyPlayerWidget setLeftHandItem(@Nullable String item, HolderLookup.Provider provider) {
        this.renderState.leftHandHeldItem = FancyPlayerWidget.getNullableItem(item, i -> FancyPlayerWidget.parseItem(i, provider));
        return this;
    }

    public FancyPlayerWidget setRightHandItem(@Nullable Item item) {
        this.renderState.rightHandHeldItem = FancyPlayerWidget.getNullableItem(item, Item::getDefaultInstance);
        return this;
    }

    public FancyPlayerWidget setLeftHandItem(@Nullable Item item) {
        this.renderState.leftHandHeldItem = FancyPlayerWidget.getNullableItem(item, Item::getDefaultInstance);
        return this;
    }

    public FancyPlayerWidget setRightHandItem(@Nullable ItemStack item) {
        this.renderState.rightHandHeldItem = FancyPlayerWidget.getNullableItem(item, i -> i);
        return this;
    }

    public FancyPlayerWidget setLeftHandItem(@Nullable ItemStack item) {
        this.renderState.leftHandHeldItem = FancyPlayerWidget.getNullableItem(item, i -> i);
        return this;
    }

    public FancyPlayerWidget setHeadWearable(@Nullable String item, HolderLookup.Provider provider) {
        this.renderState.headEquipment = FancyPlayerWidget.getNullableItem(item, i -> FancyPlayerWidget.parseItem(i, provider));
        return this;
    }

    public FancyPlayerWidget setChestWearable(@Nullable String item, HolderLookup.Provider provider) {
        this.renderState.chestEquipment = FancyPlayerWidget.getNullableItem(item, i -> FancyPlayerWidget.parseItem(i, provider));
        return this;
    }

    public FancyPlayerWidget setLegsWearable(@Nullable String item, HolderLookup.Provider provider) {
        this.renderState.legsEquipment = FancyPlayerWidget.getNullableItem(item, i -> FancyPlayerWidget.parseItem(i, provider));
        return this;
    }

    public FancyPlayerWidget setFeetWearable(@Nullable String item, HolderLookup.Provider provider) {
        this.renderState.feetEquipment = FancyPlayerWidget.getNullableItem(item, i -> FancyPlayerWidget.parseItem(i, provider));
        return this;
    }

    public FancyPlayerWidget setHeadWearable(@Nullable Item item) {
        this.renderState.headEquipment = FancyPlayerWidget.getNullableItem(item, Item::getDefaultInstance);
        return this;
    }

    public FancyPlayerWidget setChestWearable(@Nullable Item item) {
        this.renderState.chestEquipment = FancyPlayerWidget.getNullableItem(item, Item::getDefaultInstance);
        return this;
    }

    public FancyPlayerWidget setLegsWearable(@Nullable Item item) {
        this.renderState.legsEquipment = FancyPlayerWidget.getNullableItem(item, Item::getDefaultInstance);
        return this;
    }

    public FancyPlayerWidget setFeetWearable(@Nullable Item item) {
        this.renderState.feetEquipment = FancyPlayerWidget.getNullableItem(item, Item::getDefaultInstance);
        return this;
    }

    public FancyPlayerWidget setHeadWearable(@Nullable ItemStack item) {
        this.renderState.headEquipment = FancyPlayerWidget.getNullableItem(item, i -> i);
        return this;
    }

    public FancyPlayerWidget setChestWearable(@Nullable ItemStack item) {
        this.renderState.chestEquipment = FancyPlayerWidget.getNullableItem(item, i -> i);
        return this;
    }

    public FancyPlayerWidget setLegsWearable(@Nullable ItemStack item) {
        this.renderState.legsEquipment = FancyPlayerWidget.getNullableItem(item, i -> i);
        return this;
    }

    public FancyPlayerWidget setFeetWearable(@Nullable ItemStack item) {
        this.renderState.feetEquipment = FancyPlayerWidget.getNullableItem(item, i -> i);
        return this;
    }

    public FancyPlayerWidget setAttackTime(float attackTime) {
        if (attackTime >= 0.0f) {
            this.renderState.attackTime = attackTime % 1.0f;
        }
        return this;
    }

    public FancyPlayerWidget setAttackArm(HumanoidArm attackArm) {
        this.renderState.attackArm = attackArm;
        return this;
    }

    public FancyPlayerWidget mimicLocalPlayer() {
        return this.mimicPlayer((AbstractClientPlayer)Minecraft.getInstance().player);
    }

    public FancyPlayerWidget mimicPlayer(@Nullable AbstractClientPlayer player) {
        this.renderState.mimickedPlayer = player;
        return this;
    }

    public FancyPlayerWidget unmimicPlayer() {
        this.renderState.mimickedPlayer = null;
        return this;
    }

    public boolean isMimickingPlayer() {
        return this.renderState.mimickedPlayer != null;
    }

    public FancyPlayerWidget setAllowedPoses(List<Pose> poses) {
        this.renderState.allowedPoses = poses;
        return this;
    }

    public FancyPlayerWidget setPose(Pose pose) {
        if (Avatar.POSES.containsKey(pose) && pose != Pose.FALL_FLYING) {
            this.renderState.pose = pose;
            this.renderState.isAutoSpinAttack = pose == Pose.SPIN_ATTACK;
            this.renderState.isCrouching = pose == Pose.CROUCHING;
            this.renderState.isVisuallySwimming = pose == Pose.SWIMMING;
            this.renderState.swimAmount = this.renderState.isVisuallySwimming ? 1.0f : 0.0f;
            this.renderState.hasRedOverlay = pose == Pose.DYING;
            float f = this.renderState.deathTime = this.renderState.hasRedOverlay ? 5.0f : 0.0f;
            if (pose == Pose.STANDING || pose == Pose.CROUCHING) {
                this.renderState.displayFireAnimation = this.properties.displayFireAnimation;
            } else {
                this.properties.displayFireAnimation = this.renderState.displayFireAnimation;
                this.renderState.displayFireAnimation = false;
            }
            if (pose == Pose.STANDING || pose == Pose.CROUCHING || pose == Pose.SPIN_ATTACK) {
                this.renderState.headFollowsMouse = this.properties.headFollowsMouse;
                this.renderState.bodyFollowsMouse = this.properties.bodyFollowsMouse;
            } else {
                this.properties.headFollowsMouse = this.renderState.headFollowsMouse;
                this.properties.bodyFollowsMouse = this.renderState.bodyFollowsMouse;
                this.renderState.headFollowsMouse = false;
                this.renderState.bodyFollowsMouse = false;
            }
            if (pose == Pose.SWIMMING) {
                this.properties.parrotOnLeftShoulder = this.renderState.parrotOnLeftShoulder;
                this.properties.parrotOnRightShoulder = this.renderState.parrotOnRightShoulder;
                this.renderState.parrotOnLeftShoulder = null;
                this.renderState.parrotOnRightShoulder = null;
            } else {
                this.renderState.parrotOnLeftShoulder = this.properties.parrotOnLeftShoulder;
                this.renderState.parrotOnRightShoulder = this.properties.parrotOnRightShoulder;
            }
        } else {
            Constants.LOGGER.warn("Pose {} is not supported for Player entity!", (Object)pose);
        }
        return this;
    }

    public FancyPlayerWidget copyPlayer(String profileName) {
        return this.copyPlayer(Minecraft.getInstance().services().profileResolver().fetchByName(profileName), profileName);
    }

    public FancyPlayerWidget copyPlayer(UUID profileId) {
        return this.copyPlayer(Minecraft.getInstance().services().profileResolver().fetchById(profileId), profileId.toString());
    }

    public FancyPlayerWidget uncopyPlayer() {
        this.renderState.copyingPlayer = false;
        this.updateSkin(this.properties.skin);
        this.renderState.name = this.properties.name;
        return this;
    }

    public boolean isCopyingPlayer() {
        return this.renderState.copyingPlayer;
    }

    private FancyPlayerWidget copyPlayer(Optional<GameProfile> profile, String source) {
        profile.ifPresentOrElse(this::copyPlayer, () -> FancyPlayerWidget.handlePlayerCopyError(source));
        return this;
    }

    private FancyPlayerWidget copyPlayer(GameProfile profile) {
        ((CompletableFuture)Minecraft.getInstance().getSkinManager().get(profile).exceptionally(FancyPlayerWidget::handlePlayerCopyError)).thenAccept(skin -> {
            this.renderState.copyingPlayer = true;
            this.properties.name = this.renderState.name;
            this.renderState.name = profile.name();
            skin.ifPresentOrElse(this::updateSkin, () -> FancyPlayerWidget.handlePlayerCopyError(this.renderState.name));
        });
        return this;
    }

    private void updateSkin(@Nullable PlayerSkin skin) {
        if (skin != null) {
            this.renderState.isSlim = skin.model() == PlayerModelType.SLIM;
            this.renderState.skin = skin;
        } else {
            this.updateIsSlim(this.properties.isSlim);
        }
    }

    private void updateIsSlim(boolean isSlim) {
        this.renderState.isSlim = isSlim;
        this.renderState.skin = DefaultPlayerSkin.DEFAULT_SKINS[this.random.nextInt(9) + (isSlim ? 0 : 9)];
    }

    protected void updateRenderState(int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
        this.renderState.updateScale(height);
        if (this.renderState.bodyFollowsMouse || this.renderState.headFollowsMouse) {
            float renderHeight = this.renderState.pose == Pose.CROUCHING ? 1.5f : 1.875f;
            float eyeHeight = this.renderState.pose == Pose.CROUCHING ? PLAYER_CROUCHING_EYE_HEIGHT : 1.62f;
            float adultEyeY = (renderHeight - eyeHeight) * (float)height / renderHeight;
            float eyeY = this.renderState.isBaby ? ((float)height + adultEyeY) * 0.5f : adultEyeY;
            float eyeX = (float)width / 2.0f;
            double mouseXRelative = (float)mouseX - (eyeX + (float)x);
            double mouseYRelative = (float)mouseY - ((this.renderState.isUpsideDown ? (float)height - eyeY : eyeY) + (float)y);
            double xRot = Math.atan(mouseYRelative / 40.0) * 20.0;
            double yRot = -Math.atan(mouseXRelative / 40.0) * 20.0;
            if (this.renderState.bodyFollowsMouse) {
                this.renderState.modelRot.setXDeg(xRot);
                this.renderState.modelRot.setYDeg(yRot);
                this.renderState.modelRot.setZ(0.0);
            }
            if (this.renderState.headFollowsMouse) {
                this.renderState.headRot.setXDeg(this.renderState.isUpsideDown ? -xRot : xRot);
                this.renderState.headRot.setYDeg(this.renderState.isUpsideDown ? -yRot : yRot);
                this.renderState.headRot.setZ(0.0);
            }
        }
    }

    private static final class OverridableProperties {
        final Rotation headRot = new Rotation();
        final Rotation bodyRot = new Rotation();
        boolean bodyFollowsMouse;
        boolean headFollowsMouse;
        boolean isSlim;
        @NotNull
        String name;
        @Nullable
        PlayerSkin skin;
        @Nullable
        Parrot.Variant parrotOnLeftShoulder;
        @Nullable
        Parrot.Variant parrotOnRightShoulder;
        boolean displayFireAnimation;

        private OverridableProperties(@NotNull String name) {
            this.name = name;
        }
    }
}

