/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.fancy_entity_renderer.api.entity.player.model;

import it.crystalnest.fancy_entity_renderer.api.entity.player.state.FancyPlayerRenderState;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.LayerDefinitions;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.entity.ArmorModelSet;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import org.jetbrains.annotations.NotNull;

public class FancyPlayerModel
extends PlayerModel {
    public FancyPlayerModel(EntityModelSet modelSet, boolean isSlim, boolean isBaby) {
        super(FancyPlayerModel.getModelPart(modelSet, isSlim, isBaby), isSlim);
    }

    private static ModelPart getModelPart(EntityModelSet modelSet, boolean isSlim, boolean isBaby) {
        LayerDefinition layerDefinition = (LayerDefinition)modelSet.roots.get(isSlim ? ModelLayers.PLAYER_SLIM : ModelLayers.PLAYER);
        if (isBaby) {
            layerDefinition = layerDefinition.apply(BABY_TRANSFORMER);
        }
        return layerDefinition.bakeRoot();
    }

    public static ArmorModelSet<PlayerModel> getBabyArmorModel(boolean isSlim) {
        return PlayerModel.createArmorMeshSet((CubeDeformation)LayerDefinitions.INNER_ARMOR_DEFORMATION, (CubeDeformation)LayerDefinitions.OUTER_ARMOR_DEFORMATION).map(mesh -> new PlayerModel(LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32).apply(BABY_TRANSFORMER).bakeRoot(), isSlim));
    }

    public void setupAnim(@NotNull AvatarRenderState state) {
        super.setupAnim(state);
        this.update((FancyPlayerRenderState)state);
    }

    private void update(@NotNull FancyPlayerRenderState state) {
        this.leftArm.offsetRotation(state.leftArmRot.getOffset());
        this.rightArm.offsetRotation(state.rightArmRot.getOffset());
        this.leftLeg.offsetRotation(state.leftLegRot.getOffset());
        this.rightLeg.offsetRotation(state.rightLegRot.getOffset());
        this.head.offsetRotation(state.headRot.getOffset());
        this.leftArm.skipDraw = !state.showLeftArm;
        this.rightArm.skipDraw = !state.showRightArm;
        this.leftLeg.skipDraw = !state.showLeftLeg;
        this.rightLeg.skipDraw = !state.showRightLeg;
        this.head.skipDraw = !state.showHead;
        this.body.skipDraw = !state.showBody;
    }
}

