/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.fancy_entity_renderer.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import it.crystalnest.fancy_entity_renderer.api.entity.player.FancyPlayerRenderer;
import it.crystalnest.fancy_entity_renderer.api.entity.player.state.FancyPlayerRenderState;
import java.util.Map;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.player.PlayerModelType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityRenderDispatcher.class})
public abstract class EntityRenderDispatcherMixin {
    @Unique
    private Map<PlayerModelType, FancyPlayerRenderer> fancyPlayerRenderers = Map.of();

    @Inject(method={"getRenderer(Lnet/minecraft/client/renderer/entity/state/EntityRenderState;)Lnet/minecraft/client/renderer/entity/EntityRenderer;"}, at={@At(value="HEAD")}, cancellable=true)
    private <S extends EntityRenderState> void onGetRenderer(S renderState, CallbackInfoReturnable<EntityRenderer<?, ? super S>> cir) {
        if (renderState instanceof FancyPlayerRenderState) {
            FancyPlayerRenderState state = (FancyPlayerRenderState)renderState;
            FancyPlayerRenderer renderer = this.fancyPlayerRenderers.getOrDefault(state.skin.model(), this.fancyPlayerRenderers.get(PlayerModelType.SLIM));
            renderer.extractRenderState((AbstractClientPlayer)null, (AvatarRenderState)state, 0.0f);
            cir.setReturnValue((Object)renderer);
        }
    }

    @Inject(method={"onResourceManagerReload"}, at={@At(value="TAIL")})
    private void onOnResourceManagerReload(ResourceManager manager, CallbackInfo ci, @Local(ordinal=0) EntityRendererProvider.Context context) {
        this.fancyPlayerRenderers = Map.of(PlayerModelType.WIDE, new FancyPlayerRenderer(context, false), PlayerModelType.SLIM, new FancyPlayerRenderer(context, true));
    }
}

