/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.fancy_entity_renderer.mixin.client;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import it.crystalnest.fancy_entity_renderer.api.entity.player.state.FancyPlayerRenderState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.pip.GuiEntityRenderer;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.pip.GuiEntityRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.feature.FeatureRenderDispatcher;
import net.minecraft.client.renderer.state.CameraRenderState;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiEntityRenderer.class})
public abstract class GuiEntityRendererMixin
extends PictureInPictureRenderer<GuiEntityRenderState> {
    @Final
    @Shadow
    private EntityRenderDispatcher entityRenderDispatcher;

    private GuiEntityRendererMixin(MultiBufferSource.BufferSource bufferSource) {
        super(bufferSource);
    }

    @Inject(method={"renderToTexture(Lnet/minecraft/client/gui/render/state/pip/GuiEntityRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderToTexture(GuiEntityRenderState guiState, PoseStack poseStack, CallbackInfo ci) {
        EntityRenderState entityRenderState = guiState.renderState();
        if (entityRenderState instanceof FancyPlayerRenderState) {
            FancyPlayerRenderState renderState = (FancyPlayerRenderState)entityRenderState;
            Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ENTITY_IN_UI);
            poseStack.translate(guiState.translation().x, guiState.translation().y, guiState.translation().z);
            poseStack.scale(1.0f, -1.0f, -1.0f);
            poseStack.mulPose((Quaternionfc)guiState.rotation());
            FeatureRenderDispatcher dispatcher = Minecraft.getInstance().gameRenderer.getFeatureRenderDispatcher();
            CameraRenderState camera = new CameraRenderState();
            if (guiState.overrideCameraAngle() != null) {
                camera.orientation = guiState.overrideCameraAngle();
            }
            this.entityRenderDispatcher.submit((EntityRenderState)renderState, camera, 0.0, 0.0, 0.0, poseStack, (SubmitNodeCollector)dispatcher.getSubmitNodeStorage());
            dispatcher.renderAllFeatures();
            ci.cancel();
        }
    }
}

