/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.fancy_entity_renderer.api.entity.player;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.crystalnest.fancy_entity_renderer.api.entity.player.layer.FancyParrotOnShoulderLayer;
import it.crystalnest.fancy_entity_renderer.api.entity.player.mock.FancyPlayerMock;
import it.crystalnest.fancy_entity_renderer.api.entity.player.model.FancyPlayerModel;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ParrotOnShoulderLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class FancyPlayerRenderer
extends PlayerRenderer {
    private static final EntityRendererProvider.Context RENDER_CONTEXT = new EntityRendererProvider.Context(Minecraft.getInstance().getEntityRenderDispatcher(), Minecraft.getInstance().getItemRenderer(), Minecraft.getInstance().getBlockRenderer(), Minecraft.getInstance().getEntityRenderDispatcher().getItemInHandRenderer(), Minecraft.getInstance().getResourceManager(), Minecraft.getInstance().getEntityModels(), Minecraft.getInstance().font);
    public static final FancyPlayerRenderer SLIM_RENDERER = new FancyPlayerRenderer(true);
    public static final FancyPlayerRenderer WIDE_RENDERER = new FancyPlayerRenderer(false);

    public FancyPlayerRenderer(boolean isSlim) {
        super(RENDER_CONTEXT, isSlim);
        this.entityRenderDispatcher.overrideCameraOrientation(new Quaternionf());
        this.entityRenderDispatcher.setRenderShadow(false);
        this.entityRenderDispatcher.setRenderHitBoxes(false);
        this.model = new FancyPlayerModel(RENDER_CONTEXT.getModelSet(), isSlim);
        this.layers.replaceAll(layer -> {
            RenderLayer renderLayer = layer;
            Objects.requireNonNull(renderLayer);
            RenderLayer selector0$temp = renderLayer;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HumanoidArmorLayer.class, ParrotOnShoulderLayer.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    HumanoidArmorLayer l = (HumanoidArmorLayer)selector0$temp;
                    yield new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new HumanoidArmorModel(RENDER_CONTEXT.bakeLayer(isSlim ? ModelLayers.PLAYER_SLIM_INNER_ARMOR : ModelLayers.PLAYER_INNER_ARMOR)), (HumanoidModel)new HumanoidArmorModel(RENDER_CONTEXT.bakeLayer(isSlim ? ModelLayers.PLAYER_SLIM_OUTER_ARMOR : ModelLayers.PLAYER_OUTER_ARMOR)), RENDER_CONTEXT.getModelManager());
                }
                case 1 -> {
                    ParrotOnShoulderLayer l = (ParrotOnShoulderLayer)selector0$temp;
                    yield new FancyParrotOnShoulderLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)this, RENDER_CONTEXT.getModelSet());
                }
                default -> layer;
            };
        });
    }

    public void render(@NotNull AbstractClientPlayer entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        this.updatePlayer((FancyPlayerMock)entity, partialTick);
        super.render(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    protected void renderNameTag(@NotNull AbstractClientPlayer entity, @NotNull Component nameTag, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, float partialTick) {
        FancyPlayerMock player = (FancyPlayerMock)entity;
        if (player.showPlayerName && !player.isInvisibleToPlayer) {
            float scale = player.scale * 0.025f;
            Font font = this.getFont();
            poseStack.pushPose();
            Vec3 nameTagAttachment = player.getPose() == Pose.SLEEPING ? new Vec3((double)(((EntityDimensions)Player.POSES.get(player.getPose())).eyeHeight() * player.scale - player.boundingBoxHeight / 1.35f), 0.0, 0.0) : new Vec3(0.0, (double)(0.25f * player.scale), 0.0);
            float height = player.isBaby && player.getPose() != Pose.SPIN_ATTACK ? player.boundingBoxHeight * 0.5f : player.boundingBoxHeight;
            float offsetY = (player.getPose() == Pose.SLEEPING || player.getPose() == Pose.SWIMMING ? player.boundingBoxWidth : height) / scale + (float)nameTagAttachment.y;
            float offsetX = player.getPose() == Pose.SLEEPING ? -((float)nameTagAttachment.x) : (float)font.width((FormattedText)nameTag) / 2.0f;
            poseStack.scale(scale, -scale, scale);
            if (player.pinName) {
                poseStack.rotateAround(new Quaternionf().rotateY(player.modelRot.getY()), 0.0f, 0.0f, 0.0f);
            }
            poseStack.translate(-offsetX, -offsetY, 0.0f);
            if (player.isUpsideDown) {
                poseStack.scale(1.0f, -1.0f, 1.0f);
            }
            if (player.deathTime > 1) {
                poseStack.rotateAround(Axis.ZP.rotationDegrees(Math.min(Mth.sqrt((float)((float)(player.deathTime - 1) / 20.0f * 1.6f)), 1.0f) * this.getFlipDegrees((LivingEntity)player)), offsetX, offsetY, 0.0f);
            }
            font.drawInBatch(nameTag, 0.0f, 0.0f, 0x20FFFFFF, false, poseStack.last().pose(), bufferSource, Font.DisplayMode.SEE_THROUGH, (int)(Minecraft.getInstance().options.getBackgroundOpacity(0.25f) * 255.0f) << 24, packedLight);
            font.drawInBatch(nameTag, 0.0f, 0.0f, player.isCrouching() || player.isInvisible() ? 0x20FFFFFF : -1, false, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
            poseStack.popPose();
        }
    }

    protected void setupRotations(@NotNull AbstractClientPlayer entity, @NotNull PoseStack poseStack, float bob, float yBodyRot, float partialTick, float scale) {
        FancyPlayerMock player = (FancyPlayerMock)entity;
        if (player.getPose() == Pose.SPIN_ATTACK) {
            poseStack.mulPose(Axis.XN.rotationDegrees(90.0f));
        }
        super.setupRotations(entity, poseStack, bob, yBodyRot, partialTick, scale);
        if (player.isUpsideDown) {
            if (player.getPose() == Pose.DYING || player.getPose() == Pose.SPIN_ATTACK) {
                poseStack.translate(0.0f, (player.boundingBoxHeight + 0.1f) / scale, 0.0f);
                poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            } else if (player.getPose() == Pose.SLEEPING) {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
        }
    }

    public void render(@NotNull FancyPlayerMock entity, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        if (this.entityRenderDispatcher.camera == null) {
            this.entityRenderDispatcher.camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        }
        this.entityRenderDispatcher.overrideCameraOrientation(new Quaternionf().rotateXYZ(-entity.modelRot.getX(), entity.modelRot.getY(), -entity.modelRot.getZ()));
        this.entityRenderDispatcher.render((Entity)entity, 0.0, 0.0, 0.0, 0.0f, entity.isMoving && !entity.hasPose(Pose.DYING) ? entity.partialTick + entity.speedValue * 0.33f : 0.0f, poseStack, bufferSource, packedLight);
    }

    public void updatePlayer(@NotNull FancyPlayerMock player, float partialTick) {
        if (player.isMoving && !player.hasPose(Pose.DYING)) {
            player.partialTick = partialTick;
            if (!player.hasPose(Pose.SPIN_ATTACK) && !player.hasPose(Pose.SLEEPING)) {
                player.walkAnimation.setSpeed(player.walkSpeed);
            } else {
                player.walkAnimation.setSpeed(0.0f);
            }
        } else {
            player.tickCount = 3000;
            player.partialTick = 0.0f;
            player.walkAnimation.setSpeed(0.0f);
        }
    }

    protected boolean shouldShowName(@NotNull AbstractClientPlayer entity) {
        return true;
    }
}

