/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.fancy_entity_renderer.api.entity.player;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.math.Axis;
import it.crystalnest.fancy_entity_renderer.Constants;
import it.crystalnest.fancy_entity_renderer.api.Rotation;
import it.crystalnest.fancy_entity_renderer.api.entity.RenderMode;
import it.crystalnest.fancy_entity_renderer.api.entity.player.FancyPlayerRenderer;
import it.crystalnest.fancy_entity_renderer.api.entity.player.FancyProfileFetcher;
import it.crystalnest.fancy_entity_renderer.api.entity.player.mock.FancyPlayerMock;
import it.crystalnest.fancy_entity_renderer.compat.Prometheus;
import it.crystalnest.fancy_entity_renderer.platform.Services;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class FancyPlayerWidget
extends AbstractWidget {
    public static final float PLAYER_RENDER_HEIGHT = 1.875f;
    public static final float PLAYER_CROUCHING_EYE_HEIGHT = ((EntityDimensions)Player.POSES.get(Pose.CROUCHING)).eyeHeight();
    public static final float PLAYER_SIZE_RATIO = 2.9999998f;
    protected final FancyPlayerMock player = new FancyPlayerMock(new GameProfile(Util.NIL_UUID, "FancyMock"));
    protected final Random random = new Random();
    private final OverridableProperties properties;
    public List<Pose> allowedPoses;
    protected FancyPlayerRenderer renderer;

    public FancyPlayerWidget(int x, int y, int width, int height) {
        super(x, y, width, height, CommonComponents.EMPTY);
        this.properties = new OverridableProperties(this.player.name);
        this.allowedPoses = new ArrayList<Pose>();
        this.renderer = this.player.isSlim ? FancyPlayerRenderer.SLIM_RENDERER : FancyPlayerRenderer.WIDE_RENDERER;
    }

    private static void handlePlayerCopyError(String source) {
        Constants.LOGGER.error("Failed to copy player \"{}\"", (Object)source);
    }

    private static <T> Optional<T> handlePlayerCopyError(Throwable error) {
        Constants.LOGGER.error("Copy of player failed with error!", error);
        return Optional.empty();
    }

    protected void renderWidget(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        this.updateRenderState(this.getX(), this.getY(), this.getWidth(), this.getHeight(), mouseX, mouseY, partialTick);
        gfx.pose().pushPose();
        float offsetX = 0.0f;
        float offsetY = (float)this.renderer.getRenderOffset((AbstractClientPlayer)this.player, (float)0.0f).y;
        if (this.player.getPose() == Pose.SLEEPING) {
            offsetX += 1.875f * this.player.scale / 2.0f;
            offsetY -= 0.25f * this.player.scale;
            if (this.player.isBaby) {
                offsetX /= 1.75f;
                offsetY /= 1.5f;
            }
        }
        gfx.pose().translate((float)this.getX() + (float)this.getWidth() / 2.0f + offsetX, (float)(this.getY() + this.getHeight()) + offsetY, 100.0f);
        gfx.flush();
        gfx.pose().scale(1.0f, -1.0f, 1.0f);
        Lighting.setupForEntityInInventory((Quaternionf)Axis.XP.rotationDegrees(this.player.modelRot.getX()));
        gfx.pose().rotateAround(new Quaternionf().rotateXYZ(this.player.modelRot.getX(), -this.player.modelRot.getY(), this.player.modelRot.getZ()), 0.0f, 0.0f, 0.0f);
        this.renderer.render(this.player, gfx.pose(), (MultiBufferSource)gfx.bufferSource(), 0xF000F0);
        gfx.bufferSource().endBatch();
        gfx.flush();
        gfx.pose().popPose();
    }

    public void playDownSound(@NotNull SoundManager soundManager) {
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput output) {
    }

    public FancyPlayerWidget setBodyFollowsMouse(boolean followsMouse) {
        if (this.player.getPose() == Pose.STANDING || this.player.getPose() == Pose.CROUCHING || this.player.getPose() == Pose.SPIN_ATTACK) {
            this.player.bodyFollowsMouse = followsMouse;
            if (followsMouse) {
                this.properties.bodyRot.copy(this.player.modelRot);
            } else {
                this.player.modelRot.copy(this.properties.bodyRot);
            }
        } else {
            this.properties.bodyFollowsMouse = followsMouse;
        }
        return this;
    }

    public FancyPlayerWidget setHeadFollowsMouse(boolean followsMouse) {
        if (this.player.getPose() == Pose.STANDING || this.player.getPose() == Pose.CROUCHING || this.player.getPose() == Pose.SPIN_ATTACK) {
            this.player.headFollowsMouse = followsMouse;
            if (followsMouse) {
                this.properties.headRot.copy(this.player.headRot);
            } else {
                this.player.headRot.copy(this.properties.headRot);
            }
        } else {
            this.properties.headFollowsMouse = followsMouse;
        }
        return this;
    }

    public FancyPlayerWidget setHeadRotation(Rotation rotation) {
        this.properties.headRot.copy(rotation);
        this.player.headRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setHeadRotation(float x, float y, float z) {
        this.properties.headRot.setDeg(x, y, z);
        this.player.headRot.setDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setBodyRotation(Rotation rotation) {
        this.properties.bodyRot.copy(rotation);
        this.player.modelRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setBodyRotation(float x, float y, float z) {
        this.properties.bodyRot.setDeg(x, y, z);
        this.player.modelRot.setDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setLeftArmRotation(Rotation rotation) {
        this.player.leftArmRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setLeftArmRotation(float x, float y, float z) {
        this.player.leftArmRot.setDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setRightArmRotation(Rotation rotation) {
        this.player.rightArmRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setRightArmRotation(float x, float y, float z) {
        this.player.rightArmRot.setDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setLeftLegRotation(Rotation rotation) {
        this.player.leftLegRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setLeftLegRotation(float x, float y, float z) {
        this.player.leftLegRot.setDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setRightLegRotation(Rotation rotation) {
        this.player.rightLegRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setRightLegRotation(float x, float y, float z) {
        this.player.rightLegRot.setDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setSlim(boolean isSlim) {
        this.properties.isSlim = isSlim;
        if (!this.player.copyingPlayer && this.properties.skin == null) {
            this.updateIsSlim(this.properties.isSlim);
            this.renderer = isSlim ? FancyPlayerRenderer.SLIM_RENDERER : FancyPlayerRenderer.WIDE_RENDERER;
        }
        return this;
    }

    public FancyPlayerWidget setSkin(@Nullable PlayerSkin skin) {
        this.properties.skin = skin;
        if (!this.player.copyingPlayer) {
            this.updateSkin(skin);
        }
        return this;
    }

    public FancyPlayerWidget copyLocalPlayer() {
        this.player.copyingPlayer = true;
        this.copyPlayer(Minecraft.getInstance().getGameProfile());
        return this;
    }

    public FancyPlayerWidget setName(String name) {
        this.properties.name = name;
        if (!this.player.copyingPlayer) {
            this.player.name = name;
        }
        return this;
    }

    public FancyPlayerWidget setPinName(boolean pinName) {
        this.player.pinName = pinName;
        return this;
    }

    public FancyPlayerWidget setShowName(boolean showName) {
        this.player.showPlayerName = showName;
        return this;
    }

    public FancyPlayerWidget setShowCape(boolean showCape) {
        this.player.showCape = showCape;
        return this;
    }

    public FancyPlayerWidget setShowLeftArm(boolean showLeftArm) {
        this.player.showLeftArm = showLeftArm;
        return this;
    }

    public FancyPlayerWidget setShowLeftSleeve(boolean showLeftSleeve) {
        this.player.showLeftSleeve = showLeftSleeve;
        return this;
    }

    public FancyPlayerWidget setShowRightArm(boolean showRightArm) {
        this.player.showRightArm = showRightArm;
        return this;
    }

    public FancyPlayerWidget setShowRightSleeve(boolean showRightSleeve) {
        this.player.showRightSleeve = showRightSleeve;
        return this;
    }

    public FancyPlayerWidget setShowLeftLeg(boolean showLeftLeg) {
        this.player.showLeftLeg = showLeftLeg;
        return this;
    }

    public FancyPlayerWidget setShowLeftPants(boolean showLeftPants) {
        this.player.showLeftPants = showLeftPants;
        return this;
    }

    public FancyPlayerWidget setShowRightLeg(boolean showRightLeg) {
        this.player.showRightLeg = showRightLeg;
        return this;
    }

    public FancyPlayerWidget setShowRightPants(boolean showRightPants) {
        this.player.showRightPants = showRightPants;
        return this;
    }

    public FancyPlayerWidget setShowHead(boolean showHead) {
        this.player.showHead = showHead;
        return this;
    }

    public FancyPlayerWidget setShowHat(boolean showHat) {
        this.player.showHat = showHat;
        return this;
    }

    public FancyPlayerWidget setShowBody(boolean showBody) {
        this.player.showBody = showBody;
        return this;
    }

    public FancyPlayerWidget setShowJacket(boolean showJacket) {
        this.player.showJacket = showJacket;
        return this;
    }

    public FancyPlayerWidget setShowOuterLayer(boolean showOuterLayer) {
        this.setShowLeftSleeve(showOuterLayer);
        this.setShowRightSleeve(showOuterLayer);
        this.setShowLeftPants(showOuterLayer);
        this.setShowRightPants(showOuterLayer);
        this.setShowHat(showOuterLayer);
        this.setShowJacket(showOuterLayer);
        return this;
    }

    public FancyPlayerWidget setShowInnerLayer(boolean showInnerLayer) {
        this.setShowLeftArm(showInnerLayer);
        this.setShowRightArm(showInnerLayer);
        this.setShowLeftLeg(showInnerLayer);
        this.setShowRightLeg(showInnerLayer);
        this.setShowHead(showInnerLayer);
        this.setShowBody(showInnerLayer);
        return this;
    }

    public FancyPlayerWidget setUpsideDown(boolean isUpsideDown) {
        this.player.isUpsideDown = isUpsideDown;
        return this;
    }

    public FancyPlayerWidget setRenderMode(RenderMode mode) {
        this.player.isSpectator = RenderMode.SPECTATOR == mode;
        this.player.isInvisible = RenderMode.NORMAL != mode;
        this.player.isInvisibleToPlayer = RenderMode.INVISIBLE == mode;
        return this;
    }

    @ApiStatus.Experimental
    public FancyPlayerWidget setGlowing(boolean isGlowing) {
        this.player.appearsGlowing = isGlowing;
        return this;
    }

    public FancyPlayerWidget setMoving(boolean isMoving) {
        this.player.isMoving = isMoving;
        return this;
    }

    public FancyPlayerWidget setOnFire(boolean onFire) {
        if (this.player.getPose() == Pose.STANDING || this.player.getPose() == Pose.CROUCHING) {
            this.player.displayFireAnimation = onFire;
        } else {
            this.properties.displayFireAnimation = onFire;
        }
        return this;
    }

    public FancyPlayerWidget setOnFire(boolean onFire, ResourceLocation fireType) {
        if (Services.PLATFORM.isModLoaded("prometheus")) {
            Prometheus.setOnFire((Entity)this.player, fireType);
        }
        return this.setOnFire(onFire);
    }

    public FancyPlayerWidget setArrowCount(int count) {
        this.player.setArrowCount(count);
        return this;
    }

    public FancyPlayerWidget setStingerCount(int count) {
        this.player.setStingerCount(count);
        return this;
    }

    public FancyPlayerWidget setLeftParrot(@Nullable Parrot.Variant parrot) {
        if (this.player.isBaby || this.player.getPose() == Pose.SWIMMING) {
            this.properties.parrotOnLeftShoulder = parrot;
        } else {
            this.player.parrotOnLeftShoulder = parrot;
        }
        return this;
    }

    public FancyPlayerWidget setRightParrot(@Nullable Parrot.Variant parrot) {
        if (this.player.isBaby || this.player.getPose() == Pose.SWIMMING) {
            this.properties.parrotOnRightShoulder = parrot;
        } else {
            this.player.parrotOnRightShoulder = parrot;
        }
        return this;
    }

    public FancyPlayerWidget setParrots(@Nullable Parrot.Variant left, @Nullable Parrot.Variant right) {
        if (this.player.isBaby || this.player.getPose() == Pose.SWIMMING) {
            this.properties.parrotOnLeftShoulder = left;
            this.properties.parrotOnRightShoulder = right;
        } else {
            this.player.parrotOnLeftShoulder = left;
            this.player.parrotOnRightShoulder = right;
        }
        return this;
    }

    public FancyPlayerWidget setBaby(boolean isBaby) {
        this.player.isBaby = isBaby;
        if (isBaby) {
            this.properties.parrotOnLeftShoulder = this.player.parrotOnLeftShoulder;
            this.properties.parrotOnRightShoulder = this.player.parrotOnRightShoulder;
        } else {
            this.player.parrotOnLeftShoulder = this.properties.parrotOnLeftShoulder;
            this.player.parrotOnRightShoulder = this.properties.parrotOnRightShoulder;
        }
        return this;
    }

    public FancyPlayerWidget setPose(Pose pose) {
        if (Player.POSES.containsKey(pose) && pose != Pose.FALL_FLYING) {
            this.player.setPose(pose);
            this.player.isAutoSpinAttack = pose == Pose.SPIN_ATTACK;
            this.player.isVisuallySwimming = pose == Pose.SWIMMING;
            int n = this.player.deathTime = pose == Pose.DYING ? 5 : 0;
            if (pose == Pose.STANDING || pose == Pose.CROUCHING) {
                this.player.displayFireAnimation = this.properties.displayFireAnimation;
            } else {
                this.properties.displayFireAnimation = this.player.displayFireAnimation;
                this.player.displayFireAnimation = false;
            }
            if (pose == Pose.STANDING || pose == Pose.CROUCHING || pose == Pose.SPIN_ATTACK) {
                this.player.headFollowsMouse = this.properties.headFollowsMouse;
                this.player.bodyFollowsMouse = this.properties.bodyFollowsMouse;
            } else {
                this.properties.headFollowsMouse = this.player.headFollowsMouse;
                this.properties.bodyFollowsMouse = this.player.bodyFollowsMouse;
                this.player.headFollowsMouse = false;
                this.player.bodyFollowsMouse = false;
            }
            if (pose == Pose.SWIMMING) {
                this.properties.parrotOnLeftShoulder = this.player.parrotOnLeftShoulder;
                this.properties.parrotOnRightShoulder = this.player.parrotOnRightShoulder;
                this.player.parrotOnLeftShoulder = null;
                this.player.parrotOnRightShoulder = null;
            } else {
                this.player.parrotOnLeftShoulder = this.properties.parrotOnLeftShoulder;
                this.player.parrotOnRightShoulder = this.properties.parrotOnRightShoulder;
            }
        } else {
            Constants.LOGGER.warn("Pose {} is not supported for Player entity!", (Object)pose);
        }
        return this;
    }

    public FancyPlayerWidget setMovementSpeed(float speed) {
        this.player.speedValue = speed;
        return this;
    }

    public FancyPlayerWidget setWalkingSpeed(float speed) {
        this.player.walkSpeed = speed;
        return this;
    }

    public FancyPlayerWidget setRightHandItem(@Nullable String item, HolderLookup.Provider provider) {
        this.player.setItemInHand(InteractionHand.MAIN_HAND, this.getNullableItem(item, i -> this.parseItem((String)i, provider)));
        return this;
    }

    public FancyPlayerWidget setLeftHandItem(@Nullable String item, HolderLookup.Provider provider) {
        this.player.setItemInHand(InteractionHand.OFF_HAND, this.getNullableItem(item, i -> this.parseItem((String)i, provider)));
        return this;
    }

    public FancyPlayerWidget setRightHandItem(@Nullable Item item) {
        this.player.setItemInHand(InteractionHand.MAIN_HAND, this.getNullableItem(item, Item::getDefaultInstance));
        return this;
    }

    public FancyPlayerWidget setLeftHandItem(@Nullable Item item) {
        this.player.setItemInHand(InteractionHand.OFF_HAND, this.getNullableItem(item, Item::getDefaultInstance));
        return this;
    }

    public FancyPlayerWidget setRightHandItem(@Nullable ItemStack item) {
        this.player.setItemInHand(InteractionHand.MAIN_HAND, this.getNullableItem(item, i -> i));
        return this;
    }

    public FancyPlayerWidget setLeftHandItem(@Nullable ItemStack item) {
        this.player.setItemInHand(InteractionHand.OFF_HAND, this.getNullableItem(item, i -> i));
        return this;
    }

    public FancyPlayerWidget setHeadWearable(@Nullable String item, HolderLookup.Provider provider) {
        this.player.setItemSlot(EquipmentSlot.HEAD, this.getNullableItem(item, i -> this.parseItem((String)i, provider)));
        return this;
    }

    public FancyPlayerWidget setChestWearable(@Nullable String item, HolderLookup.Provider provider) {
        this.player.setItemSlot(EquipmentSlot.CHEST, this.getNullableItem(item, i -> this.parseItem((String)i, provider)));
        return this;
    }

    public FancyPlayerWidget setLegsWearable(@Nullable String item, HolderLookup.Provider provider) {
        this.player.setItemSlot(EquipmentSlot.LEGS, this.getNullableItem(item, i -> this.parseItem((String)i, provider)));
        return this;
    }

    public FancyPlayerWidget setFeetWearable(@Nullable String item, HolderLookup.Provider provider) {
        this.player.setItemSlot(EquipmentSlot.FEET, this.getNullableItem(item, i -> this.parseItem((String)i, provider)));
        return this;
    }

    public FancyPlayerWidget setHeadWearable(@Nullable Item item) {
        this.player.setItemSlot(EquipmentSlot.HEAD, this.getNullableItem(item, Item::getDefaultInstance));
        return this;
    }

    public FancyPlayerWidget setChestWearable(@Nullable Item item) {
        this.player.setItemSlot(EquipmentSlot.CHEST, this.getNullableItem(item, Item::getDefaultInstance));
        return this;
    }

    public FancyPlayerWidget setLegsWearable(@Nullable Item item) {
        this.player.setItemSlot(EquipmentSlot.LEGS, this.getNullableItem(item, Item::getDefaultInstance));
        return this;
    }

    public FancyPlayerWidget setFeetWearable(@Nullable Item item) {
        this.player.setItemSlot(EquipmentSlot.FEET, this.getNullableItem(item, Item::getDefaultInstance));
        return this;
    }

    public FancyPlayerWidget setHeadWearable(@Nullable ItemStack item) {
        this.player.setItemSlot(EquipmentSlot.HEAD, this.getNullableItem(item, i -> i));
        return this;
    }

    public FancyPlayerWidget setChestWearable(@Nullable ItemStack item) {
        this.player.setItemSlot(EquipmentSlot.CHEST, this.getNullableItem(item, i -> i));
        return this;
    }

    public FancyPlayerWidget setLegsWearable(@Nullable ItemStack item) {
        this.player.setItemSlot(EquipmentSlot.LEGS, this.getNullableItem(item, i -> i));
        return this;
    }

    public FancyPlayerWidget setFeetWearable(@Nullable ItemStack item) {
        this.player.setItemSlot(EquipmentSlot.FEET, this.getNullableItem(item, i -> i));
        return this;
    }

    private <T> ItemStack getNullableItem(T item, Function<T, ItemStack> getter) {
        return item == null ? ItemStack.EMPTY : getter.apply(item);
    }

    private ItemStack parseItem(String item, HolderLookup.Provider provider) {
        try {
            ItemParser.ItemResult result = new ItemParser(provider).parse(new StringReader(item));
            return new ItemInput(result.item(), result.components()).createItemStack(1, false);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Error parsing {}", (Object)item, (Object)e);
            return ItemStack.EMPTY;
        }
    }

    public FancyPlayerWidget copyPlayer(String profileName) {
        return this.copyPlayer(FancyProfileFetcher.fetchProfile(profileName), profileName);
    }

    public FancyPlayerWidget copyPlayer(UUID profileId) {
        return this.copyPlayer(FancyProfileFetcher.fetchProfile(profileId), profileId.toString());
    }

    public FancyPlayerWidget uncopyPlayer() {
        this.player.copyingPlayer = false;
        this.updateSkin(this.properties.skin);
        this.player.name = this.properties.name;
        return this;
    }

    public boolean isCopyingPlayer() {
        return this.player.copyingPlayer;
    }

    private FancyPlayerWidget copyPlayer(CompletableFuture<Optional<GameProfile>> result, String source) {
        ((CompletableFuture)result.exceptionally(FancyPlayerWidget::handlePlayerCopyError)).thenAccept(profile -> profile.ifPresentOrElse(this::copyPlayer, () -> FancyPlayerWidget.handlePlayerCopyError(source)));
        return this;
    }

    private FancyPlayerWidget copyPlayer(GameProfile profile) {
        ((CompletableFuture)Minecraft.getInstance().getSkinManager().getOrLoad(profile).exceptionally(throwable -> FancyPlayerWidget.handlePlayerCopyError(throwable).orElse(null))).thenAccept(skin -> {
            this.player.copyingPlayer = true;
            this.properties.name = this.player.name;
            this.player.name = profile.getName();
            if (skin != null) {
                this.updateSkin((PlayerSkin)skin);
            } else {
                FancyPlayerWidget.handlePlayerCopyError(this.player.name);
            }
        });
        return this;
    }

    private void updateSkin(@Nullable PlayerSkin skin) {
        if (skin != null) {
            this.player.isSlim = skin.model() == PlayerSkin.Model.SLIM;
            this.player.skin = skin;
        } else {
            this.updateIsSlim(this.properties.isSlim);
        }
        this.renderer = this.player.isSlim ? FancyPlayerRenderer.SLIM_RENDERER : FancyPlayerRenderer.WIDE_RENDERER;
    }

    private void updateIsSlim(boolean isSlim) {
        this.player.isSlim = isSlim;
        this.player.skin = DefaultPlayerSkin.DEFAULT_SKINS[this.random.nextInt(9) + (isSlim ? 0 : 9)];
    }

    private void updateRenderState(int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
        this.player.boundingBoxWidth = (float)height / 2.9999998f;
        this.player.boundingBoxHeight = height;
        this.player.scale = (float)height / 1.875f;
        if (this.player.bodyFollowsMouse || this.player.headFollowsMouse) {
            float renderHeight = this.player.getPose() == Pose.CROUCHING ? 1.5f : 1.875f;
            float eyeHeight = this.player.getPose() == Pose.CROUCHING ? PLAYER_CROUCHING_EYE_HEIGHT : 1.62f;
            float adultEyeY = (renderHeight - eyeHeight) * (float)height / renderHeight;
            float eyeY = (float)y + (this.player.isBaby ? ((float)height + adultEyeY) * 0.5f : adultEyeY);
            float eyeX = (float)x + (float)width / 2.0f;
            double mouseXRelative = (float)mouseX - eyeX;
            double mouseYRelative = (float)mouseY - eyeY;
            double xRot = Math.atan(mouseYRelative / 40.0) * 20.0;
            double yRot = -Math.atan(mouseXRelative / 40.0) * 20.0;
            if (this.player.isUpsideDown) {
                xRot = -xRot;
                yRot = -yRot;
            }
            if (this.player.bodyFollowsMouse) {
                this.player.modelRot.setXDeg(xRot);
                this.player.modelRot.setYDeg(yRot);
                this.player.modelRot.setZ(0.0);
            }
            if (this.player.headFollowsMouse) {
                this.player.headRot.setXDeg(xRot);
                this.player.headRot.setYDeg(yRot);
                this.player.headRot.setZ(0.0);
            }
        }
    }

    private static final class OverridableProperties {
        final Rotation headRot = new Rotation();
        final Rotation bodyRot = new Rotation();
        public boolean bodyFollowsMouse;
        public boolean headFollowsMouse;
        boolean isSlim;
        @NotNull
        String name;
        @Nullable
        PlayerSkin skin;
        @Nullable
        Parrot.Variant parrotOnLeftShoulder;
        @Nullable
        Parrot.Variant parrotOnRightShoulder;
        boolean displayFireAnimation;

        private OverridableProperties(@NotNull String name) {
            this.name = name;
        }
    }
}

