/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.fancy_entity_renderer.api.entity.player;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.io.File;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.server.Services;
import net.minecraft.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FancyProfileFetcher {
    @Nullable
    private static LoadingCache<String, CompletableFuture<Optional<GameProfile>>> profileCacheByName;
    @Nullable
    private static LoadingCache<UUID, CompletableFuture<Optional<GameProfile>>> profileCacheById;

    private FancyProfileFetcher() {
    }

    public static void setup() {
        Minecraft minecraft = Minecraft.getInstance();
        final Services services = Services.create((YggdrasilAuthenticationService)minecraft.authenticationService, (File)minecraft.gameDirectory);
        services.profileCache().setExecutor((Executor)minecraft);
        profileCacheByName = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(256L).build((CacheLoader)new CacheLoader<String, CompletableFuture<Optional<GameProfile>>>(){

            @NotNull
            public CompletableFuture<Optional<GameProfile>> load(@NotNull String username) {
                return FancyProfileFetcher.fetchProfile(username, services);
            }
        });
        profileCacheById = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(256L).build((CacheLoader)new CacheLoader<UUID, CompletableFuture<Optional<GameProfile>>>(){

            @NotNull
            public CompletableFuture<Optional<GameProfile>> load(@NotNull UUID id) {
                return FancyProfileFetcher.fetchProfile(id, services, () -> profileCacheById == null);
            }
        });
    }

    static CompletableFuture<Optional<GameProfile>> fetchProfile(String name, Services services) {
        return services.profileCache().getAsync(name).thenCompose(cached -> {
            LoadingCache<UUID, CompletableFuture<Optional<GameProfile>>> loadingcache = profileCacheById;
            return loadingcache != null && cached.isPresent() ? ((CompletableFuture)loadingcache.getUnchecked((Object)((GameProfile)cached.get()).getId())).thenApply(profile -> profile.or(() -> cached)) : CompletableFuture.completedFuture(Optional.empty());
        });
    }

    static CompletableFuture<Optional<GameProfile>> fetchProfile(UUID id, Services services, BooleanSupplier cacheUninitialized) {
        return CompletableFuture.supplyAsync(() -> cacheUninitialized.getAsBoolean() ? Optional.empty() : Optional.ofNullable(services.sessionService().fetchProfile(id, true)).map(ProfileResult::profile), Util.backgroundExecutor());
    }

    public static CompletableFuture<Optional<GameProfile>> fetchProfile(String profileName) {
        LoadingCache<String, CompletableFuture<Optional<GameProfile>>> loadingcache = profileCacheByName;
        return loadingcache != null && StringUtil.isValidPlayerName((String)profileName) ? (CompletableFuture)loadingcache.getUnchecked((Object)profileName) : CompletableFuture.completedFuture(Optional.empty());
    }

    public static CompletableFuture<Optional<GameProfile>> fetchProfile(UUID profileId) {
        LoadingCache<UUID, CompletableFuture<Optional<GameProfile>>> loadingcache = profileCacheById;
        return loadingcache != null ? (CompletableFuture)loadingcache.getUnchecked((Object)profileId) : CompletableFuture.completedFuture(Optional.empty());
    }
}

