/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.fancy_entity_renderer.api.entity.player.model;

import it.crystalnest.fancy_entity_renderer.api.entity.player.mock.FancyPlayerMock;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class FancyPlayerModel
extends PlayerModel<AbstractClientPlayer> {
    public FancyPlayerModel(EntityModelSet modelSet, boolean isSlim) {
        super(((LayerDefinition)modelSet.roots.get(isSlim ? ModelLayers.PLAYER_SLIM : ModelLayers.PLAYER)).bakeRoot(), isSlim);
    }

    public void setupAnim(@NotNull AbstractClientPlayer entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.update((FancyPlayerMock)entity);
    }

    private void update(@NotNull FancyPlayerMock player) {
        this.leftArm.offsetRotation(player.leftArmRot.getOffset());
        this.leftSleeve.offsetRotation(player.leftArmRot.getOffset());
        this.rightArm.offsetRotation(player.rightArmRot.getOffset());
        this.rightSleeve.offsetRotation(player.rightArmRot.getOffset());
        this.leftLeg.offsetRotation(player.leftLegRot.getOffset());
        this.leftPants.offsetRotation(player.leftLegRot.getOffset());
        this.rightLeg.offsetRotation(player.rightLegRot.getOffset());
        this.rightPants.offsetRotation(player.rightLegRot.getOffset());
        this.head.offsetRotation(player.headRot.getOffset());
        this.hat.offsetRotation(player.headRot.getOffset());
        if (player.isBaby) {
            this.hat.xScale *= 1.5f;
            this.hat.yScale *= 1.5f;
            this.hat.zScale *= 1.5f;
        }
        this.leftArm.skipDraw = !player.showLeftArm;
        this.leftSleeve.skipDraw = !player.showLeftSleeve;
        this.rightArm.skipDraw = !player.showRightArm;
        this.rightSleeve.skipDraw = !player.showRightSleeve;
        this.leftLeg.skipDraw = !player.showLeftLeg;
        this.leftPants.skipDraw = !player.showLeftPants;
        this.rightLeg.skipDraw = !player.showRightLeg;
        this.rightPants.skipDraw = !player.showRightPants;
        this.head.skipDraw = !player.showHead;
        this.hat.skipDraw = !player.showHat;
        this.body.skipDraw = !player.showBody;
        this.jacket.skipDraw = !player.showJacket;
    }
}

