/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.fancy_entity_renderer.api.entity.player;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.crystalnest.fancy_entity_renderer.Constants;
import it.crystalnest.fancy_entity_renderer.api.Rotation;
import it.crystalnest.fancy_entity_renderer.api.entity.RenderMode;
import it.crystalnest.fancy_entity_renderer.api.entity.player.FancyPlayerRenderer;
import it.crystalnest.fancy_entity_renderer.api.entity.player.FancyProfileFetcher;
import it.crystalnest.fancy_entity_renderer.api.entity.player.mock.FancyPlayerMock;
import it.crystalnest.fancy_entity_renderer.platform.Services;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.class_1068;
import net.minecraft.class_1144;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1453;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2290;
import net.minecraft.class_2291;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4597;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import net.minecraft.class_7225;
import net.minecraft.class_742;
import net.minecraft.class_7833;
import net.minecraft.class_8685;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class FancyPlayerWidget
extends class_339 {
    public static final float PLAYER_RENDER_HEIGHT = 1.875f;
    public static final float PLAYER_CROUCHING_EYE_HEIGHT = ((class_4048)class_1657.field_18134.get(class_4050.field_18081)).comp_2187();
    public static final float PLAYER_SIZE_RATIO = 2.9999998f;
    protected final FancyPlayerMock player = new FancyPlayerMock(new GameProfile(class_156.field_25140, "FancyMock"));
    protected final Random random = new Random();
    private final OverridableProperties properties;
    public List<class_4050> allowedPoses;
    protected FancyPlayerRenderer renderer;

    public FancyPlayerWidget(int x, int y, int width, int height) {
        super(x, y, width, height, class_5244.field_39003);
        this.properties = new OverridableProperties(this.player.name);
        this.allowedPoses = new ArrayList<class_4050>();
        this.renderer = this.player.isSlim ? FancyPlayerRenderer.SLIM_RENDERER : FancyPlayerRenderer.WIDE_RENDERER;
    }

    private static void handlePlayerCopyError(String source) {
        Constants.LOGGER.error("Failed to copy player \"{}\"", (Object)source);
    }

    private static <T> Optional<T> handlePlayerCopyError(Throwable error) {
        Constants.LOGGER.error("Copy of player failed with error!", error);
        return Optional.empty();
    }

    protected void method_48579(class_332 gfx, int mouseX, int mouseY, float partialTick) {
        this.updateRenderState(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), mouseX, mouseY, partialTick);
        gfx.method_51448().method_22903();
        float offsetX = 0.0f;
        float offsetY = (float)this.renderer.method_23206((class_742)this.player, (float)0.0f).field_1351;
        if (this.player.method_18376() == class_4050.field_18078) {
            offsetX += 1.875f * this.player.scale / 2.0f;
            offsetY -= 0.25f * this.player.scale;
            if (this.player.isBaby) {
                offsetX /= 1.75f;
                offsetY /= 1.5f;
            }
        }
        gfx.method_51448().method_46416((float)this.method_46426() + (float)this.method_25368() / 2.0f + offsetX, (float)(this.method_46427() + this.method_25364()) + offsetY, 100.0f);
        gfx.method_51452();
        gfx.method_51448().method_22905(1.0f, -1.0f, 1.0f);
        class_308.method_56819((Quaternionf)class_7833.field_40714.rotationDegrees(this.player.modelRot.getX()));
        gfx.method_51448().method_49278(new Quaternionf().rotateXYZ(this.player.modelRot.getX(), -this.player.modelRot.getY(), this.player.modelRot.getZ()), 0.0f, 0.0f, 0.0f);
        this.renderer.render(this.player, gfx.method_51448(), (class_4597)gfx.method_51450(), 0xF000F0);
        gfx.method_51450().method_22993();
        gfx.method_51452();
        gfx.method_51448().method_22909();
    }

    public void method_25354(@NotNull class_1144 soundManager) {
    }

    protected void method_47399(@NotNull class_6382 output) {
    }

    public FancyPlayerWidget setBodyFollowsMouse(boolean followsMouse) {
        if (this.player.method_18376() == class_4050.field_18076 || this.player.method_18376() == class_4050.field_18081 || this.player.method_18376() == class_4050.field_18080) {
            this.player.bodyFollowsMouse = followsMouse;
            if (followsMouse) {
                this.properties.bodyRot.copy(this.player.modelRot);
            } else {
                this.player.modelRot.copy(this.properties.bodyRot);
            }
        } else {
            this.properties.bodyFollowsMouse = followsMouse;
        }
        return this;
    }

    public FancyPlayerWidget setHeadFollowsMouse(boolean followsMouse) {
        if (this.player.method_18376() == class_4050.field_18076 || this.player.method_18376() == class_4050.field_18081 || this.player.method_18376() == class_4050.field_18080) {
            this.player.headFollowsMouse = followsMouse;
            if (followsMouse) {
                this.properties.headRot.copy(this.player.headRot);
            } else {
                this.player.headRot.copy(this.properties.headRot);
            }
        } else {
            this.properties.headFollowsMouse = followsMouse;
        }
        return this;
    }

    public FancyPlayerWidget setHeadRotation(Rotation rotation) {
        this.properties.headRot.copy(rotation);
        this.player.headRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setHeadRotation(float x, float y, float z) {
        this.properties.headRot.setDeg(x, y, z);
        this.player.headRot.setDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setBodyRotation(Rotation rotation) {
        this.properties.bodyRot.copy(rotation);
        this.player.modelRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setBodyRotation(float x, float y, float z) {
        this.properties.bodyRot.setDeg(x, y, z);
        this.player.modelRot.setDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setLeftArmRotation(Rotation rotation) {
        this.player.leftArmRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setLeftArmRotation(float x, float y, float z) {
        this.player.leftArmRot.setDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setRightArmRotation(Rotation rotation) {
        this.player.rightArmRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setRightArmRotation(float x, float y, float z) {
        this.player.rightArmRot.setDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setLeftLegRotation(Rotation rotation) {
        this.player.leftLegRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setLeftLegRotation(float x, float y, float z) {
        this.player.leftLegRot.setDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setRightLegRotation(Rotation rotation) {
        this.player.rightLegRot.copy(rotation);
        return this;
    }

    public FancyPlayerWidget setRightLegRotation(float x, float y, float z) {
        this.player.rightLegRot.setDeg(x, y, z);
        return this;
    }

    public FancyPlayerWidget setSlim(boolean isSlim) {
        this.properties.isSlim = isSlim;
        if (!this.player.copyingPlayer && this.properties.skin == null) {
            this.updateIsSlim(this.properties.isSlim);
            this.renderer = isSlim ? FancyPlayerRenderer.SLIM_RENDERER : FancyPlayerRenderer.WIDE_RENDERER;
        }
        return this;
    }

    public FancyPlayerWidget setSkin(@Nullable class_8685 skin) {
        this.properties.skin = skin;
        if (!this.player.copyingPlayer) {
            this.updateSkin(skin);
        }
        return this;
    }

    public FancyPlayerWidget copyLocalPlayer() {
        this.player.copyingPlayer = true;
        this.copyPlayer(class_310.method_1551().method_53462());
        return this;
    }

    public FancyPlayerWidget setName(String name) {
        this.properties.name = name;
        if (!this.player.copyingPlayer) {
            this.player.name = name;
        }
        return this;
    }

    public FancyPlayerWidget setPinName(boolean pinName) {
        this.player.pinName = pinName;
        return this;
    }

    public FancyPlayerWidget setShowName(boolean showName) {
        this.player.showPlayerName = showName;
        return this;
    }

    public FancyPlayerWidget setShowCape(boolean showCape) {
        this.player.showCape = showCape;
        return this;
    }

    public FancyPlayerWidget setShowLeftArm(boolean showLeftArm) {
        this.player.showLeftArm = showLeftArm;
        return this;
    }

    public FancyPlayerWidget setShowLeftSleeve(boolean showLeftSleeve) {
        this.player.showLeftSleeve = showLeftSleeve;
        return this;
    }

    public FancyPlayerWidget setShowRightArm(boolean showRightArm) {
        this.player.showRightArm = showRightArm;
        return this;
    }

    public FancyPlayerWidget setShowRightSleeve(boolean showRightSleeve) {
        this.player.showRightSleeve = showRightSleeve;
        return this;
    }

    public FancyPlayerWidget setShowLeftLeg(boolean showLeftLeg) {
        this.player.showLeftLeg = showLeftLeg;
        return this;
    }

    public FancyPlayerWidget setShowLeftPants(boolean showLeftPants) {
        this.player.showLeftPants = showLeftPants;
        return this;
    }

    public FancyPlayerWidget setShowRightLeg(boolean showRightLeg) {
        this.player.showRightLeg = showRightLeg;
        return this;
    }

    public FancyPlayerWidget setShowRightPants(boolean showRightPants) {
        this.player.showRightPants = showRightPants;
        return this;
    }

    public FancyPlayerWidget setShowHead(boolean showHead) {
        this.player.showHead = showHead;
        return this;
    }

    public FancyPlayerWidget setShowHat(boolean showHat) {
        this.player.showHat = showHat;
        return this;
    }

    public FancyPlayerWidget setShowBody(boolean showBody) {
        this.player.showBody = showBody;
        return this;
    }

    public FancyPlayerWidget setShowJacket(boolean showJacket) {
        this.player.showJacket = showJacket;
        return this;
    }

    public FancyPlayerWidget setShowOuterLayer(boolean showOuterLayer) {
        this.setShowLeftSleeve(showOuterLayer);
        this.setShowRightSleeve(showOuterLayer);
        this.setShowLeftPants(showOuterLayer);
        this.setShowRightPants(showOuterLayer);
        this.setShowHat(showOuterLayer);
        this.setShowJacket(showOuterLayer);
        return this;
    }

    public FancyPlayerWidget setShowInnerLayer(boolean showInnerLayer) {
        this.setShowLeftArm(showInnerLayer);
        this.setShowRightArm(showInnerLayer);
        this.setShowLeftLeg(showInnerLayer);
        this.setShowRightLeg(showInnerLayer);
        this.setShowHead(showInnerLayer);
        this.setShowBody(showInnerLayer);
        return this;
    }

    public FancyPlayerWidget setUpsideDown(boolean isUpsideDown) {
        this.player.isUpsideDown = isUpsideDown;
        return this;
    }

    public FancyPlayerWidget setRenderMode(RenderMode mode) {
        this.player.isSpectator = RenderMode.SPECTATOR == mode;
        this.player.isInvisible = RenderMode.NORMAL != mode;
        this.player.isInvisibleToPlayer = RenderMode.INVISIBLE == mode;
        return this;
    }

    @ApiStatus.Experimental
    public FancyPlayerWidget setGlowing(boolean isGlowing) {
        this.player.appearsGlowing = isGlowing;
        return this;
    }

    public FancyPlayerWidget setMoving(boolean isMoving) {
        this.player.isMoving = isMoving;
        return this;
    }

    public FancyPlayerWidget setOnFire(boolean onFire) {
        if (this.player.method_18376() == class_4050.field_18076 || this.player.method_18376() == class_4050.field_18081) {
            this.player.displayFireAnimation = onFire;
        } else {
            this.properties.displayFireAnimation = onFire;
        }
        return this;
    }

    public FancyPlayerWidget setOnFire(boolean onFire, class_2960 fireType) {
        if (Services.PLATFORM.isModLoaded("soul_fire_d")) {
            Services.COMPAT.setOnFire((class_1297)this.player, fireType);
        }
        return this.setOnFire(onFire);
    }

    public FancyPlayerWidget setArrowCount(int count) {
        this.player.method_6097(count);
        return this;
    }

    public FancyPlayerWidget setStingerCount(int count) {
        this.player.method_21755(count);
        return this;
    }

    public FancyPlayerWidget setLeftParrot(@Nullable class_1453.class_7989 parrot) {
        if (this.player.isBaby || this.player.method_18376() == class_4050.field_18079) {
            this.properties.parrotOnLeftShoulder = parrot;
        } else {
            this.player.parrotOnLeftShoulder = parrot;
        }
        return this;
    }

    public FancyPlayerWidget setRightParrot(@Nullable class_1453.class_7989 parrot) {
        if (this.player.isBaby || this.player.method_18376() == class_4050.field_18079) {
            this.properties.parrotOnRightShoulder = parrot;
        } else {
            this.player.parrotOnRightShoulder = parrot;
        }
        return this;
    }

    public FancyPlayerWidget setParrots(@Nullable class_1453.class_7989 left, @Nullable class_1453.class_7989 right) {
        if (this.player.isBaby || this.player.method_18376() == class_4050.field_18079) {
            this.properties.parrotOnLeftShoulder = left;
            this.properties.parrotOnRightShoulder = right;
        } else {
            this.player.parrotOnLeftShoulder = left;
            this.player.parrotOnRightShoulder = right;
        }
        return this;
    }

    public FancyPlayerWidget setBaby(boolean isBaby) {
        this.player.isBaby = isBaby;
        if (isBaby) {
            this.properties.parrotOnLeftShoulder = this.player.parrotOnLeftShoulder;
            this.properties.parrotOnRightShoulder = this.player.parrotOnRightShoulder;
        } else {
            this.player.parrotOnLeftShoulder = this.properties.parrotOnLeftShoulder;
            this.player.parrotOnRightShoulder = this.properties.parrotOnRightShoulder;
        }
        return this;
    }

    public FancyPlayerWidget setPose(class_4050 pose) {
        if (class_1657.field_18134.containsKey(pose) && pose != class_4050.field_18077) {
            this.player.method_18380(pose);
            this.player.isAutoSpinAttack = pose == class_4050.field_18080;
            this.player.isVisuallySwimming = pose == class_4050.field_18079;
            int n = this.player.field_6213 = pose == class_4050.field_18082 ? 5 : 0;
            if (pose == class_4050.field_18076 || pose == class_4050.field_18081) {
                this.player.displayFireAnimation = this.properties.displayFireAnimation;
            } else {
                this.properties.displayFireAnimation = this.player.displayFireAnimation;
                this.player.displayFireAnimation = false;
            }
            if (pose == class_4050.field_18076 || pose == class_4050.field_18081 || pose == class_4050.field_18080) {
                this.player.headFollowsMouse = this.properties.headFollowsMouse;
                this.player.bodyFollowsMouse = this.properties.bodyFollowsMouse;
            } else {
                this.properties.headFollowsMouse = this.player.headFollowsMouse;
                this.properties.bodyFollowsMouse = this.player.bodyFollowsMouse;
                this.player.headFollowsMouse = false;
                this.player.bodyFollowsMouse = false;
            }
            if (pose == class_4050.field_18079) {
                this.properties.parrotOnLeftShoulder = this.player.parrotOnLeftShoulder;
                this.properties.parrotOnRightShoulder = this.player.parrotOnRightShoulder;
                this.player.parrotOnLeftShoulder = null;
                this.player.parrotOnRightShoulder = null;
            } else {
                this.player.parrotOnLeftShoulder = this.properties.parrotOnLeftShoulder;
                this.player.parrotOnRightShoulder = this.properties.parrotOnRightShoulder;
            }
        } else {
            Constants.LOGGER.warn("Pose {} is not supported for Player entity!", (Object)pose);
        }
        return this;
    }

    public FancyPlayerWidget setMovementSpeed(float speed) {
        this.player.speedValue = speed;
        return this;
    }

    public FancyPlayerWidget setWalkingSpeed(float speed) {
        this.player.walkSpeed = speed;
        return this;
    }

    public FancyPlayerWidget setRightHandItem(@Nullable String item, class_7225.class_7874 provider) {
        this.player.method_6122(class_1268.field_5808, this.getNullableItem(item, i -> this.parseItem((String)i, provider)));
        return this;
    }

    public FancyPlayerWidget setLeftHandItem(@Nullable String item, class_7225.class_7874 provider) {
        this.player.method_6122(class_1268.field_5810, this.getNullableItem(item, i -> this.parseItem((String)i, provider)));
        return this;
    }

    public FancyPlayerWidget setRightHandItem(@Nullable class_1792 item) {
        this.player.method_6122(class_1268.field_5808, this.getNullableItem(item, class_1792::method_7854));
        return this;
    }

    public FancyPlayerWidget setLeftHandItem(@Nullable class_1792 item) {
        this.player.method_6122(class_1268.field_5810, this.getNullableItem(item, class_1792::method_7854));
        return this;
    }

    public FancyPlayerWidget setRightHandItem(@Nullable class_1799 item) {
        this.player.method_6122(class_1268.field_5808, this.getNullableItem(item, i -> i));
        return this;
    }

    public FancyPlayerWidget setLeftHandItem(@Nullable class_1799 item) {
        this.player.method_6122(class_1268.field_5810, this.getNullableItem(item, i -> i));
        return this;
    }

    public FancyPlayerWidget setHeadWearable(@Nullable String item, class_7225.class_7874 provider) {
        this.player.method_5673(class_1304.field_6169, this.getNullableItem(item, i -> this.parseItem((String)i, provider)));
        return this;
    }

    public FancyPlayerWidget setChestWearable(@Nullable String item, class_7225.class_7874 provider) {
        this.player.method_5673(class_1304.field_6174, this.getNullableItem(item, i -> this.parseItem((String)i, provider)));
        return this;
    }

    public FancyPlayerWidget setLegsWearable(@Nullable String item, class_7225.class_7874 provider) {
        this.player.method_5673(class_1304.field_6172, this.getNullableItem(item, i -> this.parseItem((String)i, provider)));
        return this;
    }

    public FancyPlayerWidget setFeetWearable(@Nullable String item, class_7225.class_7874 provider) {
        this.player.method_5673(class_1304.field_6166, this.getNullableItem(item, i -> this.parseItem((String)i, provider)));
        return this;
    }

    public FancyPlayerWidget setHeadWearable(@Nullable class_1792 item) {
        this.player.method_5673(class_1304.field_6169, this.getNullableItem(item, class_1792::method_7854));
        return this;
    }

    public FancyPlayerWidget setChestWearable(@Nullable class_1792 item) {
        this.player.method_5673(class_1304.field_6174, this.getNullableItem(item, class_1792::method_7854));
        return this;
    }

    public FancyPlayerWidget setLegsWearable(@Nullable class_1792 item) {
        this.player.method_5673(class_1304.field_6172, this.getNullableItem(item, class_1792::method_7854));
        return this;
    }

    public FancyPlayerWidget setFeetWearable(@Nullable class_1792 item) {
        this.player.method_5673(class_1304.field_6166, this.getNullableItem(item, class_1792::method_7854));
        return this;
    }

    public FancyPlayerWidget setHeadWearable(@Nullable class_1799 item) {
        this.player.method_5673(class_1304.field_6169, this.getNullableItem(item, i -> i));
        return this;
    }

    public FancyPlayerWidget setChestWearable(@Nullable class_1799 item) {
        this.player.method_5673(class_1304.field_6174, this.getNullableItem(item, i -> i));
        return this;
    }

    public FancyPlayerWidget setLegsWearable(@Nullable class_1799 item) {
        this.player.method_5673(class_1304.field_6172, this.getNullableItem(item, i -> i));
        return this;
    }

    public FancyPlayerWidget setFeetWearable(@Nullable class_1799 item) {
        this.player.method_5673(class_1304.field_6166, this.getNullableItem(item, i -> i));
        return this;
    }

    private <T> class_1799 getNullableItem(T item, Function<T, class_1799> getter) {
        return item == null ? class_1799.field_8037 : getter.apply(item);
    }

    private class_1799 parseItem(String item, class_7225.class_7874 provider) {
        try {
            class_2291.class_7215 result = new class_2291(provider).method_9789(new StringReader(item));
            return new class_2290(result.comp_628(), result.comp_2439()).method_9781(1, false);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Error parsing {}", (Object)item, (Object)e);
            return class_1799.field_8037;
        }
    }

    public FancyPlayerWidget copyPlayer(String profileName) {
        return this.copyPlayer(FancyProfileFetcher.fetchProfile(profileName), profileName);
    }

    public FancyPlayerWidget copyPlayer(UUID profileId) {
        return this.copyPlayer(FancyProfileFetcher.fetchProfile(profileId), profileId.toString());
    }

    public FancyPlayerWidget uncopyPlayer() {
        this.player.copyingPlayer = false;
        this.updateSkin(this.properties.skin);
        this.player.name = this.properties.name;
        return this;
    }

    public boolean isCopyingPlayer() {
        return this.player.copyingPlayer;
    }

    private FancyPlayerWidget copyPlayer(CompletableFuture<Optional<GameProfile>> result, String source) {
        ((CompletableFuture)result.exceptionally(FancyPlayerWidget::handlePlayerCopyError)).thenAccept(profile -> profile.ifPresentOrElse(this::copyPlayer, () -> FancyPlayerWidget.handlePlayerCopyError(source)));
        return this;
    }

    private FancyPlayerWidget copyPlayer(GameProfile profile) {
        ((CompletableFuture)class_310.method_1551().method_1582().method_52863(profile).exceptionally(throwable -> FancyPlayerWidget.handlePlayerCopyError(throwable).orElse(null))).thenAccept(skin -> {
            this.player.copyingPlayer = true;
            this.properties.name = this.player.name;
            this.player.name = profile.getName();
            if (skin != null) {
                this.updateSkin((class_8685)skin);
            } else {
                FancyPlayerWidget.handlePlayerCopyError(this.player.name);
            }
        });
        return this;
    }

    private void updateSkin(@Nullable class_8685 skin) {
        if (skin != null) {
            this.player.isSlim = skin.comp_1629() == class_8685.class_7920.field_41122;
            this.player.skin = skin;
        } else {
            this.updateIsSlim(this.properties.isSlim);
        }
        this.renderer = this.player.isSlim ? FancyPlayerRenderer.SLIM_RENDERER : FancyPlayerRenderer.WIDE_RENDERER;
    }

    private void updateIsSlim(boolean isSlim) {
        this.player.isSlim = isSlim;
        this.player.skin = class_1068.field_41121[this.random.nextInt(9) + (isSlim ? 0 : 9)];
    }

    private void updateRenderState(int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
        this.player.boundingBoxWidth = (float)height / 2.9999998f;
        this.player.boundingBoxHeight = height;
        this.player.scale = (float)height / 1.875f;
        if (this.player.bodyFollowsMouse || this.player.headFollowsMouse) {
            float renderHeight = this.player.method_18376() == class_4050.field_18081 ? 1.5f : 1.875f;
            float eyeHeight = this.player.method_18376() == class_4050.field_18081 ? PLAYER_CROUCHING_EYE_HEIGHT : 1.62f;
            float adultEyeY = (renderHeight - eyeHeight) * (float)height / renderHeight;
            float eyeY = (float)y + (this.player.isBaby ? ((float)height + adultEyeY) * 0.5f : adultEyeY);
            float eyeX = (float)x + (float)width / 2.0f;
            double mouseXRelative = (float)mouseX - eyeX;
            double mouseYRelative = (float)mouseY - eyeY;
            double xRot = Math.atan(mouseYRelative / 40.0) * 20.0;
            double yRot = -Math.atan(mouseXRelative / 40.0) * 20.0;
            if (this.player.isUpsideDown) {
                xRot = -xRot;
                yRot = -yRot;
            }
            if (this.player.bodyFollowsMouse) {
                this.player.modelRot.setXDeg(xRot);
                this.player.modelRot.setYDeg(yRot);
                this.player.modelRot.setZ(0.0);
            }
            if (this.player.headFollowsMouse) {
                this.player.headRot.setXDeg(xRot);
                this.player.headRot.setYDeg(yRot);
                this.player.headRot.setZ(0.0);
            }
        }
    }

    private static final class OverridableProperties {
        final Rotation headRot = new Rotation();
        final Rotation bodyRot = new Rotation();
        public boolean bodyFollowsMouse;
        public boolean headFollowsMouse;
        boolean isSlim;
        @NotNull
        String name;
        @Nullable
        class_8685 skin;
        @Nullable
        class_1453.class_7989 parrotOnLeftShoulder;
        @Nullable
        class_1453.class_7989 parrotOnRightShoulder;
        boolean displayFireAnimation;

        private OverridableProperties(@NotNull String name) {
            this.name = name;
        }
    }
}

