/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.analyzer;

import java.util.Optional;
import net.minecraft.world.item.Item;
import org.complexityanalyzer.ComplexityAnalyzer;
import org.complexityanalyzer.analyzer.DepthAnalyzer;
import org.complexityanalyzer.analyzer.RecipeSelector;
import org.complexityanalyzer.analyzer.resource.SourceManager;
import org.complexityanalyzer.analyzer.solver.SolverResult;
import org.complexityanalyzer.cache.ComplexityCache;
import org.complexityanalyzer.core.AnalysisEngine;
import org.complexityanalyzer.data.ItemComplexity;
import org.complexityanalyzer.graph.RecipeGraph;
import org.complexityanalyzer.graph.RecipeNode;

public class ComplexityCalculator {
    private final RecipeGraph graph;
    private final DepthAnalyzer depthAnalyzer;
    private final SolverResult solverResult;
    private final SourceManager sourceManager;
    private final ComplexityCache cache;

    public ComplexityCalculator(RecipeGraph graph, DepthAnalyzer depthAnalyzer, SolverResult solverResult, SourceManager sourceManager) {
        this.graph = graph;
        this.depthAnalyzer = depthAnalyzer;
        this.solverResult = solverResult;
        this.sourceManager = sourceManager;
        this.cache = AnalysisEngine.getInstance().getComplexityCache();
    }

    public Optional<ItemComplexity> getOrCalculateComplexity(Item item) {
        Optional<ItemComplexity> cachedResult = this.cache.get(item);
        if (cachedResult.isPresent()) {
            return cachedResult;
        }
        try {
            ItemComplexity result = this.buildComplexityResult(item);
            this.cache.put(item, result);
            return Optional.of(result);
        }
        catch (Exception e) {
            ComplexityAnalyzer.LOGGER.error("Failed to build complexity result for {}", (Object)item, (Object)e);
            return Optional.empty();
        }
    }

    private ItemComplexity buildComplexityResult(Item item) {
        double complexity = this.solverResult.getComplexity(item).orElseGet(() -> this.sourceManager.getBaseFactor(item));
        RecipeSelector staticSelector = new RecipeSelector(this.graph);
        RecipeNode representativeRecipe = staticSelector.selectStaticBestRecipe(item);
        boolean hasRecipe = this.graph.hasRecipe(item);
        int depth = hasRecipe ? this.depthAnalyzer.getDepth(item) : 0;
        int ingredients = hasRecipe ? representativeRecipe.getTotalIngredientCount() : 0;
        return new ItemComplexity.Builder(item).complexity(complexity).depth(depth).totalIngredients(ingredients).hasRecipe(hasRecipe).build();
    }
}

