/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.analyzer.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.complexityanalyzer.ComplexityAnalyzer;
import org.complexityanalyzer.analyzer.resource.IMultiSourceProvider;
import org.complexityanalyzer.analyzer.resource.IResourceSource;
import org.complexityanalyzer.analyzer.resource.data.BaseResourceData;
import org.complexityanalyzer.analyzer.resource.sources.EmpiricalBlockSource;
import org.complexityanalyzer.analyzer.resource.sources.TheoreticalBlockSource;

public class SourceManager {
    private final List<IResourceSource> sources;
    private final Map<Item, Optional<BaseResourceData>> cache = new ConcurrentHashMap<Item, Optional<BaseResourceData>>();

    public SourceManager(List<IResourceSource> initialSources) {
        this.sources = new ArrayList<IResourceSource>(initialSources);
        this.sortSources();
    }

    public void removeSourcesByType(Class<? extends IResourceSource> type) {
        boolean removed = this.sources.removeIf(type::isInstance);
        if (removed) {
            this.clearCache();
            ComplexityAnalyzer.LOGGER.info("Removed all sources of type {}", (Object)type.getSimpleName());
        }
    }

    private void sortSources() {
        this.sources.sort(Comparator.comparingInt(IResourceSource::getPriority).reversed());
    }

    public void addSourceAndRefresh(IResourceSource newSource) {
        ComplexityAnalyzer.LOGGER.debug("Adding new resource source: {} with priority {}", (Object)newSource.getName(), (Object)newSource.getPriority());
        this.sources.removeIf(s -> s.getClass().equals(newSource.getClass()));
        this.sources.add(newSource);
        this.sortSources();
        this.clearCache();
    }

    public void initialize(Level level) {
        for (IResourceSource source : this.sources) {
            try {
                source.initialize(level);
                ComplexityAnalyzer.LOGGER.debug("Initialized resource source: {}", (Object)source.getName());
            }
            catch (Exception e) {
                ComplexityAnalyzer.LOGGER.error("Failed to initialize source: {}", (Object)source.getName(), (Object)e);
            }
        }
    }

    public double getBaseFactor(Item item) {
        return this.analyze(item).map(BaseResourceData::getBaseFactor).orElse(-1.0);
    }

    public Optional<BaseResourceData> analyze(Item item) {
        return this.cache.computeIfAbsent(item, this::performAnalysis);
    }

    private Optional<BaseResourceData> performAnalysis(Item item) {
        Stream<Object> sourceStream = this.sources.stream();
        boolean empiricalReady = this.getSourceByType(EmpiricalBlockSource.class).map(EmpiricalBlockSource::isReady).orElse(false);
        if (empiricalReady) {
            sourceStream = sourceStream.filter(source -> !(source instanceof TheoreticalBlockSource));
        }
        return sourceStream.filter(source -> source.canProvide(item)).map(source -> source.analyze(item)).flatMap(Optional::stream).min(Comparator.comparingDouble(BaseResourceData::getBaseFactor));
    }

    public List<BaseResourceData> findAllSources(Item item) {
        ArrayList<BaseResourceData> results = new ArrayList<BaseResourceData>();
        for (IResourceSource source : this.sources) {
            if (!source.canProvide(item)) continue;
            if (source instanceof IMultiSourceProvider) {
                IMultiSourceProvider multiSource = (IMultiSourceProvider)((Object)source);
                results.addAll(multiSource.findAllSources(item));
                continue;
            }
            source.analyze(item).ifPresent(results::add);
        }
        return results;
    }

    public void clearCache() {
        this.cache.clear();
        ComplexityAnalyzer.LOGGER.debug("SourceManager cache cleared.");
    }

    public List<IResourceSource> getSources() {
        return Collections.unmodifiableList(this.sources);
    }

    public <T extends IResourceSource> Optional<T> getSourceByType(Class<T> type) {
        return this.sources.stream().filter(type::isInstance).map(type::cast).findFirst();
    }
}

