/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.analyzer.resource.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;

public class OreDistributionData {
    private final Block block;
    private final Set<ResourceKey<Level>> dimensions;
    private final Map<ResourceKey<Biome>, BiomeOccurrence> biomeOccurrences;
    private int minY = Integer.MAX_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private double globalRarity = 0.0;

    public OreDistributionData(Block block) {
        this.block = block;
        this.dimensions = new HashSet<ResourceKey<Level>>();
        this.biomeOccurrences = new HashMap<ResourceKey<Biome>, BiomeOccurrence>();
    }

    public void addDimension(ResourceKey<Level> dimension) {
        this.dimensions.add(dimension);
    }

    public void addBiomeOccurrence(ResourceKey<Biome> biome, int minY, int maxY, double frequency) {
        this.biomeOccurrences.put(biome, new BiomeOccurrence(minY, maxY, frequency));
        this.minY = Math.min(this.minY, minY);
        this.maxY = Math.max(this.maxY, maxY);
        this.updateGlobalRarity();
    }

    private void updateGlobalRarity() {
        if (this.biomeOccurrences.isEmpty()) {
            this.globalRarity = 0.0;
            return;
        }
        double sum = this.biomeOccurrences.values().stream().mapToDouble(BiomeOccurrence::frequency).sum();
        this.globalRarity = sum / (double)this.biomeOccurrences.size();
    }

    public Block getBlock() {
        return this.block;
    }

    public Set<ResourceKey<Level>> getDimensions() {
        return Collections.unmodifiableSet(this.dimensions);
    }

    public int getMinY() {
        return this.minY == Integer.MAX_VALUE ? 0 : this.minY;
    }

    public int getMaxY() {
        return this.maxY == Integer.MIN_VALUE ? 320 : this.maxY;
    }

    public double getGlobalRarity() {
        return this.globalRarity;
    }

    public int getBiomeCount() {
        return this.biomeOccurrences.size();
    }

    public boolean isFoundInDimension(ResourceKey<Level> dimension) {
        return this.dimensions.contains(dimension);
    }

    public record BiomeOccurrence(int minY, int maxY, double frequency) {
    }
}

