/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.analyzer.resource.providers;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import org.complexityanalyzer.ComplexityAnalyzer;
import org.complexityanalyzer.analyzer.resource.data.OreDistributionData;

public class TheoreticalDistributionProvider {
    private final Map<Block, OreDistributionData> distributionData = new ConcurrentHashMap<Block, OreDistributionData>();
    private boolean initialized = false;

    public void initialize(Level level) {
        if (this.initialized) {
            return;
        }
        ComplexityAnalyzer.LOGGER.debug("Initializing TheoreticalDistributionProvider (WorldGen Analysis)...");
        if (!(level instanceof ServerLevel)) {
            ComplexityAnalyzer.LOGGER.warn("Cannot analyze worldgen - not a server level. Theoretical analysis will be unavailable.");
            this.initialized = true;
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        try {
            this.analyzeServerLevel(serverLevel);
        }
        catch (Exception e) {
            ComplexityAnalyzer.LOGGER.error("Error during worldgen analysis", (Throwable)e);
        }
        this.initialized = true;
        ComplexityAnalyzer.LOGGER.info("TheoreticalDistributionProvider initialized: {} blocks found in worldgen config.", (Object)this.distributionData.size());
    }

    private void analyzeServerLevel(ServerLevel level) {
        Registry biomeRegistry = level.registryAccess().registryOrThrow(Registries.BIOME);
        for (Holder.Reference biomeHolder : biomeRegistry.holders().toList()) {
            this.analyzeBiome((ResourceKey<Level>)level.dimension(), (ResourceKey<Biome>)biomeHolder.key(), (Holder<Biome>)biomeHolder);
        }
    }

    private void analyzeBiome(ResourceKey<Level> dimension, ResourceKey<Biome> biomeKey, Holder<Biome> biomeHolder) {
        List generationSteps = ((Biome)biomeHolder.value()).getGenerationSettings().features();
        int oreStepIndex = GenerationStep.Decoration.UNDERGROUND_ORES.ordinal();
        if (oreStepIndex < generationSteps.size()) {
            for (Holder featureHolder : (HolderSet)generationSteps.get(oreStepIndex)) {
                this.analyzePlacedFeature(dimension, biomeKey, (Holder<PlacedFeature>)featureHolder);
            }
        }
    }

    private void analyzePlacedFeature(ResourceKey<Level> dimension, ResourceKey<Biome> biomeKey, Holder<PlacedFeature> featureHolder) {
        PlacedFeature placedFeature = (PlacedFeature)featureHolder.value();
        HeightRange heightRange = this.extractHeightRange(placedFeature.placement());
        int count = this.extractCount(placedFeature.placement());
        Holder configuredFeatureHolder = placedFeature.feature();
        Set<Block> blocks = this.extractBlocks((ConfiguredFeature)configuredFeatureHolder.value());
        if (blocks.isEmpty()) {
            return;
        }
        double frequency = this.calculateFrequency(count);
        for (Block block : blocks) {
            OreDistributionData data = this.distributionData.computeIfAbsent(block, OreDistributionData::new);
            data.addDimension(dimension);
            data.addBiomeOccurrence(biomeKey, heightRange.minY(), heightRange.maxY(), frequency);
        }
    }

    private HeightRange extractHeightRange(List<PlacementModifier> ignoredPlacements) {
        return new HeightRange(-64, 128);
    }

    private int extractCount(List<PlacementModifier> ignoredPlacements) {
        return 4;
    }

    private Set<Block> extractBlocks(ConfiguredFeature<?, ?> feature) {
        Object object;
        HashSet<Block> blocks = new HashSet<Block>();
        if (feature.feature() == Feature.ORE && (object = feature.config()) instanceof OreConfiguration) {
            OreConfiguration oreConfig = (OreConfiguration)object;
            for (OreConfiguration.TargetBlockState target : oreConfig.targetStates) {
                blocks.add(target.state.getBlock());
            }
        }
        return blocks;
    }

    private double calculateFrequency(int count) {
        return Math.min(1.0, (double)count * 0.1);
    }

    public Optional<OreDistributionData> getDistribution(Block block) {
        return Optional.ofNullable(this.distributionData.get(block));
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private record HeightRange(int minY, int maxY) {
    }
}

