/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.analyzer.resource.sources;

import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.complexityanalyzer.ComplexityAnalyzer;
import org.complexityanalyzer.analyzer.resource.IResourceSource;
import org.complexityanalyzer.analyzer.resource.data.BaseResourceData;
import org.complexityanalyzer.analyzer.resource.data.MobDropData;
import org.complexityanalyzer.analyzer.resource.providers.DimensionRarityAnalyzer;
import org.complexityanalyzer.analyzer.resource.providers.MobPropertyProvider;
import org.complexityanalyzer.analyzer.resource.providers.MobRarityCalculator;
import org.complexityanalyzer.config.ComplexityConfig;

public class MobDropSource
implements IResourceSource {
    private final MobPropertyProvider mobProvider;
    private final Map<Item, List<MobDropData>> dropMap = new HashMap<Item, List<MobDropData>>();
    private static final int SIMULATION_COUNT = 500;
    private static final Set<EntityType<?>> SPECIAL_KILL_ENTITIES = Set.of(EntityType.WITHER, EntityType.ENDER_DRAGON, EntityType.SHULKER);

    public MobDropSource(MobPropertyProvider mobProvider, Level level) {
        this.mobProvider = mobProvider;
        DimensionRarityAnalyzer dimensionAnalyzer = new DimensionRarityAnalyzer(level);
        MobRarityCalculator rarityCalculator = new MobRarityCalculator(dimensionAnalyzer);
        mobProvider.setRarityCalculator(rarityCalculator);
    }

    @Override
    public void initialize(Level level) {
        List entityTypes;
        if (!(level instanceof ServerLevel)) {
            ComplexityAnalyzer.LOGGER.error("[MobDropSource] Initialize called with non-server level. Aborting.");
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        MinecraftServer server = serverLevel.getServer();
        try {
            entityTypes = CompletableFuture.supplyAsync(() -> {
                ArrayList types = new ArrayList();
                BuiltInRegistries.ENTITY_TYPE.forEach(types::add);
                return types;
            }, (Executor)server).join();
        }
        catch (Exception e) {
            ComplexityAnalyzer.LOGGER.error("[MobDropSource] Failed to get entity types from server thread. Aborting.", (Throwable)e);
            return;
        }
        this.processMobDrops(serverLevel, entityTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private void processMobDrops(ServerLevel serverLevel, List<EntityType<?>> entityTypes) {
        int processedEntities;
        long startTime;
        block22: {
            List<DamageSourceConfig> damageConfigs;
            Logger rootLogger;
            LootFunctionFilter filter;
            block20: {
                MinecraftServer server = serverLevel.getServer();
                ComplexityAnalyzer.LOGGER.debug("Initializing MobDropSource by simulating mob loot tables...");
                startTime = System.currentTimeMillis();
                processedEntities = 0;
                this.registerSpecialKillDrops();
                filter = new LootFunctionFilter();
                rootLogger = (Logger)LogManager.getRootLogger();
                filter.start();
                rootLogger.addFilter((Filter)filter);
                damageConfigs = null;
                GameProfile fakePlayerProfile222 = new GameProfile(UUID.randomUUID(), "[ComplexityAnalyzer]");
                ServerPlayer fakePlayer = new ServerPlayer(server, serverLevel, fakePlayerProfile222, ClientInformation.createDefault());
                damageConfigs = this.createDamageSources(serverLevel, fakePlayer);
                for (EntityType<?> entityType : entityTypes) {
                    Entity entityInstance;
                    ResourceKey lootTableKey;
                    LootTable lootTable;
                    if (SPECIAL_KILL_ENTITIES.contains(entityType) || (lootTable = CompletableFuture.supplyAsync(() -> MobDropSource.lambda$processMobDrops$1(server, lootTableKey = entityType.getDefaultLootTable()), (Executor)server).join()) == LootTable.EMPTY || entityType.getCategory() == MobCategory.MISC) continue;
                    try {
                        entityInstance = entityType.create((Level)serverLevel);
                    }
                    catch (Exception e) {
                        ComplexityAnalyzer.LOGGER.debug("[MobDropSource] Failed to create entity {} for simulation: {}", (Object)BuiltInRegistries.ENTITY_TYPE.getKey(entityType), (Object)e.getMessage());
                        continue;
                    }
                    if (entityInstance == null) {
                        ComplexityAnalyzer.LOGGER.debug("[MobDropSource] Creating entity {} returned null, skipping.", (Object)BuiltInRegistries.ENTITY_TYPE.getKey(entityType));
                        continue;
                    }
                    HashMap<Item, DropStatistics> combinedDrops = new HashMap<Item, DropStatistics>();
                    for (DamageSourceConfig config : damageConfigs) {
                        if (config.methodName.equals("Skeleton Arrow") && entityType != EntityType.CREEPER) continue;
                        this.simulateKillMethod(serverLevel, entityInstance, lootTable, config, combinedDrops);
                    }
                    for (Map.Entry entry : combinedDrops.entrySet()) {
                        DropStatistics stats = (DropStatistics)entry.getValue();
                        if (stats.totalDropped <= 0) continue;
                        this.dropMap.computeIfAbsent((Item)entry.getKey(), k -> new ArrayList()).add(new MobDropData((Item)entry.getKey(), entityType, stats.getAverageYield(), stats.getBestMethod()));
                    }
                    ++processedEntities;
                    entityInstance.discard();
                }
                if (damageConfigs == null) break block20;
                for (DamageSourceConfig config : damageConfigs) {
                    if (config.attackingEntity == null) continue;
                    config.attackingEntity.discard();
                }
            }
            try {
                rootLogger.get().removeFilter((Filter)filter);
                filter.stop();
            }
            catch (Exception fakePlayerProfile222) {}
            break block22;
            catch (Exception e2222222) {
                block21: {
                    ComplexityAnalyzer.LOGGER.error("[MobDropSource] A critical error occurred during simulation.", (Throwable)e2222222);
                    if (damageConfigs == null) break block21;
                    for (DamageSourceConfig config : damageConfigs) {
                        if (config.attackingEntity == null) continue;
                        config.attackingEntity.discard();
                    }
                }
                try {
                    rootLogger.get().removeFilter((Filter)filter);
                    filter.stop();
                }
                catch (Exception e2222222) {}
                catch (Throwable throwable) {
                    if (damageConfigs != null) {
                        for (DamageSourceConfig config : damageConfigs) {
                            if (config.attackingEntity == null) continue;
                            config.attackingEntity.discard();
                        }
                    }
                    try {
                        rootLogger.get().removeFilter((Filter)filter);
                        filter.stop();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        ComplexityAnalyzer.LOGGER.info("MobDropSource initialized. Processed {} valid entities. Found drop info for {} unique items. Time: {}ms", new Object[]{processedEntities, this.dropMap.size(), duration});
    }

    private List<DamageSourceConfig> createDamageSources(ServerLevel level, ServerPlayer player) {
        ArrayList<DamageSourceConfig> configs = new ArrayList<DamageSourceConfig>();
        configs.add(new DamageSourceConfig("Player Attack", level.damageSources().playerAttack((Player)player), false, player, null));
        configs.add(new DamageSourceConfig("Fire", level.damageSources().onFire(), true, player, null));
        configs.add(new DamageSourceConfig("Lava", level.damageSources().lava(), true, player, null));
        configs.add(new DamageSourceConfig("Magic", level.damageSources().magic(), false, player, null));
        configs.add(new DamageSourceConfig("Fall Damage", level.damageSources().fall(), false, null, null));
        Creeper chargedCreeper = new Creeper(EntityType.CREEPER, (Level)level);
        CompoundTag creeperNBT = new CompoundTag();
        creeperNBT.putBoolean("powered", true);
        chargedCreeper.readAdditionalSaveData(creeperNBT);
        Registry damageTypeRegistry = level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE);
        Holder.Reference explosionHolder = damageTypeRegistry.getHolderOrThrow(DamageTypes.EXPLOSION);
        DamageSource creeperOnlyExplosion = new DamageSource((Holder)explosionHolder, (Entity)chargedCreeper, (Entity)chargedCreeper);
        configs.add(new DamageSourceConfig("Charged Creeper", creeperOnlyExplosion, false, null, (Entity)chargedCreeper));
        Skeleton skeleton = new Skeleton(EntityType.SKELETON, (Level)level);
        Arrow arrow = new Arrow(EntityType.ARROW, (Level)level);
        arrow.setOwner((Entity)skeleton);
        configs.add(new DamageSourceConfig("Skeleton Arrow", level.damageSources().arrow((AbstractArrow)arrow, (Entity)skeleton), false, null, (Entity)skeleton));
        return configs;
    }

    private void simulateKillMethod(ServerLevel level, Entity entityInstance, LootTable lootTable, DamageSourceConfig config, Map<Item, DropStatistics> combinedDrops) {
        for (int i = 0; i < 500; ++i) {
            try {
                LootParams.Builder builder = new LootParams.Builder(level).withParameter(LootContextParams.THIS_ENTITY, (Object)entityInstance).withParameter(LootContextParams.ORIGIN, (Object)entityInstance.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)config.damageSource);
                if (config.killerPlayer != null) {
                    builder.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)config.killerPlayer);
                }
                if (config.attackingEntity != null) {
                    builder.withParameter(LootContextParams.ATTACKING_ENTITY, (Object)config.attackingEntity);
                    if (config.damageSource.getDirectEntity() != null) {
                        builder.withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)config.damageSource.getDirectEntity());
                    } else {
                        builder.withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)config.attackingEntity);
                    }
                }
                if (config.isOnFire) {
                    entityInstance.setRemainingFireTicks(100);
                }
                LootParams lootParams = builder.create(LootContextParamSets.ENTITY);
                ObjectArrayList drops = lootTable.getRandomItems(lootParams);
                if (config.isOnFire) {
                    entityInstance.clearFire();
                }
                for (ItemStack stack : drops) {
                    combinedDrops.computeIfAbsent(stack.getItem(), k -> new DropStatistics()).addDrop(config.methodName, stack.getCount());
                }
                continue;
            }
            catch (Exception e) {
                ComplexityAnalyzer.LOGGER.error("Exception during loot simulation for {} with method {}", new Object[]{entityInstance.getType().getDescriptionId(), config.methodName, e});
            }
        }
    }

    @Override
    public boolean canProvide(Item item) {
        return this.dropMap.containsKey(item);
    }

    @Override
    public Optional<BaseResourceData> analyze(Item item) {
        if (!this.canProvide(item)) {
            return Optional.empty();
        }
        return this.dropMap.get(item).stream().map(dropData -> this.calculateComplexityForDrop(item, (MobDropData)dropData)).filter(Optional::isPresent).map(Optional::get).min(Comparator.comparingDouble(BaseResourceData::getBaseFactor));
    }

    public List<MobDropData> getDropsForEntity(EntityType<?> entityType) {
        ArrayList<MobDropData> results = new ArrayList<MobDropData>();
        for (List<MobDropData> allDrops : this.dropMap.values()) {
            for (MobDropData data : allDrops) {
                if (data.sourceMob() != entityType) continue;
                results.add(data);
            }
        }
        return results;
    }

    private Optional<BaseResourceData> calculateComplexityForDrop(Item item, MobDropData data) {
        EntityType<?> victimMobType = data.sourceMob();
        Optional<MobPropertyProvider.MobProperties> victimPropsOpt = this.mobProvider.getProperties(victimMobType);
        if (victimPropsOpt.isEmpty()) {
            return Optional.empty();
        }
        MobPropertyProvider.MobProperties victimProps = victimPropsOpt.get();
        double victimCombatPower = victimProps.calculateCombatPower();
        double victimRarityMultiplier = this.mobProvider.getRarity(victimMobType);
        double specialConditionCost = 0.0;
        if ("Killed by Charged Creeper".equals(data.killMethod())) {
            Optional<MobPropertyProvider.MobProperties> creeperPropsOpt = this.mobProvider.getProperties(EntityType.CREEPER);
            if (creeperPropsOpt.isPresent()) {
                MobPropertyProvider.MobProperties creeperProps = creeperPropsOpt.get();
                double creeperCombatPower = creeperProps.calculateCombatPower();
                double creeperRarity = this.mobProvider.getRarity(EntityType.CREEPER);
                specialConditionCost = creeperCombatPower * creeperRarity * 200.0;
            } else {
                specialConditionCost = 50000.0;
            }
        }
        double baseKillComplexity = victimCombatPower * victimRarityMultiplier / data.averageYield();
        double finalComplexity = (baseKillComplexity + specialConditionCost) * (Double)ComplexityConfig.MOB_DIFFICULTY_SCALER.get();
        String details = String.format("From %s (Yield: %.2f/kill, Rarity: %.1fx, Method: %s)", victimMobType.getDescription().getString(), data.averageYield(), victimRarityMultiplier, data.killMethod() != null ? data.killMethod() : "Any");
        return Optional.of(new BaseResourceData.Builder(item, this).sourceType(BaseResourceData.ResourceSourceType.MOB_DROP).baseFactor(finalComplexity).details(details).build());
    }

    @Override
    public BaseResourceData.ResourceSourceType getSourceType() {
        return BaseResourceData.ResourceSourceType.MOB_DROP;
    }

    @Override
    public int getPriority() {
        return 20;
    }

    @Override
    public String getName() {
        return "MobDropSource";
    }

    private void registerSpecialKillDrops() {
        ComplexityAnalyzer.LOGGER.info("Registering special kill-based drops...");
        int count = 0;
        this.registerDrop(EntityType.ZOMBIE, Items.ZOMBIE_HEAD, 1.0, "Killed by Charged Creeper");
        ++count;
        this.registerDrop(EntityType.SKELETON, Items.SKELETON_SKULL, 1.0, "Killed by Charged Creeper");
        ++count;
        this.registerDrop(EntityType.CREEPER, Items.CREEPER_HEAD, 1.0, "Killed by Charged Creeper");
        ++count;
        this.registerDrop(EntityType.PIGLIN, Items.PIGLIN_HEAD, 1.0, "Killed by Charged Creeper");
        ++count;
        this.registerDrop(EntityType.WITHER, Items.NETHER_STAR, 1.0, "Boss Kill");
        ++count;
        this.registerDrop(EntityType.ENDER_DRAGON, Items.DRAGON_EGG, 1.0, "Boss Kill");
        ++count;
        this.registerDrop(EntityType.ENDER_DRAGON, Items.DRAGON_HEAD, 1.0, "End Ship Loot");
        ++count;
        this.registerDrop(EntityType.SHULKER, Items.SHULKER_SHELL, 0.5, "End City Mob");
        ++count;
        double MUSIC_DISC_YIELD = 0.08333333333333333;
        this.registerDrop(EntityType.CREEPER, Items.MUSIC_DISC_11, 0.08333333333333333, "Killed by Skeleton");
        ++count;
        this.registerDrop(EntityType.CREEPER, Items.MUSIC_DISC_13, 0.08333333333333333, "Killed by Skeleton");
        ++count;
        this.registerDrop(EntityType.CREEPER, Items.MUSIC_DISC_BLOCKS, 0.08333333333333333, "Killed by Skeleton");
        ++count;
        this.registerDrop(EntityType.CREEPER, Items.MUSIC_DISC_CAT, 0.08333333333333333, "Killed by Skeleton");
        ++count;
        this.registerDrop(EntityType.CREEPER, Items.MUSIC_DISC_CHIRP, 0.08333333333333333, "Killed by Skeleton");
        ++count;
        this.registerDrop(EntityType.CREEPER, Items.MUSIC_DISC_FAR, 0.08333333333333333, "Killed by Skeleton");
        ++count;
        this.registerDrop(EntityType.CREEPER, Items.MUSIC_DISC_MALL, 0.08333333333333333, "Killed by Skeleton");
        ++count;
        this.registerDrop(EntityType.CREEPER, Items.MUSIC_DISC_MELLOHI, 0.08333333333333333, "Killed by Skeleton");
        ++count;
        this.registerDrop(EntityType.CREEPER, Items.MUSIC_DISC_STAL, 0.08333333333333333, "Killed by Skeleton");
        ++count;
        this.registerDrop(EntityType.CREEPER, Items.MUSIC_DISC_STRAD, 0.08333333333333333, "Killed by Skeleton");
        ++count;
        this.registerDrop(EntityType.CREEPER, Items.MUSIC_DISC_WAIT, 0.08333333333333333, "Killed by Skeleton");
        ++count;
        this.registerDrop(EntityType.CREEPER, Items.MUSIC_DISC_WARD, 0.08333333333333333, "Killed by Skeleton");
        ++count;
        this.registerDrop(EntityType.CREEPER, Items.MUSIC_DISC_PIGSTEP, 0.08333333333333333, "Bastion Loot");
        ++count;
        this.registerDrop(EntityType.CREEPER, Items.MUSIC_DISC_OTHERSIDE, 0.08333333333333333, "Dungeon Loot");
        ++count;
        this.registerDrop(EntityType.CREEPER, Items.MUSIC_DISC_5, 0.08333333333333333, "Ancient City Loot");
        ComplexityAnalyzer.LOGGER.info("Registered {} special kill-based drop entries.", (Object)(++count));
    }

    private void registerDrop(EntityType<?> entityType, Item item, double averageYield, String method) {
        MobDropData dropData = new MobDropData(item, entityType, averageYield, method);
        this.dropMap.computeIfAbsent(item, k -> new ArrayList()).add(dropData);
    }

    private static /* synthetic */ LootTable lambda$processMobDrops$1(MinecraftServer server, ResourceKey lootTableKey) {
        return server.reloadableRegistries().getLootTable(lootTableKey);
    }

    private static class LootFunctionFilter
    extends AbstractFilter {
        private LootFunctionFilter() {
        }

        public Filter.Result filter(LogEvent event) {
            String message;
            if (event == null || event.getLevel() != org.apache.logging.log4j.Level.WARN) {
                return Filter.Result.NEUTRAL;
            }
            String loggerName = event.getLoggerName();
            if (loggerName != null && loggerName.startsWith("net.minecraft.world.level.storage.loot.functions.") && (message = event.getMessage().getFormattedMessage()) != null && (message.contains("Couldn't set damage") || message.contains("Couldn't smelt") || message.contains("Couldn't find a compatible enchantment"))) {
                return Filter.Result.DENY;
            }
            return Filter.Result.NEUTRAL;
        }
    }

    private record DamageSourceConfig(String methodName, DamageSource damageSource, boolean isOnFire, ServerPlayer killerPlayer, Entity attackingEntity) {
    }

    private static class DropStatistics {
        private final Map<String, Integer> dropsByMethod = new HashMap<String, Integer>();
        private int totalDropped = 0;

        private DropStatistics() {
        }

        public void addDrop(String method, int count) {
            this.dropsByMethod.merge(method, count, Integer::sum);
            this.totalDropped += count;
        }

        public double getAverageYield() {
            return (double)this.totalDropped / 500.0;
        }

        public String getBestMethod() {
            return this.dropsByMethod.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse("Unknown");
        }
    }
}

