/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.command;

import com.mojang.brigadier.context.CommandContext;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.complexityanalyzer.ComplexityAnalyzer;
import org.complexityanalyzer.analyzer.resource.data.BaseResourceData;
import org.complexityanalyzer.command.util.OutputManager;
import org.complexityanalyzer.core.AnalysisEngine;
import org.complexityanalyzer.data.ComplexityCategory;
import org.complexityanalyzer.data.ItemComplexity;

public class AnalyzeCommand {
    public static int execute(CommandContext<CommandSourceStack> context, ResourceLocation itemId) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        OutputManager output = new OutputManager(source.getServer());
        AnalysisEngine engine = AnalysisEngine.getInstance();
        if (!engine.isReady()) {
            output.sendFailure(source, (Component)Component.literal((String)"\u26a0 Analysis engine is not ready yet!").append((Component)Component.literal((String)("\nCurrent state: " + String.valueOf((Object)engine.getCurrentState()))).withStyle(ChatFormatting.GRAY)));
            return 0;
        }
        Optional itemOpt = BuiltInRegistries.ITEM.getOptional(itemId);
        if (itemOpt.isEmpty()) {
            output.sendFailure(source, (Component)Component.literal((String)"\u274c Item not found: ").append((Component)Component.literal((String)itemId.toString()).withStyle(ChatFormatting.YELLOW)));
            return 0;
        }
        Item item = (Item)itemOpt.get();
        try {
            Optional<ItemComplexity> optimalOpt = engine.getComplexityResult(item);
            if (optimalOpt.isEmpty()) {
                output.sendFailure(source, (Component)Component.literal((String)("\u274c Failed to analyze item: " + String.valueOf(itemId))));
                return 0;
            }
            AnalyzeCommand.displayAnalysis(source, item, optimalOpt.get(), engine, output, itemId);
            return 1;
        }
        catch (Exception e) {
            output.sendFailure(source, (Component)Component.literal((String)("\u26a0 Error analyzing item: " + e.getMessage())));
            ComplexityAnalyzer.LOGGER.error("Error analyzing item {}", (Object)itemId, (Object)e);
            return 0;
        }
    }

    private static void displayAnalysis(CommandSourceStack source, Item item, ItemComplexity optimal, AnalysisEngine engine, OutputManager output, ResourceLocation itemId) {
        String itemName = item.getDescription().getString();
        output.sendInfo(source, (Component)Component.literal((String)"").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY)));
        output.sendInfo(source, (Component)Component.literal((String)"\ud83d\udcca ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)"Complexity Analysis").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})));
        MutableComponent itemComponent = Component.literal((String)"Item: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)itemName).withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD}));
        output.sendInfo(source, (Component)itemComponent);
        output.sendInfo(source, (Component)Component.literal((String)""));
        AnalyzeCommand.displayMainInfo(source, optimal, output);
        AnalyzeCommand.displaySourceInfo(source, item, optimal, engine, output);
        AnalyzeCommand.displayStatus(source, optimal, output, itemId);
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
    }

    private static void displayMainInfo(CommandSourceStack source, ItemComplexity optimal, OutputManager output) {
        ComplexityCategory category = optimal.getCategory();
        double complexity = optimal.getComplexity();
        output.sendInfo(source, (Component)Component.literal((String)"\u2699 ").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)"Complexity").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})));
        String icon = AnalyzeCommand.getCategoryIcon(category);
        MutableComponent categoryComponent = Component.literal((String)"  Category: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(icon + " " + category.getDisplayName())).withStyle(category.getColor()));
        output.sendInfo(source, (Component)categoryComponent);
        ChatFormatting valueColor = AnalyzeCommand.getComplexityColor(complexity);
        MutableComponent valueComponent = Component.literal((String)"  Value: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.format("%.2f", complexity)).withStyle(new ChatFormatting[]{valueColor, ChatFormatting.BOLD}));
        output.sendInfo(source, (Component)valueComponent);
        String progressBar = AnalyzeCommand.getComplexityBar(complexity);
        output.sendInfo(source, (Component)Component.literal((String)("  " + progressBar)).withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)""));
    }

    private static void displaySourceInfo(CommandSourceStack source, Item item, ItemComplexity optimal, AnalysisEngine engine, OutputManager output) {
        output.sendInfo(source, (Component)Component.literal((String)"\ud83d\udce6 ").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)"Source Information").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})));
        if (optimal.hasRecipe()) {
            output.sendInfo(source, (Component)Component.literal((String)"  \u2713 ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)"Has Recipe: ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"Yes").withStyle(ChatFormatting.WHITE)));
            int depth = optimal.getDepth();
            ChatFormatting depthColor = depth <= 2 ? ChatFormatting.GREEN : (depth <= 4 ? ChatFormatting.YELLOW : ChatFormatting.RED);
            output.sendInfo(source, (Component)Component.literal((String)"    Crafting Depth: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(depth)).withStyle(depthColor)));
            int usageCount = engine.getUsageCount(item);
            output.sendInfo(source, (Component)Component.literal((String)"    Used in Recipes: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(usageCount)).withStyle(ChatFormatting.AQUA)));
        } else {
            output.sendInfo(source, (Component)Component.literal((String)"  \u26cf ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)"Base Resource ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"(No crafting recipe)").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC})));
        }
        List<BaseResourceData> allSources = engine.findAllSourcesForItem(item);
        if (!allSources.isEmpty()) {
            output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udd0d Alternative Sources:").withStyle(ChatFormatting.YELLOW));
            allSources.stream().map(data -> {
                double fullEstimatedCost = data.getBaseFactor();
                if (!data.getSourceItems().isEmpty()) {
                    for (Map.Entry<Item, Double> entry : data.getSourceItems().entrySet()) {
                        Item sourceItem = entry.getKey();
                        double amount = entry.getValue();
                        Optional<ItemComplexity> sourceComplexity = engine.getComplexityResult(sourceItem);
                        if (sourceComplexity.isPresent() && sourceComplexity.get().isValid()) {
                            fullEstimatedCost += sourceComplexity.get().getComplexity() * amount;
                            continue;
                        }
                        fullEstimatedCost = Double.POSITIVE_INFINITY;
                        break;
                    }
                }
                return new SourceWithCost((BaseResourceData)data, fullEstimatedCost);
            }).sorted(Comparator.comparingDouble(SourceWithCost::fullCost)).forEach(swc -> {
                String costString;
                String icon = AnalyzeCommand.getSourceIcon(swc.data().getSourceType());
                String string = costString = Double.isInfinite(swc.fullCost()) ? "\u221e" : String.format("%.2f", swc.fullCost());
                ChatFormatting costColor = Double.isInfinite(swc.fullCost()) ? ChatFormatting.RED : (swc.fullCost() < 10.0 ? ChatFormatting.GREEN : (swc.fullCost() < 50.0 ? ChatFormatting.YELLOW : ChatFormatting.RED));
                MutableComponent sourceComponent = Component.literal((String)("    " + icon + " ")).withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)swc.data().getSourceType().getDisplayName()).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" (Cost: ").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)costString).withStyle(new ChatFormatting[]{costColor, ChatFormatting.BOLD})).append((Component)Component.literal((String)")").withStyle(ChatFormatting.DARK_GRAY));
                output.sendInfo(source, (Component)sourceComponent);
                output.sendInfo(source, (Component)Component.literal((String)("      \u2192 " + swc.data().getDetails())).withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
            });
        }
        output.sendInfo(source, (Component)Component.literal((String)""));
    }

    private static void displayStatus(CommandSourceStack source, ItemComplexity optimal, OutputManager output, ResourceLocation itemId) {
        output.sendInfo(source, (Component)Component.literal((String)"\u2139 ").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)"Status").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD})));
        boolean isValid = optimal.isValid();
        output.sendInfo(source, (Component)Component.literal((String)"  Valid: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(isValid ? "\u2713 Yes" : "\u2717 No")).withStyle(isValid ? ChatFormatting.GREEN : ChatFormatting.RED)));
        if (optimal.hasCycle()) {
            output.sendInfo(source, (Component)Component.literal((String)"  \u26a0 Warning: ").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}).append((Component)Component.literal((String)"Cyclic dependency detected!").withStyle(ChatFormatting.RED)));
        }
        if (optimal.getErrorMessage() != null) {
            output.sendInfo(source, (Component)Component.literal((String)"  \u274c Error: ").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}).append((Component)Component.literal((String)optimal.getErrorMessage()).withStyle(ChatFormatting.RED)));
        }
        if (optimal.hasRecipe()) {
            output.sendInfo(source, (Component)Component.literal((String)""));
            String treeCommand = "/complexity tree " + String.valueOf(itemId);
            MutableComponent tipComponent = Component.literal((String)"\ud83d\udca1 Tip: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"Click here").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.UNDERLINE}).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, treeCommand)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to view crafting tree").withStyle(ChatFormatting.GREEN))))).append((Component)Component.literal((String)" to see full crafting tree").withStyle(ChatFormatting.GRAY));
            output.sendInfo(source, (Component)tipComponent);
        }
    }

    private static String getCategoryIcon(ComplexityCategory category) {
        return switch (category.name()) {
            case "TRIVIAL" -> "\u2b1c";
            case "SIMPLE" -> "\ud83d\udfe9";
            case "MODERATE" -> "\ud83d\udfe8";
            case "COMPLEX" -> "\ud83d\udfe7";
            case "DIFFICULT" -> "\ud83d\udfe5";
            case "EXPERT" -> "\ud83d\udfea";
            case "MASTER" -> "\u2b50";
            case "MYTHICAL" -> "\ud83d\udc8e";
            case "TRANSCENDENT" -> "\ud83d\udc51";
            case "ETERNAL" -> "\ud83d\udd25";
            default -> "\u2753";
        };
    }

    private static ChatFormatting getComplexityColor(double complexity) {
        if (complexity < 10.0) {
            return ChatFormatting.GREEN;
        }
        if (complexity < 30.0) {
            return ChatFormatting.YELLOW;
        }
        if (complexity < 50.0) {
            return ChatFormatting.GOLD;
        }
        if (complexity < 100.0) {
            return ChatFormatting.RED;
        }
        return ChatFormatting.DARK_RED;
    }

    private static String getComplexityBar(double complexity) {
        int bars = Math.min(10, (int)(complexity / 10.0));
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < 10; ++i) {
            if (i < bars) {
                sb.append("\u2588");
                continue;
            }
            sb.append("\u2591");
        }
        sb.append("]");
        return sb.toString();
    }

    private static String getSourceIcon(BaseResourceData.ResourceSourceType sourceType) {
        return switch (sourceType.name()) {
            case "MOB_DROP" -> "\u2694";
            case "CHEST_LOOT" -> "\ud83d\udce6";
            case "FISHING" -> "\ud83c\udfa3";
            case "MINING" -> "\u26cf";
            case "TRADING" -> "\ud83d\udcb0";
            default -> "\u2022";
        };
    }

    private record SourceWithCost(BaseResourceData data, double fullCost) {
    }
}

