/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import org.complexityanalyzer.command.util.OutputManager;
import org.complexityanalyzer.core.AnalysisEngine;
import org.complexityanalyzer.geoscan.GeoAnalysisManager;

public class ChunkCommands {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"geoscan").then(((LiteralArgumentBuilder)Commands.literal((String)"start").executes(ctx -> ChunkCommands.executeScan((CommandContext<CommandSourceStack>)ctx, 32, "lite", false))).then(((RequiredArgumentBuilder)Commands.argument((String)"chunks", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> ChunkCommands.executeScan((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"chunks"), "lite", false))).then(((RequiredArgumentBuilder)Commands.argument((String)"profile", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.suggest((String[])new String[]{"lite", "fast", "extreme", "atomic"}, (SuggestionsBuilder)b)).executes(ctx -> ChunkCommands.executeScan((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"chunks"), StringArgumentType.getString((CommandContext)ctx, (String)"profile"), false))).then(Commands.argument((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> ChunkCommands.executeScan((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"chunks"), StringArgumentType.getString((CommandContext)ctx, (String)"profile"), BoolArgumentType.getBool((CommandContext)ctx, (String)"force")))))))).then(Commands.literal((String)"stop").executes(ChunkCommands::executeStop))).then(Commands.literal((String)"status").executes(ChunkCommands::executeStatus))).then(Commands.literal((String)"clear").executes(ChunkCommands::executeClear));
    }

    private static int executeScan(CommandContext<CommandSourceStack> context, int chunks, String profileName, boolean force) {
        GeoAnalysisManager.ScanProfile profile;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        OutputManager output = new OutputManager(source.getServer());
        try {
            profile = GeoAnalysisManager.ScanProfile.valueOf(profileName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            output.sendFailure(source, (Component)Component.literal((String)"\u274c Unknown scan profile: ").append((Component)Component.literal((String)profileName).withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})));
            output.sendInfo(source, (Component)Component.literal((String)"Available profiles:").withStyle(ChatFormatting.GRAY));
            output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udfe2 lite").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)" - Low impact, slower").withStyle(ChatFormatting.DARK_GRAY)));
            output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udfe1 fast").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)" - Balanced performance").withStyle(ChatFormatting.DARK_GRAY)));
            output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udfe0 extreme").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)" - High performance, may cause lag").withStyle(ChatFormatting.DARK_GRAY)));
            output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udd34 atomic").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}).append((Component)Component.literal((String)" - MAXIMUM SPEED, EXPECT HEAVY LAG!").withStyle(ChatFormatting.DARK_RED)));
            return 0;
        }
        AnalysisEngine.getInstance().getGeoManager().ifPresentOrElse(manager -> {
            if (manager.isScanning() || manager.isCountdownActive()) {
                output.sendFailure(source, (Component)Component.literal((String)"\u26a0 A scan is already in progress!").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
                output.sendInfo(source, (Component)Component.literal((String)"Use ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"/complexity geoscan stop").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)" to cancel it first").withStyle(ChatFormatting.GRAY)));
                return;
            }
            String initiatorName = source.getTextName();
            String profileIcon = ChunkCommands.getProfileIcon(profile);
            ChatFormatting profileColor = ChunkCommands.getProfileColor(profile);
            if (force) {
                output.sendInfo(source, (Component)Component.literal((String)""));
                output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD}));
                output.sendInfo(source, (Component)Component.literal((String)"\u26a1 FORCE STARTING GEO-SCAN").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
                output.sendInfo(source, (Component)Component.literal((String)""));
                output.sendInfo(source, (Component)Component.literal((String)("  Profile: " + profileIcon + " ")).withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)profileName.toUpperCase()).withStyle(new ChatFormatting[]{profileColor, ChatFormatting.BOLD})));
                output.sendInfo(source, (Component)Component.literal((String)"  Chunks: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(chunks)).withStyle(ChatFormatting.YELLOW)));
                output.sendInfo(source, (Component)Component.literal((String)"  Initiator: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)initiatorName).withStyle(ChatFormatting.WHITE)));
                output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD}));
                output.sendInfo(source, (Component)Component.literal((String)""));
                if (profile == GeoAnalysisManager.ScanProfile.EXTREME || profile == GeoAnalysisManager.ScanProfile.ATOMIC) {
                    output.broadcastSever((Component)Component.literal((String)"\u26a0\u26a0\u26a0 GEO-SCAN FORCE STARTED \u26a0\u26a0\u26a0"));
                    output.broadcastSever((Component)Component.literal((String)("EXPECT SEVERE LAG! Profile: " + profileName.toUpperCase())));
                } else {
                    output.broadcastWarning((Component)Component.literal((String)"\u26a1 Geo-scan started. Possible lag!"));
                }
                output.sendToAdmins((Component)Component.literal((String)("Force geo-scan initiated by " + initiatorName)).append((Component)Component.literal((String)(" | Chunks: " + chunks + " | Profile: " + profileName))));
                manager.startScanImmediately(chunks, initiatorName, profile);
            } else {
                output.sendInfo(source, (Component)Component.literal((String)""));
                output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
                output.sendInfo(source, (Component)Component.literal((String)"\ud83d\udcca GEO-SCAN SCHEDULED").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}));
                output.sendInfo(source, (Component)Component.literal((String)""));
                output.sendInfo(source, (Component)Component.literal((String)("  Profile: " + profileIcon + " ")).withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)profileName.toUpperCase()).withStyle(profileColor)));
                output.sendInfo(source, (Component)Component.literal((String)"  Chunks: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(chunks)).withStyle(ChatFormatting.AQUA)));
                output.sendInfo(source, (Component)Component.literal((String)"  Status: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"\u23f3 Countdown initiated").withStyle(ChatFormatting.YELLOW)));
                output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
                output.sendInfo(source, (Component)Component.literal((String)""));
                if (profile == GeoAnalysisManager.ScanProfile.EXTREME || profile == GeoAnalysisManager.ScanProfile.ATOMIC) {
                    output.broadcastWarning((Component)Component.literal((String)"\u26a0 Geo-scan scheduled! Lag expected in 10 seconds..."));
                } else {
                    output.broadcast((Component)Component.literal((String)"\ud83d\udcca Geo-scan starting soon..."));
                }
                output.sendToAdmins((Component)Component.literal((String)("Geo-scan scheduled by " + initiatorName)).append((Component)Component.literal((String)(" | " + chunks + " chunks | " + profileName))));
                manager.scheduleScan(chunks, initiatorName, profile);
            }
        }, () -> {
            output.sendFailure(source, (Component)Component.literal((String)"\u274c GeoAnalysisManager is not initialized!").withStyle(ChatFormatting.RED));
            output.sendInfo(source, (Component)Component.literal((String)"This feature may be disabled in the config.").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        });
        return 1;
    }

    private static int executeStop(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        OutputManager output = new OutputManager(source.getServer());
        AnalysisEngine.getInstance().getGeoManager().ifPresentOrElse(manager -> {
            output.sendInfo(source, (Component)Component.literal((String)"\ud83d\uded1 Stopping geo-scan...").withStyle(ChatFormatting.YELLOW));
            manager.stopScan(source);
            output.broadcast((Component)Component.literal((String)"\u2713 Geo-scan stopped by admin").withStyle(ChatFormatting.GREEN));
            output.sendToAdmins((Component)Component.literal((String)("Scan stopped by " + source.getTextName())));
        }, () -> output.sendFailure(source, (Component)Component.literal((String)"\u274c GeoAnalysisManager is not initialized.")));
        return 1;
    }

    private static int executeStatus(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        OutputManager output = new OutputManager(source.getServer());
        AnalysisEngine.getInstance().getGeoManager().ifPresentOrElse(manager -> {
            String status = manager.getStatus();
            output.sendInfo(source, (Component)Component.literal((String)""));
            output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
            output.sendInfo(source, (Component)Component.literal((String)"\ud83d\udcca GEO-SCAN STATUS").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}));
            output.sendInfo(source, (Component)Component.literal((String)""));
            if (status.contains("IDLE") || status.contains("idle")) {
                output.sendInfo(source, (Component)Component.literal((String)"  Status: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"\ud83d\udca4 IDLE").withStyle(ChatFormatting.GREEN)));
                output.sendInfo(source, (Component)Component.literal((String)"  No active scans").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
            } else if (status.contains("SCANNING") || status.contains("scanning")) {
                output.sendInfo(source, (Component)Component.literal((String)"  Status: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"\u2699 SCANNING").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})));
                try {
                    if (status.contains("%")) {
                        String percent = status.substring(status.indexOf("(") + 1, status.indexOf("%"));
                        int percentValue = Integer.parseInt(percent.trim());
                        String progressBar = ChunkCommands.getProgressBar(percentValue);
                        output.sendInfo(source, (Component)Component.literal((String)"  Progress: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(percent + "%")).withStyle(ChatFormatting.AQUA)));
                        output.sendInfo(source, (Component)Component.literal((String)("  " + progressBar)).withStyle(ChatFormatting.DARK_GRAY));
                    }
                }
                catch (Exception e) {
                    output.sendInfo(source, (Component)Component.literal((String)("  " + status)).withStyle(ChatFormatting.WHITE));
                }
            } else if (status.contains("COUNTDOWN")) {
                output.sendInfo(source, (Component)Component.literal((String)"  Status: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"\u23f3 COUNTDOWN").withStyle(ChatFormatting.GOLD)));
                output.sendInfo(source, (Component)Component.literal((String)"  Starting soon...").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC}));
            } else {
                output.sendInfo(source, (Component)Component.literal((String)"  Status: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)status).withStyle(ChatFormatting.WHITE)));
            }
            output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
            output.sendInfo(source, (Component)Component.literal((String)""));
        }, () -> output.sendFailure(source, (Component)Component.literal((String)"\u274c GeoAnalysisManager is not initialized.")));
        return 1;
    }

    private static int executeClear(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        OutputManager output = new OutputManager(source.getServer());
        AnalysisEngine engine = AnalysisEngine.getInstance();
        engine.getGeoManager().ifPresentOrElse(manager -> {
            if (manager.isScanning() || manager.isCountdownActive()) {
                output.sendFailure(source, (Component)Component.literal((String)"\u26a0 Cannot clear database during active scan!").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
                output.sendInfo(source, (Component)Component.literal((String)"Use ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"/complexity geoscan stop").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)" first").withStyle(ChatFormatting.GRAY)));
            } else {
                output.sendInfo(source, (Component)Component.literal((String)"\ud83d\uddd1 Clearing geo-database...").withStyle(ChatFormatting.YELLOW));
                engine.clearGeoDatabase();
                output.sendSuccess(source, (Component)Component.literal((String)"\u2713 Geo-database has been cleared!").withStyle(ChatFormatting.GREEN));
                output.sendToAdmins((Component)Component.literal((String)("Geo-database cleared by " + source.getTextName())));
            }
        }, () -> {
            output.sendInfo(source, (Component)Component.literal((String)"\ud83d\uddd1 Clearing geo-database...").withStyle(ChatFormatting.YELLOW));
            engine.clearGeoDatabase();
            output.sendSuccess(source, (Component)Component.literal((String)"\u2713 Geo-database has been cleared!").withStyle(ChatFormatting.GREEN));
        });
        return 1;
    }

    private static String getProfileIcon(GeoAnalysisManager.ScanProfile profile) {
        return switch (profile) {
            default -> throw new MatchException(null, null);
            case GeoAnalysisManager.ScanProfile.LITE -> "\ud83d\udfe2";
            case GeoAnalysisManager.ScanProfile.FAST -> "\ud83d\udfe1";
            case GeoAnalysisManager.ScanProfile.EXTREME -> "\ud83d\udfe0";
            case GeoAnalysisManager.ScanProfile.ATOMIC -> "\ud83d\udd34";
        };
    }

    private static ChatFormatting getProfileColor(GeoAnalysisManager.ScanProfile profile) {
        return switch (profile) {
            default -> throw new MatchException(null, null);
            case GeoAnalysisManager.ScanProfile.LITE -> ChatFormatting.GREEN;
            case GeoAnalysisManager.ScanProfile.FAST -> ChatFormatting.YELLOW;
            case GeoAnalysisManager.ScanProfile.EXTREME -> ChatFormatting.GOLD;
            case GeoAnalysisManager.ScanProfile.ATOMIC -> ChatFormatting.RED;
        };
    }

    private static String getProgressBar(int percent) {
        int filled = percent / 10;
        StringBuilder bar = new StringBuilder("[");
        for (int i = 0; i < 10; ++i) {
            if (i < filled) {
                bar.append("\u2588");
                continue;
            }
            bar.append("\u2591");
        }
        bar.append("] ");
        bar.append(percent).append("%");
        return bar.toString();
    }
}

