/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.command;

import com.mojang.brigadier.context.CommandContext;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import org.complexityanalyzer.analyzer.resource.data.MobDropData;
import org.complexityanalyzer.analyzer.resource.providers.MobPropertyProvider;
import org.complexityanalyzer.analyzer.resource.sources.MobDropSource;
import org.complexityanalyzer.command.util.OutputManager;
import org.complexityanalyzer.core.AnalysisEngine;

public class EntityAnalyzeCommand {
    public static int execute(CommandContext<CommandSourceStack> context, ResourceLocation entityId) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        OutputManager output = new OutputManager(source.getServer());
        AnalysisEngine engine = AnalysisEngine.getInstance();
        if (!engine.isReady()) {
            output.sendFailure(source, (Component)Component.literal((String)"\u26a0 Analysis engine is not ready yet!").withStyle(ChatFormatting.RED));
            return 0;
        }
        Optional entityTypeOpt = BuiltInRegistries.ENTITY_TYPE.getOptional(entityId);
        if (entityTypeOpt.isEmpty()) {
            output.sendFailure(source, (Component)Component.literal((String)"\u274c Entity type not found: ").append((Component)Component.literal((String)entityId.toString()).withStyle(ChatFormatting.YELLOW)));
            return 0;
        }
        EntityType entityType = (EntityType)entityTypeOpt.get();
        Optional<MobPropertyProvider> mobProviderOpt = engine.getMobPropertyProvider();
        Optional<MobDropSource> mobDropSourceOpt = engine.getMobDropSource();
        if (mobProviderOpt.isEmpty()) {
            output.sendFailure(source, (Component)Component.literal((String)"\u26a0 MobPropertyProvider is not initialized!").withStyle(ChatFormatting.RED));
            return 0;
        }
        MobPropertyProvider mobProvider = mobProviderOpt.get();
        Optional<MobPropertyProvider.MobProperties> propsOpt = mobProvider.getProperties(entityType);
        if (propsOpt.isEmpty()) {
            output.sendFailure(source, (Component)Component.literal((String)"\u26a0 This entity cannot be analyzed").withStyle(ChatFormatting.RED));
            output.sendInfo(source, (Component)Component.literal((String)("Entity might not be a living creature: " + String.valueOf(entityId))).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            return 0;
        }
        List<MobDropData> drops = mobDropSourceOpt.map(mds -> mds.getDropsForEntity(entityType)).orElse(List.of());
        EntityAnalyzeCommand.displayAnalysis(source, entityType, propsOpt.get(), drops, mobProvider, output);
        return 1;
    }

    private static void displayAnalysis(CommandSourceStack source, EntityType<?> type, MobPropertyProvider.MobProperties props, List<MobDropData> drops, MobPropertyProvider mobProvider, OutputManager output) {
        String entityName = type.getDescription().getString();
        double survivability = props.calculateSurvivability();
        double threat = props.calculateThreat();
        double combatPower = props.calculateCombatPower();
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        String mobIcon = EntityAnalyzeCommand.getMobIcon(type, props, mobProvider);
        output.sendInfo(source, (Component)Component.literal((String)(mobIcon + " ")).withStyle(ChatFormatting.RED).append((Component)Component.literal((String)"Mob Analysis").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)""));
        MutableComponent nameComponent = Component.literal((String)"Entity: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)entityName).withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD}));
        if (mobProvider.isBoss(type)) {
            nameComponent.append((Component)Component.literal((String)" \ud83d\udc51").withStyle(ChatFormatting.GOLD));
        } else if (mobProvider.isMiniBoss(type)) {
            nameComponent.append((Component)Component.literal((String)" \u2b50").withStyle(ChatFormatting.YELLOW));
        }
        output.sendInfo(source, (Component)nameComponent);
        ChatFormatting categoryColor = EntityAnalyzeCommand.getCategoryColor(props.classification().getName());
        output.sendInfo(source, (Component)Component.literal((String)"Category: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)props.classification().getName()).withStyle(new ChatFormatting[]{categoryColor, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)""));
        EntityAnalyzeCommand.displayBaseStats(source, props, output);
        EntityAnalyzeCommand.displayCalculatedFactors(source, survivability, threat, combatPower, output);
        EntityAnalyzeCommand.displayDifficultyRating(source, type, combatPower, mobProvider, output);
        EntityAnalyzeCommand.displayDrops(source, drops, output);
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
    }

    private static void displayBaseStats(CommandSourceStack source, MobPropertyProvider.MobProperties props, OutputManager output) {
        output.sendInfo(source, (Component)Component.literal((String)"\u2764 ").withStyle(ChatFormatting.RED).append((Component)Component.literal((String)"Base Stats").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})));
        double health = props.maxHealth();
        ChatFormatting healthColor = EntityAnalyzeCommand.getHealthColor(health);
        String healthBar = EntityAnalyzeCommand.getStatBar(health, 100.0);
        output.sendInfo(source, (Component)Component.literal((String)"  \u2764 Max Health: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.format("%.1f", health)).withStyle(new ChatFormatting[]{healthColor, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)("    " + healthBar)).withStyle(ChatFormatting.DARK_GRAY));
        double attack = props.attackDamage();
        ChatFormatting attackColor = EntityAnalyzeCommand.getAttackColor(attack);
        String attackBar = EntityAnalyzeCommand.getStatBar(attack, 20.0);
        output.sendInfo(source, (Component)Component.literal((String)"  \u2694 Attack Damage: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.format("%.1f", attack)).withStyle(new ChatFormatting[]{attackColor, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)("    " + attackBar)).withStyle(ChatFormatting.DARK_GRAY));
        double armor = props.armor();
        ChatFormatting armorColor = EntityAnalyzeCommand.getArmorColor(armor);
        String armorBar = EntityAnalyzeCommand.getStatBar(armor, 20.0);
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udee1 Armor: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.format("%.1f", armor)).withStyle(new ChatFormatting[]{armorColor, ChatFormatting.BOLD})));
        if (armor > 0.0) {
            output.sendInfo(source, (Component)Component.literal((String)("    " + armorBar)).withStyle(ChatFormatting.DARK_GRAY));
        }
        output.sendInfo(source, (Component)Component.literal((String)""));
    }

    private static void displayCalculatedFactors(CommandSourceStack source, double survivability, double threat, double combatPower, OutputManager output) {
        output.sendInfo(source, (Component)Component.literal((String)"\u26a1 ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)"Combat Analysis").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})));
        ChatFormatting survColor = EntityAnalyzeCommand.getFactorColor(survivability, 50.0);
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udee1 Survivability: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.format("%.2f", survivability)).withStyle(survColor)));
        ChatFormatting threatColor = EntityAnalyzeCommand.getFactorColor(threat, 5.0);
        output.sendInfo(source, (Component)Component.literal((String)"  \u26a0 Threat Level: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.format("%.2f", threat)).withStyle(threatColor)));
        ChatFormatting powerColor = EntityAnalyzeCommand.getCombatPowerColor(combatPower);
        output.sendInfo(source, (Component)Component.literal((String)"  \u2694 Combat Power: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.format("%.2f", combatPower)).withStyle(new ChatFormatting[]{powerColor, ChatFormatting.BOLD})));
        String powerBar = EntityAnalyzeCommand.getStatBar(combatPower, 200.0);
        output.sendInfo(source, (Component)Component.literal((String)("    " + powerBar)).withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)""));
    }

    private static void displayDifficultyRating(CommandSourceStack source, EntityType<?> type, double combatPower, MobPropertyProvider mobProvider, OutputManager output) {
        ChatFormatting difficultyColor;
        String difficultyIcon;
        String difficulty;
        if (mobProvider.isBoss(type)) {
            difficulty = "BOSS";
            difficultyIcon = "\ud83d\udc51";
            difficultyColor = ChatFormatting.DARK_PURPLE;
        } else if (mobProvider.isMiniBoss(type)) {
            difficulty = "MINI-BOSS";
            difficultyIcon = "\u2b50";
            difficultyColor = ChatFormatting.LIGHT_PURPLE;
        } else if (combatPower > 500.0) {
            difficulty = "EXTREME";
            difficultyIcon = "\ud83d\udc80";
            difficultyColor = ChatFormatting.DARK_RED;
        } else if (combatPower > 200.0) {
            difficulty = "HARD";
            difficultyIcon = "\ud83d\udd25";
            difficultyColor = ChatFormatting.RED;
        } else if (combatPower > 100.0) {
            difficulty = "MEDIUM";
            difficultyIcon = "\u26a0";
            difficultyColor = ChatFormatting.GOLD;
        } else if (combatPower > 50.0) {
            difficulty = "EASY";
            difficultyIcon = "\u2713";
            difficultyColor = ChatFormatting.YELLOW;
        } else {
            difficulty = "TRIVIAL";
            difficultyIcon = "\u25c6";
            difficultyColor = ChatFormatting.GREEN;
        }
        output.sendInfo(source, (Component)Component.literal((String)"\ud83d\udcca Difficulty Rating: ").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)(difficultyIcon + " " + difficulty)).withStyle(new ChatFormatting[]{difficultyColor, ChatFormatting.BOLD})));
        String recommendation = switch (difficulty) {
            case "BOSS" -> "Prepare thoroughly! Boss encounter.";
            case "MINI-BOSS" -> "Elite enemy! Strong gear recommended.";
            case "EXTREME" -> "Extreme danger! Full gear recommended.";
            case "HARD" -> "Dangerous! Good equipment needed.";
            case "MEDIUM" -> "Moderate threat. Stay cautious.";
            case "EASY" -> "Manageable with basic gear.";
            default -> "Low threat. Safe for beginners.";
        };
        output.sendInfo(source, (Component)Component.literal((String)("  \ud83d\udca1 " + recommendation)).withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        output.sendInfo(source, (Component)Component.literal((String)""));
    }

    private static void displayDrops(CommandSourceStack source, List<MobDropData> drops, OutputManager output) {
        output.sendInfo(source, (Component)Component.literal((String)"\ud83d\udc8e ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)"Notable Drops").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})));
        if (drops.isEmpty()) {
            output.sendInfo(source, (Component)Component.literal((String)"  No significant drops recorded").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        } else {
            drops.sort(Comparator.comparingDouble(MobDropData::averageYield).reversed());
            for (MobDropData drop : drops) {
                String itemName = drop.item().getDescription().getString();
                double yield = drop.averageYield();
                String rarityIcon = EntityAnalyzeCommand.getRarityIcon(yield);
                ChatFormatting rarityColor = EntityAnalyzeCommand.getRarityColor(yield);
                MutableComponent dropComponent = Component.literal((String)("  " + rarityIcon + " ")).withStyle(rarityColor).append((Component)Component.literal((String)itemName).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)": ").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)String.format("~%.2f", yield)).withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)" per kill").withStyle(ChatFormatting.GRAY));
                output.sendInfo(source, (Component)dropComponent);
            }
            output.sendInfo(source, (Component)Component.literal((String)""));
            output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udca1 Tip: Higher yield = more common drop").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        }
    }

    private static String getMobIcon(EntityType<?> type, MobPropertyProvider.MobProperties props, MobPropertyProvider mobProvider) {
        String category;
        if (mobProvider.isBoss(type)) {
            return "\ud83d\udc51";
        }
        if (mobProvider.isMiniBoss(type)) {
            return "\u2b50";
        }
        return switch (category = props.classification().getName().toLowerCase()) {
            case "monster", "hostile" -> "\u2694";
            case "creature", "passive" -> "\ud83d\udc3e";
            case "ambient" -> "\ud83e\udd8b";
            case "water_creature" -> "\ud83d\udc1f";
            default -> "\ud83d\udc7e";
        };
    }

    private static ChatFormatting getCategoryColor(String category) {
        return switch (category.toLowerCase()) {
            case "monster", "hostile" -> ChatFormatting.RED;
            case "creature", "passive" -> ChatFormatting.GREEN;
            case "ambient" -> ChatFormatting.AQUA;
            case "water_creature" -> ChatFormatting.BLUE;
            default -> ChatFormatting.WHITE;
        };
    }

    private static ChatFormatting getHealthColor(double health) {
        if (health >= 100.0) {
            return ChatFormatting.DARK_RED;
        }
        if (health >= 50.0) {
            return ChatFormatting.RED;
        }
        if (health >= 20.0) {
            return ChatFormatting.GOLD;
        }
        return ChatFormatting.GREEN;
    }

    private static ChatFormatting getAttackColor(double attack) {
        if (attack >= 20.0) {
            return ChatFormatting.DARK_RED;
        }
        if (attack >= 10.0) {
            return ChatFormatting.RED;
        }
        if (attack >= 5.0) {
            return ChatFormatting.GOLD;
        }
        return ChatFormatting.YELLOW;
    }

    private static ChatFormatting getArmorColor(double armor) {
        if (armor >= 15.0) {
            return ChatFormatting.DARK_AQUA;
        }
        if (armor >= 10.0) {
            return ChatFormatting.AQUA;
        }
        if (armor >= 5.0) {
            return ChatFormatting.BLUE;
        }
        return ChatFormatting.GRAY;
    }

    private static ChatFormatting getFactorColor(double value, double threshold) {
        if (value >= threshold * 2.0) {
            return ChatFormatting.DARK_RED;
        }
        if (value >= threshold) {
            return ChatFormatting.RED;
        }
        if (value >= threshold / 2.0) {
            return ChatFormatting.GOLD;
        }
        return ChatFormatting.YELLOW;
    }

    private static ChatFormatting getCombatPowerColor(double power) {
        if (power >= 500.0) {
            return ChatFormatting.DARK_RED;
        }
        if (power >= 200.0) {
            return ChatFormatting.RED;
        }
        if (power >= 100.0) {
            return ChatFormatting.GOLD;
        }
        if (power >= 50.0) {
            return ChatFormatting.YELLOW;
        }
        return ChatFormatting.GREEN;
    }

    private static String getStatBar(double value, double max) {
        int percent = (int)Math.min(100.0, value / max * 100.0);
        int filled = percent / 10;
        StringBuilder bar = new StringBuilder("[");
        for (int i = 0; i < 10; ++i) {
            if (i < filled) {
                bar.append("\u2588");
                continue;
            }
            bar.append("\u2591");
        }
        bar.append("]");
        return bar.toString();
    }

    private static String getRarityIcon(double yield) {
        if (yield >= 2.0) {
            return "\ud83d\udfe2";
        }
        if (yield >= 1.0) {
            return "\ud83d\udfe1";
        }
        if (yield >= 0.5) {
            return "\ud83d\udfe0";
        }
        if (yield >= 0.1) {
            return "\ud83d\udd35";
        }
        return "\ud83d\udfe3";
    }

    private static ChatFormatting getRarityColor(double yield) {
        if (yield >= 2.0) {
            return ChatFormatting.GREEN;
        }
        if (yield >= 1.0) {
            return ChatFormatting.YELLOW;
        }
        if (yield >= 0.5) {
            return ChatFormatting.GOLD;
        }
        if (yield >= 0.1) {
            return ChatFormatting.AQUA;
        }
        return ChatFormatting.LIGHT_PURPLE;
    }
}

