/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.command;

import com.mojang.brigadier.context.CommandContext;
import java.nio.file.Path;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import org.complexityanalyzer.ComplexityAnalyzer;
import org.complexityanalyzer.command.util.OutputManager;
import org.complexityanalyzer.core.AnalysisEngine;
import org.complexityanalyzer.export.ComplexityExporter;

public class ExportCommand {
    public static int executeAllItems(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        OutputManager output = new OutputManager(source.getServer());
        AnalysisEngine engine = AnalysisEngine.getInstance();
        if (!engine.isReady()) {
            return ExportCommand.sendEngineNotReady(output, source, engine);
        }
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)"\ud83d\udcbe ").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)"FULL ITEM EXPORT").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udd04 Starting export process...").withStyle(ChatFormatting.YELLOW));
        output.sendInfo(source, (Component)Component.literal((String)""));
        try {
            Path exportPath = ComplexityExporter.exportAllItems(source.getServer(), engine);
            ExportCommand.sendSuccess(output, source, "Full item export", exportPath);
            return 1;
        }
        catch (Exception e) {
            ExportCommand.sendFailure(output, source, "full item", e);
            return 0;
        }
    }

    public static int executeItemsByCategory(CommandContext<CommandSourceStack> context, String categoryName) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        OutputManager output = new OutputManager(source.getServer());
        AnalysisEngine engine = AnalysisEngine.getInstance();
        if (!engine.isReady()) {
            return ExportCommand.sendEngineNotReady(output, source, engine);
        }
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)"\ud83d\udce6 ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)"ITEM CATEGORY EXPORT").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udccb Category: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)categoryName).withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udd04 Exporting...").withStyle(ChatFormatting.AQUA));
        output.sendInfo(source, (Component)Component.literal((String)""));
        try {
            Path exportPath = ComplexityExporter.exportItemsByCategory(source.getServer(), engine, categoryName);
            ExportCommand.sendSuccess(output, source, "Item category export", exportPath);
            return 1;
        }
        catch (Exception e) {
            ExportCommand.sendFailure(output, source, "item category", e);
            return 0;
        }
    }

    public static int executeTopItems(CommandContext<CommandSourceStack> context, int count) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        OutputManager output = new OutputManager(source.getServer());
        AnalysisEngine engine = AnalysisEngine.getInstance();
        if (!engine.isReady()) {
            return ExportCommand.sendEngineNotReady(output, source, engine);
        }
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)"\ud83c\udfc6 ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)"TOP ITEMS EXPORT").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udd22 Count: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(count)).withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udd04 Calculating and exporting...").withStyle(ChatFormatting.YELLOW));
        output.sendInfo(source, (Component)Component.literal((String)""));
        try {
            Path exportPath = ComplexityExporter.exportTopItems(source.getServer(), engine, count);
            ExportCommand.sendSuccess(output, source, "Top items export", exportPath);
            return 1;
        }
        catch (Exception e) {
            ExportCommand.sendFailure(output, source, "top items", e);
            return 0;
        }
    }

    public static int executeItemsCSV(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        OutputManager output = new OutputManager(source.getServer());
        AnalysisEngine engine = AnalysisEngine.getInstance();
        if (!engine.isReady()) {
            return ExportCommand.sendEngineNotReady(output, source, engine);
        }
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)"\ud83d\udcca ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)"ITEMS CSV EXPORT").withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udd04 Exporting...").withStyle(ChatFormatting.YELLOW));
        output.sendInfo(source, (Component)Component.literal((String)""));
        try {
            Path exportPath = ComplexityExporter.exportItemsCSV(source.getServer(), engine);
            ExportCommand.sendSuccess(output, source, "Items CSV export", exportPath);
            return 1;
        }
        catch (Exception e) {
            ExportCommand.sendFailure(output, source, "items CSV", e);
            return 0;
        }
    }

    public static int executeSingleItem(CommandContext<CommandSourceStack> context, String itemId) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        OutputManager output = new OutputManager(source.getServer());
        AnalysisEngine engine = AnalysisEngine.getInstance();
        if (!engine.isReady()) {
            return ExportCommand.sendEngineNotReady(output, source, engine);
        }
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)"\ud83d\udcc4 ").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)"SINGLE ITEM EXPORT").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83c\udff7 Item: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)itemId).withStyle(ChatFormatting.WHITE)));
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udd04 Exporting...").withStyle(ChatFormatting.YELLOW));
        output.sendInfo(source, (Component)Component.literal((String)""));
        try {
            Path exportPath = ComplexityExporter.exportSingleItem(source.getServer(), engine, itemId);
            ExportCommand.sendSuccess(output, source, "Single item export", exportPath);
            return 1;
        }
        catch (Exception e) {
            ExportCommand.sendFailure(output, source, "single item", e);
            return 0;
        }
    }

    public static int executeAllMobs(CommandContext<CommandSourceStack> context, String format) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        OutputManager output = new OutputManager(source.getServer());
        AnalysisEngine engine = AnalysisEngine.getInstance();
        if (!engine.isReady()) {
            return ExportCommand.sendEngineNotReady(output, source, engine);
        }
        if (!"csv".equalsIgnoreCase(format) && !"json".equalsIgnoreCase(format)) {
            output.sendFailure(source, (Component)Component.literal((String)("Invalid format: " + format + ". Use 'csv' or 'json'.")));
            return 0;
        }
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)"\ud83e\udddf ").withStyle(ChatFormatting.RED).append((Component)Component.literal((String)"ALL MOBS EXPORT").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udccb Format: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)format.toUpperCase()).withStyle(ChatFormatting.AQUA)));
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udd04 Exporting...").withStyle(ChatFormatting.YELLOW));
        output.sendInfo(source, (Component)Component.literal((String)""));
        try {
            Path exportPath = ComplexityExporter.exportAllMobs(source.getServer(), engine, format);
            ExportCommand.sendSuccess(output, source, "All mobs export", exportPath);
            return 1;
        }
        catch (Exception e) {
            ExportCommand.sendFailure(output, source, "all mobs", e);
            return 0;
        }
    }

    public static int executeMobsByCategory(CommandContext<CommandSourceStack> context, String categoryName) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        OutputManager output = new OutputManager(source.getServer());
        AnalysisEngine engine = AnalysisEngine.getInstance();
        if (!engine.isReady()) {
            return ExportCommand.sendEngineNotReady(output, source, engine);
        }
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)"\ud83d\udce6 ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)"MOB CATEGORY EXPORT").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udccb Category: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)categoryName).withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udd04 Exporting...").withStyle(ChatFormatting.AQUA));
        output.sendInfo(source, (Component)Component.literal((String)""));
        try {
            Path exportPath = ComplexityExporter.exportMobsByCategory(source.getServer(), engine, categoryName);
            ExportCommand.sendSuccess(output, source, "Mob category export", exportPath);
            return 1;
        }
        catch (Exception e) {
            ExportCommand.sendFailure(output, source, "mob category", e);
            return 0;
        }
    }

    public static int executeTopMobs(CommandContext<CommandSourceStack> context, int count) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        OutputManager output = new OutputManager(source.getServer());
        AnalysisEngine engine = AnalysisEngine.getInstance();
        if (!engine.isReady()) {
            return ExportCommand.sendEngineNotReady(output, source, engine);
        }
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)"\ud83c\udfc6 ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)"TOP MOBS EXPORT").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udd22 Count: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(count)).withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udd04 Calculating and exporting...").withStyle(ChatFormatting.YELLOW));
        output.sendInfo(source, (Component)Component.literal((String)""));
        try {
            Path exportPath = ComplexityExporter.exportTopMobs(source.getServer(), engine, count);
            ExportCommand.sendSuccess(output, source, "Top mobs export", exportPath);
            return 1;
        }
        catch (Exception e) {
            ExportCommand.sendFailure(output, source, "top mobs", e);
            return 0;
        }
    }

    public static int executeSingleMob(CommandContext<CommandSourceStack> context, String mobId) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        OutputManager output = new OutputManager(source.getServer());
        AnalysisEngine engine = AnalysisEngine.getInstance();
        if (!engine.isReady()) {
            return ExportCommand.sendEngineNotReady(output, source, engine);
        }
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)"\ud83d\udcc4 ").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)"SINGLE MOB EXPORT").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83e\udddf Mob: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)mobId).withStyle(ChatFormatting.WHITE)));
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udd04 Exporting...").withStyle(ChatFormatting.YELLOW));
        output.sendInfo(source, (Component)Component.literal((String)""));
        try {
            Path exportPath = ComplexityExporter.exportSingleMob(source.getServer(), engine, mobId);
            ExportCommand.sendSuccess(output, source, "Single mob export", exportPath);
            return 1;
        }
        catch (Exception e) {
            ExportCommand.sendFailure(output, source, "single mob", e);
            return 0;
        }
    }

    private static int sendEngineNotReady(OutputManager output, CommandSourceStack source, AnalysisEngine engine) {
        output.sendFailure(source, (Component)Component.literal((String)"\u26a0 Analysis engine is not ready yet!").withStyle(ChatFormatting.RED));
        output.sendInfo(source, (Component)Component.literal((String)("Current state: " + String.valueOf((Object)engine.getCurrentState()))).withStyle(ChatFormatting.GRAY));
        return 0;
    }

    private static void sendSuccess(OutputManager output, CommandSourceStack source, String exportType, Path exportPath) {
        output.sendInfo(source, (Component)Component.literal((String)"  \u2713 Export successful!").withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}));
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udcc1 File: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)exportPath.getFileName().toString()).withStyle(ChatFormatting.WHITE)));
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendToAdmins((Component)Component.literal((String)("\u2713 " + exportType + " completed.")));
    }

    private static void sendFailure(OutputManager output, CommandSourceStack source, String exportType, Exception e) {
        output.sendFailure(source, (Component)Component.literal((String)("\u274c " + exportType + " export failed: " + e.getMessage())));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        ComplexityAnalyzer.LOGGER.error("Error exporting {}", (Object)exportType, (Object)e);
    }
}

