/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.command;

import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.complexityanalyzer.analyzer.resource.data.BaseResourceData;
import org.complexityanalyzer.analyzer.resource.sources.UniversalLootSource;
import org.complexityanalyzer.command.util.OutputManager;
import org.complexityanalyzer.core.AnalysisEngine;

public class LootAnalyzeCommand {
    public static int execute(CommandContext<CommandSourceStack> context, ResourceLocation lootTableId) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        OutputManager output = new OutputManager(source.getServer());
        AnalysisEngine engine = AnalysisEngine.getInstance();
        if (!engine.isReady()) {
            output.sendFailure(source, (Component)Component.literal((String)"\u26a0 Analysis engine is not ready!").withStyle(ChatFormatting.RED));
            return 0;
        }
        Optional<UniversalLootSource> ulsOpt = engine.getSourceByType(UniversalLootSource.class);
        if (ulsOpt.isEmpty()) {
            output.sendFailure(source, (Component)Component.literal((String)"\u26a0 UniversalLootSource is not initialized!").withStyle(ChatFormatting.RED));
            output.sendInfo(source, (Component)Component.literal((String)"This feature may be disabled in the config.").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            return 0;
        }
        UniversalLootSource uls = ulsOpt.get();
        ArrayList<BaseResourceData> itemsFromTable = new ArrayList<BaseResourceData>();
        for (Map.Entry<BaseResourceData.ResourceSourceType, Map<Item, BaseResourceData>> typeEntry : uls.getAllLootData().entrySet()) {
            for (BaseResourceData data : typeEntry.getValue().values()) {
                if (!data.getDetails().contains(lootTableId.toString())) continue;
                itemsFromTable.add(data);
            }
        }
        if (itemsFromTable.isEmpty()) {
            output.sendFailure(source, (Component)Component.literal((String)"\u274c No items found for loot table").withStyle(ChatFormatting.RED));
            output.sendInfo(source, (Component)Component.literal((String)"Table: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)lootTableId.toString()).withStyle(ChatFormatting.YELLOW)));
            output.sendInfo(source, (Component)Component.literal((String)""));
            output.sendInfo(source, (Component)Component.literal((String)"Possible reasons:").withStyle(ChatFormatting.GRAY));
            output.sendInfo(source, (Component)Component.literal((String)"  \u2022 Table is empty").withStyle(ChatFormatting.DARK_GRAY));
            output.sendInfo(source, (Component)Component.literal((String)"  \u2022 Table doesn't exist").withStyle(ChatFormatting.DARK_GRAY));
            output.sendInfo(source, (Component)Component.literal((String)"  \u2022 Not cached yet").withStyle(ChatFormatting.DARK_GRAY));
            return 0;
        }
        itemsFromTable.sort(Comparator.comparingDouble(LootAnalyzeCommand::extractChance).reversed());
        LootAnalyzeCommand.displayLootAnalysis(source, lootTableId, itemsFromTable, output);
        return 1;
    }

    private static void displayLootAnalysis(CommandSourceStack source, ResourceLocation lootTableId, List<BaseResourceData> items, OutputManager output) {
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        String tableIcon = LootAnalyzeCommand.getLootTableIcon(lootTableId);
        output.sendInfo(source, (Component)Component.literal((String)(tableIcon + " ")).withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)"Loot Table Analysis").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)""));
        String tablePath = lootTableId.toString();
        String tableType = LootAnalyzeCommand.getLootTableType(tablePath);
        ChatFormatting typeColor = LootAnalyzeCommand.getTableTypeColor(tableType);
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udccb Table: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)lootTableId.getPath()).withStyle(ChatFormatting.WHITE)));
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83c\udff7 Type: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)tableType).withStyle(new ChatFormatting[]{typeColor, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udce6 Items Found: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(items.size())).withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)""));
        LootAnalyzeCommand.displayStatistics(source, items, output);
        LootAnalyzeCommand.displayItemsByRarity(source, items, output);
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
    }

    private static void displayStatistics(CommandSourceStack source, List<BaseResourceData> items, OutputManager output) {
        double totalChance = 0.0;
        double highestChance = 0.0;
        double lowestChance = 100.0;
        for (BaseResourceData data : items) {
            double chance = LootAnalyzeCommand.extractChance(data);
            totalChance += chance;
            highestChance = Math.max(highestChance, chance);
            lowestChance = Math.min(lowestChance, chance);
        }
        double avgChance = totalChance / (double)items.size();
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udcca Statistics").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
        output.sendInfo(source, (Component)Component.literal((String)"    Average Chance: ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)String.format("%.2f%%", avgChance)).withStyle(ChatFormatting.AQUA)));
        output.sendInfo(source, (Component)Component.literal((String)"    Highest: ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)String.format("%.2f%%", highestChance)).withStyle(ChatFormatting.GREEN)));
        output.sendInfo(source, (Component)Component.literal((String)"    Lowest: ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)String.format("%.2f%%", lowestChance)).withStyle(ChatFormatting.RED)));
        output.sendInfo(source, (Component)Component.literal((String)""));
    }

    private static void displayItemsByRarity(CommandSourceStack source, List<BaseResourceData> items, OutputManager output) {
        ArrayList<BaseResourceData> common = new ArrayList<BaseResourceData>();
        ArrayList<BaseResourceData> uncommon = new ArrayList<BaseResourceData>();
        ArrayList<BaseResourceData> rare = new ArrayList<BaseResourceData>();
        ArrayList<BaseResourceData> veryRare = new ArrayList<BaseResourceData>();
        ArrayList<BaseResourceData> legendary = new ArrayList<BaseResourceData>();
        for (BaseResourceData data : items) {
            double chance = LootAnalyzeCommand.extractChance(data);
            if (chance > 20.0) {
                common.add(data);
                continue;
            }
            if (chance > 10.0) {
                uncommon.add(data);
                continue;
            }
            if (chance > 5.0) {
                rare.add(data);
                continue;
            }
            if (chance > 1.0) {
                veryRare.add(data);
                continue;
            }
            legendary.add(data);
        }
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udc8e Drops by Rarity").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
        output.sendInfo(source, (Component)Component.literal((String)""));
        if (!common.isEmpty()) {
            LootAnalyzeCommand.displayRarityCategory(source, "Common", "\ud83d\udfe2", ChatFormatting.GREEN, common, output);
        }
        if (!uncommon.isEmpty()) {
            LootAnalyzeCommand.displayRarityCategory(source, "Uncommon", "\ud83d\udfe1", ChatFormatting.YELLOW, uncommon, output);
        }
        if (!rare.isEmpty()) {
            LootAnalyzeCommand.displayRarityCategory(source, "Rare", "\ud83d\udfe0", ChatFormatting.GOLD, rare, output);
        }
        if (!veryRare.isEmpty()) {
            LootAnalyzeCommand.displayRarityCategory(source, "Very Rare", "\ud83d\udd35", ChatFormatting.AQUA, veryRare, output);
        }
        if (!legendary.isEmpty()) {
            LootAnalyzeCommand.displayRarityCategory(source, "Legendary", "\ud83d\udfe3", ChatFormatting.LIGHT_PURPLE, legendary, output);
        }
    }

    private static void displayRarityCategory(CommandSourceStack source, String categoryName, String icon, ChatFormatting color, List<BaseResourceData> items, OutputManager output) {
        output.sendInfo(source, (Component)Component.literal((String)("  " + icon + " ")).withStyle(color).append((Component)Component.literal((String)(categoryName + " (" + items.size() + ")")).withStyle(new ChatFormatting[]{color, ChatFormatting.BOLD})));
        for (BaseResourceData data : items) {
            LootAnalyzeCommand.displayItem(source, data, output);
        }
        output.sendInfo(source, (Component)Component.literal((String)""));
    }

    private static void displayItem(CommandSourceStack source, BaseResourceData data, OutputManager output) {
        MutableComponent itemComponent = data.getItem().getDescription().copy();
        double chance = LootAnalyzeCommand.extractChance(data);
        ChatFormatting chanceColor = LootAnalyzeCommand.getChanceColor(chance);
        String chanceBar = LootAnalyzeCommand.getChanceBar(chance);
        MutableComponent itemLine = Component.literal((String)"    \u2022 ").withStyle(ChatFormatting.DARK_GRAY).append((Component)itemComponent.copy().withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)": ").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)String.format("%.2f%%", chance)).withStyle(new ChatFormatting[]{chanceColor, ChatFormatting.BOLD}));
        output.sendInfo(source, (Component)itemLine);
        output.sendInfo(source, (Component)Component.literal((String)("      " + chanceBar)).withStyle(ChatFormatting.DARK_GRAY));
    }

    private static String getLootTableIcon(ResourceLocation lootTableId) {
        String path = lootTableId.getPath().toLowerCase();
        if (path.contains("chest")) {
            return "\ud83d\udce6";
        }
        if (path.contains("entities") || path.contains("mobs")) {
            return "\u2694";
        }
        if (path.contains("fishing")) {
            return "\ud83c\udfa3";
        }
        if (path.contains("gameplay")) {
            return "\ud83c\udfb2";
        }
        if (path.contains("blocks")) {
            return "\u26cf";
        }
        return "\ud83c\udf81";
    }

    private static String getLootTableType(String path) {
        if ((path = path.toLowerCase()).contains("chests/")) {
            return "Chest Loot";
        }
        if (path.contains("entities/")) {
            return "Entity Drop";
        }
        if (path.contains("gameplay/fishing")) {
            return "Fishing Loot";
        }
        if (path.contains("blocks/")) {
            return "Block Drop";
        }
        if (path.contains("archaeology/")) {
            return "Archaeology";
        }
        return "Generic Loot";
    }

    private static ChatFormatting getTableTypeColor(String type) {
        return switch (type) {
            case "Chest Loot" -> ChatFormatting.GOLD;
            case "Entity Drop" -> ChatFormatting.RED;
            case "Fishing Loot" -> ChatFormatting.AQUA;
            case "Block Drop" -> ChatFormatting.GRAY;
            case "Archaeology" -> ChatFormatting.YELLOW;
            default -> ChatFormatting.WHITE;
        };
    }

    private static ChatFormatting getChanceColor(double chance) {
        if (chance > 20.0) {
            return ChatFormatting.GREEN;
        }
        if (chance > 10.0) {
            return ChatFormatting.YELLOW;
        }
        if (chance > 5.0) {
            return ChatFormatting.GOLD;
        }
        if (chance > 1.0) {
            return ChatFormatting.AQUA;
        }
        return ChatFormatting.LIGHT_PURPLE;
    }

    private static String getChanceBar(double chance) {
        int filled = (int)Math.min(10.0, Math.ceil(chance / 10.0));
        StringBuilder bar = new StringBuilder("[");
        for (int i = 0; i < 10; ++i) {
            if (i < filled) {
                bar.append("\u2588");
                continue;
            }
            bar.append("\u2591");
        }
        bar.append("]");
        return bar.toString();
    }

    private static double extractChance(BaseResourceData data) {
        try {
            String details = data.getDetails();
            String chancePart = details.substring(details.indexOf("Chance: ") + 8);
            String numberPart = chancePart.replace("%", "").trim();
            return Double.parseDouble(numberPart);
        }
        catch (Exception e) {
            return 0.0;
        }
    }
}

