/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.command;

import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.complexityanalyzer.ComplexityAnalyzer;
import org.complexityanalyzer.analyzer.resource.data.BaseResourceData;
import org.complexityanalyzer.command.util.OutputManager;
import org.complexityanalyzer.core.AnalysisEngine;
import org.complexityanalyzer.data.ItemComplexity;
import org.complexityanalyzer.event.DatapackSyncHandler;

public class ResourceCommand {
    public static int execute(CommandContext<CommandSourceStack> context, ResourceLocation itemId) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        OutputManager output = new OutputManager(source.getServer());
        AnalysisEngine engine = DatapackSyncHandler.getEngine();
        if (!engine.isReady()) {
            output.sendFailure(source, (Component)Component.literal((String)"\u26a0 Analysis engine is not ready yet!").withStyle(ChatFormatting.RED));
            return 0;
        }
        Optional itemOpt = BuiltInRegistries.ITEM.getOptional(itemId);
        if (itemOpt.isEmpty()) {
            output.sendFailure(source, (Component)Component.literal((String)"\u274c Item not found: ").append((Component)Component.literal((String)itemId.toString()).withStyle(ChatFormatting.YELLOW)));
            return 0;
        }
        Item item = (Item)itemOpt.get();
        try {
            Optional<BaseResourceData> resourceDataOpt = engine.getBaseResourceData(item);
            if (resourceDataOpt.isEmpty()) {
                output.sendFailure(source, (Component)Component.literal((String)"\u26a0 No base resource data available").withStyle(ChatFormatting.RED));
                output.sendInfo(source, (Component)Component.literal((String)"Item: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)itemId.toString()).withStyle(ChatFormatting.YELLOW)));
                output.sendInfo(source, (Component)Component.literal((String)""));
                output.sendInfo(source, (Component)Component.literal((String)"This item might only be obtainable through crafting.").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
                return 0;
            }
            BaseResourceData data = resourceDataOpt.get();
            ResourceCommand.displayResourceInfo(source, item, data, engine, itemId, output);
            return 1;
        }
        catch (Exception e) {
            output.sendFailure(source, (Component)Component.literal((String)("\u274c Error analyzing resource: " + e.getMessage())));
            ComplexityAnalyzer.LOGGER.error("Error analyzing resource {}", (Object)itemId, (Object)e);
            return 0;
        }
    }

    private static void displayResourceInfo(CommandSourceStack source, Item item, BaseResourceData data, AnalysisEngine engine, ResourceLocation itemId, OutputManager output) {
        String itemName = item.getDescription().getString();
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        String resourceIcon = ResourceCommand.getSourceIcon(data.getSourceType());
        output.sendInfo(source, (Component)Component.literal((String)(resourceIcon + " ")).withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)"Base Resource Analysis").withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"  Item: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)itemName).withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)""));
        ResourceCommand.displaySourceInfo(source, data, output);
        ResourceCommand.displayBaseFactor(source, data, output);
        ResourceCommand.displaySourceItems(source, data, engine, output);
        ResourceCommand.displayAdditionalInfo(source, item, engine, itemId, output);
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
    }

    private static void displaySourceInfo(CommandSourceStack source, BaseResourceData data, OutputManager output) {
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udccd Source Information").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
        String sourceIcon = ResourceCommand.getSourceIcon(data.getSourceType());
        ChatFormatting sourceColor = ResourceCommand.getSourceColor(data.getSourceType());
        output.sendInfo(source, (Component)Component.literal((String)("    Type: " + sourceIcon + " ")).withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)data.getSourceType().getDisplayName()).withStyle(new ChatFormatting[]{sourceColor, ChatFormatting.BOLD})));
        if (!data.getDetails().isEmpty()) {
            output.sendInfo(source, (Component)Component.literal((String)"    Details: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)data.getDetails()).withStyle(ChatFormatting.WHITE)));
        }
        output.sendInfo(source, (Component)Component.literal((String)""));
    }

    private static void displayBaseFactor(CommandSourceStack source, BaseResourceData data, OutputManager output) {
        double baseFactor = data.getBaseFactor();
        ChatFormatting factorColor = ResourceCommand.getFactorColor(baseFactor);
        String difficultyText = ResourceCommand.getFactorDifficulty(baseFactor);
        output.sendInfo(source, (Component)Component.literal((String)"  \u2696 Base Factor").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
        output.sendInfo(source, (Component)Component.literal((String)"    Value: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.format("%.2f", baseFactor)).withStyle(new ChatFormatting[]{factorColor, ChatFormatting.BOLD})));
        String factorBar = ResourceCommand.getFactorBar(baseFactor);
        output.sendInfo(source, (Component)Component.literal((String)("    " + factorBar)).withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)"    Difficulty: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)difficultyText).withStyle(factorColor)));
        output.sendInfo(source, (Component)Component.literal((String)""));
    }

    private static void displaySourceItems(CommandSourceStack source, BaseResourceData data, AnalysisEngine engine, OutputManager output) {
        Map<Item, Double> sourceItems = data.getSourceItems();
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udd17 Required Source Items").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}));
        output.sendInfo(source, (Component)Component.literal((String)"    (Items needed to obtain this resource)").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        for (Map.Entry<Item, Double> entry : sourceItems.entrySet()) {
            Item sourceItem = entry.getKey();
            double amount = entry.getValue();
            String sourceItemName = sourceItem.getDescription().getString();
            Optional<Double> sourceComplexity = engine.getComplexityResult(sourceItem).map(ItemComplexity::getComplexity);
            MutableComponent itemLine = Component.literal((String)"    \u2022 ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)sourceItemName).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)(" x" + String.format("%.1f", amount))).withStyle(ChatFormatting.YELLOW));
            if (sourceComplexity.isPresent()) {
                double complexity = sourceComplexity.get();
                ChatFormatting complexityColor = ResourceCommand.getComplexityColor(complexity);
                itemLine.append((Component)Component.literal((String)" (").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)String.format("%.2f", complexity)).withStyle(complexityColor)).append((Component)Component.literal((String)")").withStyle(ChatFormatting.DARK_GRAY));
            }
            output.sendInfo(source, (Component)itemLine);
        }
        output.sendInfo(source, (Component)Component.literal((String)""));
    }

    private static void displayAdditionalInfo(CommandSourceStack source, Item item, AnalysisEngine engine, ResourceLocation itemId, OutputManager output) {
        boolean hasRecipe = engine.hasRecipe(item);
        output.sendInfo(source, (Component)Component.literal((String)"  \u2139 Additional Information").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}));
        if (hasRecipe) {
            output.sendInfo(source, (Component)Component.literal((String)"    \u26a0 This item also has crafting recipes").withStyle(ChatFormatting.YELLOW));
            output.sendInfo(source, (Component)Component.literal((String)""));
            String analyzeCommand = "/complexity analyze item " + String.valueOf(itemId);
            MutableComponent clickableLink = Component.literal((String)"    \ud83d\udca1 ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"[Click here]").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.UNDERLINE}).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, analyzeCommand)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"View full complexity analysis").withStyle(ChatFormatting.GREEN))))).append((Component)Component.literal((String)" for full analysis").withStyle(ChatFormatting.GRAY));
            output.sendInfo(source, (Component)clickableLink);
        } else {
            output.sendInfo(source, (Component)Component.literal((String)"    \u2713 Pure base resource").withStyle(ChatFormatting.GREEN));
            output.sendInfo(source, (Component)Component.literal((String)"    No crafting recipes available").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        }
        output.sendInfo(source, (Component)Component.literal((String)""));
    }

    private static String getSourceIcon(BaseResourceData.ResourceSourceType sourceType) {
        return switch (sourceType.name()) {
            case "MINING" -> "\u26cf";
            case "MOB_DROP" -> "\u2694";
            case "CHEST_LOOT" -> "\ud83d\udce6";
            case "FISHING" -> "\ud83c\udfa3";
            case "TRADING" -> "\ud83d\udcb0";
            case "FARMING" -> "\ud83c\udf3e";
            case "FORAGING" -> "\ud83e\ude93";
            default -> "\ud83d\udccd";
        };
    }

    private static ChatFormatting getSourceColor(BaseResourceData.ResourceSourceType sourceType) {
        return switch (sourceType.name()) {
            case "MINING" -> ChatFormatting.GRAY;
            case "MOB_DROP" -> ChatFormatting.RED;
            case "CHEST_LOOT" -> ChatFormatting.GOLD;
            case "FISHING" -> ChatFormatting.AQUA;
            case "TRADING" -> ChatFormatting.GREEN;
            case "FARMING" -> ChatFormatting.YELLOW;
            case "FORAGING" -> ChatFormatting.DARK_GREEN;
            default -> ChatFormatting.WHITE;
        };
    }

    private static ChatFormatting getFactorColor(double baseFactor) {
        if (baseFactor >= 20.0) {
            return ChatFormatting.DARK_RED;
        }
        if (baseFactor >= 15.0) {
            return ChatFormatting.RED;
        }
        if (baseFactor >= 10.0) {
            return ChatFormatting.GOLD;
        }
        if (baseFactor >= 5.0) {
            return ChatFormatting.YELLOW;
        }
        return ChatFormatting.GREEN;
    }

    private static String getFactorDifficulty(double baseFactor) {
        if (baseFactor >= 20.0) {
            return "Extremely Hard";
        }
        if (baseFactor >= 15.0) {
            return "Very Hard";
        }
        if (baseFactor >= 10.0) {
            return "Hard";
        }
        if (baseFactor >= 5.0) {
            return "Moderate";
        }
        if (baseFactor >= 2.0) {
            return "Easy";
        }
        return "Very Easy";
    }

    private static String getFactorBar(double baseFactor) {
        int filled = (int)Math.min(10.0, Math.ceil(baseFactor / 2.5));
        StringBuilder bar = new StringBuilder("[");
        for (int i = 0; i < 10; ++i) {
            if (i < filled) {
                bar.append("\u2588");
                continue;
            }
            bar.append("\u2591");
        }
        bar.append("]");
        return bar.toString();
    }

    private static ChatFormatting getComplexityColor(double complexity) {
        if (complexity >= 100.0) {
            return ChatFormatting.DARK_RED;
        }
        if (complexity >= 50.0) {
            return ChatFormatting.RED;
        }
        if (complexity >= 30.0) {
            return ChatFormatting.GOLD;
        }
        if (complexity >= 10.0) {
            return ChatFormatting.YELLOW;
        }
        return ChatFormatting.GREEN;
    }
}

