/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.command;

import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.complexityanalyzer.ComplexityAnalyzer;
import org.complexityanalyzer.analyzer.DepthAnalyzer;
import org.complexityanalyzer.command.util.OutputManager;
import org.complexityanalyzer.core.AnalysisEngine;
import org.complexityanalyzer.graph.IngredientSlot;
import org.complexityanalyzer.graph.RecipeNode;

public class TreeCommand {
    public static final int DEFAULT_MAX_DEPTH = 100;

    public static int execute(CommandContext<CommandSourceStack> context, ResourceLocation itemId, String mode, int maxDepth) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        OutputManager output = new OutputManager(source.getServer());
        AnalysisEngine engine = AnalysisEngine.getInstance();
        if (!engine.isReady() || engine.getDepthAnalyzer().isEmpty()) {
            output.sendFailure(source, (Component)Component.literal((String)"\u26a0 Analysis engine or Depth Analyzer is not ready!").withStyle(ChatFormatting.RED));
            return 0;
        }
        DisplayMode displayMode = "economic".equalsIgnoreCase(mode) ? DisplayMode.ECONOMIC_COST : DisplayMode.PLAYER_INSTRUCTION;
        Optional itemOpt = BuiltInRegistries.ITEM.getOptional(itemId);
        if (itemOpt.isEmpty()) {
            output.sendFailure(source, (Component)Component.literal((String)"\u274c Item not found: ").append((Component)Component.literal((String)itemId.toString()).withStyle(ChatFormatting.YELLOW)));
            return 0;
        }
        Item item = (Item)itemOpt.get();
        DepthAnalyzer depthAnalyzer = engine.getDepthAnalyzer().get();
        try {
            TreeCommand.displayTree(source, item, engine, depthAnalyzer, displayMode, maxDepth, output, itemId);
            return 1;
        }
        catch (Exception e) {
            output.sendFailure(source, (Component)Component.literal((String)("\u274c Error building crafting tree: " + e.getMessage())));
            ComplexityAnalyzer.LOGGER.error("Error building tree for {}", (Object)itemId, (Object)e);
            return 0;
        }
    }

    private static void displayTree(CommandSourceStack source, Item item, AnalysisEngine engine, DepthAnalyzer depthAnalyzer, DisplayMode displayMode, int maxDepth, OutputManager output, ResourceLocation itemId) {
        String itemName = item.getDescription().getString();
        double complexity = engine.getComplexity(item);
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)"\ud83c\udf33 ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)"CRAFTING TREE ANALYSIS").withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)""));
        ChatFormatting complexityColor = TreeCommand.getComplexityColor(complexity);
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83c\udfaf Target: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)itemName).withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)"  \u2696 Complexity: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.format("%.2f", complexity)).withStyle(new ChatFormatting[]{complexityColor, ChatFormatting.BOLD})));
        String modeIcon = displayMode == DisplayMode.PLAYER_INSTRUCTION ? "\ud83d\udc64" : "\ud83d\udcb0";
        String modeName = displayMode == DisplayMode.PLAYER_INSTRUCTION ? "Player View" : "Economic View";
        ChatFormatting modeColor = displayMode == DisplayMode.PLAYER_INSTRUCTION ? ChatFormatting.AQUA : ChatFormatting.GOLD;
        output.sendInfo(source, (Component)Component.literal((String)("  " + modeIcon + " Mode: ")).withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)modeName).withStyle(modeColor)));
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udd0d Max Depth: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(maxDepth)).withStyle(ChatFormatting.YELLOW)));
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"  \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)""));
        LinkedHashMap<Item, Double> baseResources = new LinkedHashMap<Item, Double>();
        HashSet<Item> uniqueItems = new HashSet<Item>();
        TreeStats stats = new TreeStats();
        double initialAmount = displayMode == DisplayMode.PLAYER_INSTRUCTION ? Math.ceil(1.0) : 1.0;
        TreeCommand.displayNodeRecursive(source, item, initialAmount, 0, "  ", true, new HashSet<Item>(), engine, depthAnalyzer, baseResources, displayMode, maxDepth, uniqueItems, stats, output);
        output.sendInfo(source, (Component)Component.literal((String)""));
        output.sendInfo(source, (Component)Component.literal((String)"  \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)Component.literal((String)""));
        TreeCommand.displayStatistics(source, stats, uniqueItems, output);
        TreeCommand.displayBaseResources(source, baseResources, displayMode, engine, output);
        TreeCommand.displayTips(source, displayMode, maxDepth, stats, output, itemId);
        output.sendInfo(source, (Component)Component.literal((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").withStyle(ChatFormatting.DARK_GRAY));
    }

    private static void displayNodeRecursive(CommandSourceStack source, Item item, double neededAmount, int depth, String prefix, boolean isLast, Set<Item> visitedOnPath, AnalysisEngine engine, DepthAnalyzer depthAnalyzer, Map<Item, Double> baseResources, DisplayMode displayMode, int maxDepth, Set<Item> uniqueItems, TreeStats stats, OutputManager output) {
        double craftOperations;
        int displayAmount;
        uniqueItems.add(item);
        ++stats.totalNodes;
        if (depth >= maxDepth) {
            MutableComponent line = Component.literal((String)prefix).append((Component)Component.literal((String)(isLast ? "\u2514\u2500 " : "\u251c\u2500 ")).withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)"... ").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC})).append((Component)Component.literal((String)"[MAX DEPTH REACHED]").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
            output.sendInfo(source, (Component)line);
            TreeCommand.calculateBaseResourcesFor(item, neededAmount, new HashSet<Item>(visitedOnPath), engine, depthAnalyzer, baseResources, displayMode);
            return;
        }
        if (!visitedOnPath.add(item)) {
            ++stats.cyclesDetected;
            MutableComponent line = Component.literal((String)prefix).append((Component)Component.literal((String)(isLast ? "\u2514\u2500 " : "\u251c\u2500 ")).withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)"\ud83d\udd04 ").withStyle(ChatFormatting.RED)).append((Component)Component.literal((String)item.getDescription().getString()).withStyle(ChatFormatting.RED)).append((Component)Component.literal((String)" [CYCLE]").withStyle(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD}));
            output.sendInfo(source, (Component)line);
            return;
        }
        Object quantityString = displayMode == DisplayMode.PLAYER_INSTRUCTION ? ((displayAmount = (int)Math.ceil(neededAmount)) >= 1 ? displayAmount + "x " : "") : (neededAmount > 0.001 ? String.format("%.2fx ", neededAmount) : "");
        double complexity = engine.getComplexity(item);
        ChatFormatting complexityColor = TreeCommand.getComplexityColor(complexity);
        Optional<RecipeNode> recipeOpt = depthAnalyzer.getRecipeToFollow(item);
        if (recipeOpt.isEmpty() || recipeOpt.get().isBaseRecipe()) {
            ++stats.baseResourcesCount;
            double amountToAdd = displayMode == DisplayMode.PLAYER_INSTRUCTION ? Math.ceil(neededAmount) : neededAmount;
            baseResources.merge(item, amountToAdd, Double::sum);
            MutableComponent line = Component.literal((String)prefix).append((Component)Component.literal((String)(isLast ? "\u2514\u2500 " : "\u251c\u2500 ")).withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)"\u26cf ").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)quantityString).withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})).append((Component)Component.literal((String)item.getDescription().getString()).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" (").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)String.format("%.2f", complexity)).withStyle(complexityColor)).append((Component)Component.literal((String)") ").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)"[BASE]").withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}));
            output.sendInfo(source, (Component)line);
            visitedOnPath.remove(item);
            return;
        }
        ++stats.craftingSteps;
        MutableComponent line = Component.literal((String)prefix).append((Component)Component.literal((String)(isLast ? "\u2514\u2500 " : "\u251c\u2500 ")).withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)"\ud83d\udd28 ").withStyle(ChatFormatting.GOLD)).append((Component)Component.literal((String)quantityString).withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})).append((Component)Component.literal((String)item.getDescription().getString()).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" (").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)String.format("%.2f", complexity)).withStyle(complexityColor)).append((Component)Component.literal((String)")").withStyle(ChatFormatting.DARK_GRAY));
        output.sendInfo(source, (Component)line);
        RecipeNode recipe = recipeOpt.get();
        String childPrefix = prefix + (isLast ? "   " : "\u2502  ");
        if (displayMode == DisplayMode.PLAYER_INSTRUCTION) {
            int neededPlayerAmount = (int)Math.ceil(neededAmount);
            craftOperations = Math.ceil((double)neededPlayerAmount / (double)recipe.getResultCount());
        } else {
            craftOperations = neededAmount / (double)recipe.getResultCount();
        }
        LinkedHashMap ingredientsForOneCraft = new LinkedHashMap();
        for (IngredientSlot slot : recipe.getIngredients()) {
            slot.getVariants().stream().min(Comparator.comparingDouble(engine::getComplexity)).ifPresent(bestVariant -> ingredientsForOneCraft.merge(bestVariant, slot.getCount(), Integer::sum));
        }
        ArrayList ingredientItems = new ArrayList(ingredientsForOneCraft.keySet());
        for (int i = 0; i < ingredientItems.size(); ++i) {
            Item ingredientItem = (Item)ingredientItems.get(i);
            int countForOneCraft = (Integer)ingredientsForOneCraft.get(ingredientItem);
            double totalIngredientNeeded = craftOperations * (double)countForOneCraft;
            TreeCommand.displayNodeRecursive(source, ingredientItem, totalIngredientNeeded, depth + 1, childPrefix, i == ingredientItems.size() - 1, visitedOnPath, engine, depthAnalyzer, baseResources, displayMode, maxDepth, uniqueItems, stats, output);
        }
        visitedOnPath.remove(item);
    }

    private static void displayStatistics(CommandSourceStack source, TreeStats stats, Set<Item> uniqueItems, OutputManager output) {
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udcca ").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)"Tree Statistics").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD})));
        output.sendInfo(source, (Component)Component.literal((String)"    Total Nodes: ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)String.valueOf(stats.totalNodes)).withStyle(ChatFormatting.WHITE)));
        output.sendInfo(source, (Component)Component.literal((String)"    Unique Items: ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)String.valueOf(uniqueItems.size())).withStyle(ChatFormatting.AQUA)));
        output.sendInfo(source, (Component)Component.literal((String)"    Crafting Steps: ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)String.valueOf(stats.craftingSteps)).withStyle(ChatFormatting.GOLD)));
        output.sendInfo(source, (Component)Component.literal((String)"    Base Resources: ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)String.valueOf(stats.baseResourcesCount)).withStyle(ChatFormatting.GREEN)));
        if (stats.cyclesDetected > 0) {
            output.sendInfo(source, (Component)Component.literal((String)"    \u26a0 Cycles Detected: ").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)String.valueOf(stats.cyclesDetected)).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD})));
        }
        output.sendInfo(source, (Component)Component.literal((String)""));
    }

    private static void displayBaseResources(CommandSourceStack source, Map<Item, Double> baseResources, DisplayMode displayMode, AnalysisEngine ignoredEngine, OutputManager output) {
        if (baseResources.isEmpty()) {
            output.sendInfo(source, (Component)Component.literal((String)"  \u26a0 No base resources needed (item might be unobtainable)").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC}));
            return;
        }
        String title = displayMode == DisplayMode.PLAYER_INSTRUCTION ? "Shopping List (What to Gather)" : "Precise Resource Requirements";
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83c\udf92 ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)title).withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD})));
        if (displayMode == DisplayMode.PLAYER_INSTRUCTION) {
            output.sendInfo(source, (Component)Component.literal((String)"    (Rounded up for actual gameplay)").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        } else {
            output.sendInfo(source, (Component)Component.literal((String)"    (Exact fractional amounts)").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        }
        output.sendInfo(source, (Component)Component.literal((String)""));
        baseResources.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).forEach(entry -> {
            Item item = (Item)entry.getKey();
            double amount = (Double)entry.getValue();
            String itemName = item.getDescription().getString();
            if (displayMode == DisplayMode.PLAYER_INSTRUCTION) {
                int amountForPlayer = (int)amount;
                if (amountForPlayer > 0) {
                    int maxStackSize = item.getDefaultInstance().getMaxStackSize();
                    String stackInfo = TreeCommand.getStackVisualization(amountForPlayer, maxStackSize);
                    MutableComponent resourceLine = Component.literal((String)"    \u2713 ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)itemName).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" x").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)String.valueOf(amountForPlayer)).withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})).append((Component)Component.literal((String)(" " + stackInfo)).withStyle(ChatFormatting.DARK_GRAY));
                    output.sendInfo(source, (Component)resourceLine);
                }
            } else {
                MutableComponent resourceLine = Component.literal((String)"    \u2022 ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)itemName).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" x").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)String.format("%.2f", amount)).withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}));
                output.sendInfo(source, (Component)resourceLine);
            }
        });
        output.sendInfo(source, (Component)Component.literal((String)""));
    }

    private static void displayTips(CommandSourceStack source, DisplayMode displayMode, int ignoredMaxDepth, TreeStats stats, OutputManager output, ResourceLocation itemId) {
        MutableComponent tipLine;
        output.sendInfo(source, (Component)Component.literal((String)"  \ud83d\udca1 ").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)"Tips & Options").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})));
        if (displayMode == DisplayMode.PLAYER_INSTRUCTION) {
            String economicCommand = "/complexity tree " + String.valueOf(itemId) + " mode economic";
            tipLine = Component.literal((String)"    \u2022 Try ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)"economic mode").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.UNDERLINE}).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, economicCommand)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to switch to economic view").withStyle(ChatFormatting.AQUA))))).append((Component)Component.literal((String)" for precise calculations").withStyle(ChatFormatting.DARK_GRAY));
            output.sendInfo(source, (Component)tipLine);
        } else {
            String playerCommand = "/complexity tree " + String.valueOf(itemId) + " mode player";
            tipLine = Component.literal((String)"    \u2022 Try ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)"player mode").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.UNDERLINE}).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, playerCommand)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to switch to player view").withStyle(ChatFormatting.GREEN))))).append((Component)Component.literal((String)" for gameplay-friendly view").withStyle(ChatFormatting.DARK_GRAY));
            output.sendInfo(source, (Component)tipLine);
        }
        if (stats.totalNodes > 50) {
            String depthCommand = "/complexity tree " + String.valueOf(itemId) + " depth 5";
            tipLine = Component.literal((String)"    \u2022 Complex tree! Use ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)"limited depth").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, depthCommand)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Limit tree depth for better readability").withStyle(ChatFormatting.GOLD))))).append((Component)Component.literal((String)" for simpler view").withStyle(ChatFormatting.DARK_GRAY));
            output.sendInfo(source, (Component)tipLine);
        }
        if (stats.cyclesDetected > 0) {
            output.sendInfo(source, (Component)Component.literal((String)"    \u26a0 Cyclic dependencies detected!").withStyle(ChatFormatting.RED));
            output.sendInfo(source, (Component)Component.literal((String)"      This may indicate mod conflicts or loop recipes").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        }
        output.sendInfo(source, (Component)Component.literal((String)""));
    }

    private static void calculateBaseResourcesFor(Item item, double neededAmount, Set<Item> visited, AnalysisEngine engine, DepthAnalyzer depthAnalyzer, Map<Item, Double> baseResources, DisplayMode displayMode) {
        double craftOperations;
        if (!visited.add(item)) {
            return;
        }
        Optional<RecipeNode> recipeOpt = depthAnalyzer.getRecipeToFollow(item);
        if (recipeOpt.isEmpty() || recipeOpt.get().isBaseRecipe()) {
            double amountToAdd = displayMode == DisplayMode.PLAYER_INSTRUCTION ? Math.ceil(neededAmount) : neededAmount;
            baseResources.merge(item, amountToAdd, Double::sum);
            visited.remove(item);
            return;
        }
        RecipeNode recipe = recipeOpt.get();
        if (displayMode == DisplayMode.PLAYER_INSTRUCTION) {
            int neededPlayerAmount = (int)Math.ceil(neededAmount);
            craftOperations = Math.ceil((double)neededPlayerAmount / (double)recipe.getResultCount());
        } else {
            craftOperations = neededAmount / (double)recipe.getResultCount();
        }
        for (IngredientSlot slot : recipe.getIngredients()) {
            Item bestVariant = slot.getVariants().stream().min(Comparator.comparingDouble(engine::getComplexity)).orElse(null);
            if (bestVariant == null) continue;
            double totalIngredientNeeded = craftOperations * (double)slot.getCount();
            TreeCommand.calculateBaseResourcesFor(bestVariant, totalIngredientNeeded, visited, engine, depthAnalyzer, baseResources, displayMode);
        }
        visited.remove(item);
    }

    private static ChatFormatting getComplexityColor(double complexity) {
        if (complexity >= 100.0) {
            return ChatFormatting.DARK_RED;
        }
        if (complexity >= 50.0) {
            return ChatFormatting.RED;
        }
        if (complexity >= 30.0) {
            return ChatFormatting.GOLD;
        }
        if (complexity >= 10.0) {
            return ChatFormatting.YELLOW;
        }
        if (complexity >= 5.0) {
            return ChatFormatting.GREEN;
        }
        return ChatFormatting.DARK_GREEN;
    }

    private static String getStackVisualization(int amount, int maxStackSize) {
        if (maxStackSize <= 0) {
            return "";
        }
        int stacks = amount / maxStackSize;
        int remainder = amount % maxStackSize;
        if (stacks == 0) {
            return String.format("(%.0f%%)", (double)amount / (double)maxStackSize * 100.0);
        }
        if (remainder == 0) {
            return String.format("(%d stacks)", stacks);
        }
        return String.format("(%d stacks + %d)", stacks, remainder);
    }

    private static enum DisplayMode {
        PLAYER_INSTRUCTION,
        ECONOMIC_COST;

    }

    private static class TreeStats {
        int totalNodes = 0;
        int craftingSteps = 0;
        int baseResourcesCount = 0;
        int cyclesDetected = 0;

        private TreeStats() {
        }
    }
}

