/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.command.util;

import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class OutputManager {
    private final MinecraftServer server;

    public OutputManager(MinecraftServer server) {
        this.server = server;
    }

    public void sendSuccess(CommandSourceStack source, Component message) {
        source.sendSuccess(() -> message, false);
    }

    public void sendFailure(CommandSourceStack source, Component message) {
        source.sendFailure(message);
    }

    public void sendInfo(CommandSourceStack source, Component message) {
        source.sendSuccess(() -> message, false);
    }

    public void broadcast(Component message) {
        this.server.getPlayerList().broadcastSystemMessage(message, false);
    }

    public void broadcastWarning(Component message) {
        MutableComponent formatted = Component.literal((String)"").append(message).withStyle(ChatFormatting.YELLOW);
        this.server.getPlayerList().broadcastSystemMessage((Component)formatted, false);
    }

    public void broadcastSever(Component message) {
        MutableComponent formatted = Component.literal((String)"").append(message).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
        this.server.getPlayerList().broadcastSystemMessage((Component)formatted, false);
    }

    public void sendToAdmins(Component message) {
        MutableComponent adminMessage = Component.literal((String)"[ADMIN] ").withStyle(ChatFormatting.GRAY).append((Component)message.copy().withStyle(ChatFormatting.ITALIC));
        this.server.getPlayerList().getPlayers().forEach(arg_0 -> OutputManager.lambda$sendToAdmins$2((Component)adminMessage, arg_0));
        this.server.sendSystemMessage((Component)adminMessage);
    }

    private static /* synthetic */ void lambda$sendToAdmins$2(Component adminMessage, ServerPlayer player) {
        if (player.hasPermissions(2)) {
            player.sendSystemMessage(adminMessage);
        }
    }
}

