/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.compat.jei;

import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.complexityanalyzer.ComplexityAnalyzer;
import org.complexityanalyzer.graph.GraphBuilder;
import org.complexityanalyzer.graph.RecipeCategory;
import org.complexityanalyzer.graph.RecipeNode;

public class AdaptiveRecipeConverter {
    private static final Map<Class<?>, RecipeAdapter> LEARNED_ADAPTERS = new ConcurrentHashMap();
    private static final int MAX_RECURSION_DEPTH = 3;
    private static final boolean VERBOSE_DEBUG = false;

    public static List<ItemStack> extractOutputs(Object recipe, Level level) {
        Object actualRecipe = AdaptiveRecipeConverter.unwrapRecipeHolder(recipe);
        Class<?> recipeClass = actualRecipe.getClass();
        RecipeAdapter adapter = LEARNED_ADAPTERS.computeIfAbsent(recipeClass, clazz -> new RecipeAdapter(null, null));
        if (adapter.outputMethod == null) {
            Method outputMethod = AdaptiveRecipeConverter.learnMethod(actualRecipe, true, level);
            adapter = new RecipeAdapter(outputMethod, adapter.inputMethod);
            LEARNED_ADAPTERS.put(recipeClass, adapter);
        }
        if (adapter.outputMethod == null) {
            return new ArrayList<ItemStack>();
        }
        try {
            Object result = AdaptiveRecipeConverter.invokeMethod(adapter.outputMethod, actualRecipe, level);
            List<ItemStack> stacks = AdaptiveRecipeConverter.deepFindItemStacks(result, 0);
            return stacks;
        }
        catch (Exception e) {
            ComplexityAnalyzer.LOGGER.debug("[OUTPUT] Failed to extract outputs: {}", (Object)e.getMessage());
            return new ArrayList<ItemStack>();
        }
    }

    public static RecipeNode convertRecipe(Recipe<?> recipe, Level level) {
        List<ItemStack> outputs = AdaptiveRecipeConverter.extractOutputs(recipe, level);
        if (outputs.isEmpty()) {
            return null;
        }
        ItemStack primaryOutput = outputs.getFirst();
        Item resultItem = primaryOutput.getItem();
        int resultCount = primaryOutput.getCount();
        List<List<ItemStack>> inputGroups = AdaptiveRecipeConverter.extractInputs(recipe, level);
        if (inputGroups.isEmpty()) {
            return null;
        }
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        for (List<ItemStack> group : inputGroups) {
            if (group.isEmpty()) continue;
            Ingredient ingredient = Ingredient.of((ItemStack[])group.toArray(new ItemStack[0]));
            ingredients.add(ingredient);
        }
        RecipeCategory category = GraphBuilder.classifyRecipe(recipe, resultItem, ingredients);
        if (category == RecipeCategory.UNPROCESSABLE) {
            return null;
        }
        RecipeNode.Builder builder = new RecipeNode.Builder(resultItem).resultCount(resultCount).recipeType(recipe.getType()).category(category);
        if (category == RecipeCategory.PRIMARY) {
            RecipeType recipeType = recipe.getType();
            if (recipeType == RecipeType.SMELTING || recipeType == RecipeType.BLASTING) {
                builder.priority(2000);
            } else {
                builder.priority(900);
            }
        } else if (category == RecipeCategory.STORAGE_COMPRESSION || category == RecipeCategory.STORAGE_DECOMPRESSION) {
            builder.priority(100);
        }
        for (List list : inputGroups) {
            if (list.isEmpty()) continue;
            List<Item> items = list.stream().map(ItemStack::getItem).distinct().toList();
            int count = ((ItemStack)list.getFirst()).getCount();
            builder.addIngredient(items, count);
        }
        RecipeNode node = builder.build();
        if (node.getIngredients().isEmpty()) {
            return null;
        }
        return node;
    }

    public static List<List<ItemStack>> extractInputs(Object recipe, Level level) {
        Object actualRecipe = AdaptiveRecipeConverter.unwrapRecipeHolder(recipe);
        Class<?> recipeClass = actualRecipe.getClass();
        RecipeAdapter adapter = LEARNED_ADAPTERS.computeIfAbsent(recipeClass, clazz -> new RecipeAdapter(null, null));
        if (adapter.inputMethod == null) {
            Method inputMethod = AdaptiveRecipeConverter.learnMethod(actualRecipe, false, level);
            adapter = new RecipeAdapter(adapter.outputMethod, inputMethod);
            LEARNED_ADAPTERS.put(recipeClass, adapter);
        }
        if (adapter.inputMethod == null) {
            return new ArrayList<List<ItemStack>>();
        }
        try {
            Object result = AdaptiveRecipeConverter.invokeMethod(adapter.inputMethod, actualRecipe, level);
            List<List<ItemStack>> inputs = AdaptiveRecipeConverter.deepFindItemStackLists(result, 0);
            return inputs;
        }
        catch (Exception e) {
            ComplexityAnalyzer.LOGGER.error("[INPUT] Failed to extract inputs for recipe type {}: {}", new Object[]{recipeClass.getSimpleName(), e.getMessage(), e});
            return new ArrayList<List<ItemStack>>();
        }
    }

    private static Object invokeMethod(Method method, Object target, Level level) throws Exception {
        if (method.getParameterCount() == 0) {
            return method.invoke(target, new Object[0]);
        }
        if (method.getParameterCount() == 1) {
            Class<?> paramType = method.getParameterTypes()[0];
            if (paramType.getSimpleName().contains("RegistryAccess") || paramType.getName().contains("RegistryAccess")) {
                return method.invoke(target, level.registryAccess());
            }
            return method.invoke(target, new Object[]{null});
        }
        return null;
    }

    private static Object unwrapRecipeHolder(Object obj) {
        if (obj == null) {
            return null;
        }
        String className = obj.getClass().getSimpleName();
        if (className.equals("RecipeHolder")) {
            try {
                Method valueMethod = obj.getClass().getMethod("value", new Class[0]);
                Object innerRecipe = valueMethod.invoke(obj, new Object[0]);
                if (innerRecipe != null) {
                    return innerRecipe;
                }
            }
            catch (Exception e) {
                ComplexityAnalyzer.LOGGER.debug("Failed to unwrap RecipeHolder: {}", (Object)e.getMessage());
            }
        }
        return obj;
    }

    private static Method learnMethod(Object recipe, boolean isOutput, Level level) {
        String[] candidateMethods;
        String[] stringArray;
        if (isOutput) {
            String[] stringArray2 = new String[8];
            stringArray2[0] = "getOutputs";
            stringArray2[1] = "getOutput";
            stringArray2[2] = "getResults";
            stringArray2[3] = "getResult";
            stringArray2[4] = "getResultItem";
            stringArray2[5] = "output";
            stringArray2[6] = "getOutputRaw";
            stringArray = stringArray2;
            stringArray2[7] = "getOutputDefinition";
        } else {
            String[] stringArray3 = new String[6];
            stringArray3[0] = "getInputs";
            stringArray3[1] = "getInput";
            stringArray3[2] = "getIngredients";
            stringArray3[3] = "getIngredient";
            stringArray3[4] = "inputs";
            stringArray = stringArray3;
            stringArray3[5] = "getInputRaw";
        }
        for (String methodName : candidateMethods = stringArray) {
            try {
                List<List<ItemStack>> inputs;
                List<ItemStack> stacks;
                Object result;
                Method method = AdaptiveRecipeConverter.findAnyMethod(recipe.getClass(), methodName);
                if (method == null) continue;
                method.setAccessible(true);
                try {
                    result = AdaptiveRecipeConverter.invokeMethod(method, recipe, level);
                }
                catch (Exception e) {
                    continue;
                }
                if (result == null || !(isOutput ? !(stacks = AdaptiveRecipeConverter.deepFindItemStacks(result, 0)).isEmpty() : !(inputs = AdaptiveRecipeConverter.deepFindItemStackLists(result, 0)).isEmpty())) continue;
                return method;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static List<ItemStack> deepFindItemStacks(Object obj, int depth) {
        if (obj == null || depth > 3) {
            return new ArrayList<ItemStack>();
        }
        Objects.requireNonNull(obj);
        Method[] methodArray = obj;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemStack.class, Ingredient.class, Collection.class}, (Object)methodArray, n)) {
            case 0: {
                ItemStack stack = (ItemStack)methodArray;
                return stack.isEmpty() ? new ArrayList() : List.of(stack);
            }
            case 1: {
                Ingredient ingredient = (Ingredient)methodArray;
                ItemStack[] items = ingredient.getItems();
                ArrayList<ItemStack> result = new ArrayList<ItemStack>();
                for (ItemStack stack : items) {
                    if (stack.isEmpty()) continue;
                    result.add(stack);
                }
                return result;
            }
            case 2: {
                Collection coll = (Collection)methodArray;
                ArrayList<ItemStack> result = new ArrayList<ItemStack>();
                for (Object item : coll) {
                    result.addAll(AdaptiveRecipeConverter.deepFindItemStacks(item, depth + 1));
                }
                return result;
            }
        }
        if (obj.getClass().isArray()) {
            ArrayList<ItemStack> result = new ArrayList<ItemStack>();
            for (Object item : (Object[])obj) {
                result.addAll(AdaptiveRecipeConverter.deepFindItemStacks(item, depth + 1));
            }
            return result;
        }
        for (Method method : obj.getClass().getMethods()) {
            String name = method.getName();
            if (method.getParameterCount() != 0 || !name.startsWith("get") && !name.startsWith("as") && !name.startsWith("to") && !name.equals("stack") && !name.equals("item") || name.equals("getClass") || name.equals("toString") || name.equals("getBytes") || name.startsWith("toLowerCase") || name.startsWith("toUpperCase") || name.startsWith("toCharArray")) continue;
            try {
                method.setAccessible(true);
                Object inner = method.invoke((Object)obj, new Object[0]);
                List<ItemStack> found = AdaptiveRecipeConverter.deepFindItemStacks(inner, depth + 1);
                if (found.isEmpty()) continue;
                return found;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ArrayList<ItemStack>();
    }

    private static List<List<ItemStack>> deepFindItemStackLists(Object obj, int depth) {
        if (obj == null || depth > 3) {
            return new ArrayList<List<ItemStack>>();
        }
        if (obj instanceof Ingredient) {
            Ingredient ingredient = (Ingredient)obj;
            ItemStack[] items = ingredient.getItems();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ItemStack stack : items) {
                if (stack.isEmpty()) continue;
                stacks.add(stack);
            }
            return stacks.isEmpty() ? new ArrayList() : List.of(stacks);
        }
        if (obj instanceof Collection) {
            Collection coll = (Collection)obj;
            if (coll.isEmpty()) {
                return new ArrayList<List<ItemStack>>();
            }
            Object first = coll.iterator().next();
            if (first instanceof Ingredient) {
                ArrayList<List<ItemStack>> result = new ArrayList<List<ItemStack>>();
                for (Object item : coll) {
                    if (!(item instanceof Ingredient)) continue;
                    Ingredient ingredient = (Ingredient)item;
                    ItemStack[] items = ingredient.getItems();
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    for (ItemStack stack : items) {
                        if (stack.isEmpty()) continue;
                        stacks.add(stack);
                    }
                    if (stacks.isEmpty()) continue;
                    result.add(stacks);
                }
                return result;
            }
            if (first instanceof ItemStack) {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (Object item : coll) {
                    ItemStack stack;
                    if (!(item instanceof ItemStack) || (stack = (ItemStack)item).isEmpty()) continue;
                    stacks.add(stack);
                }
                return stacks.isEmpty() ? new ArrayList() : List.of(stacks);
            }
            if (first instanceof Collection) {
                ArrayList<List<ItemStack>> result = new ArrayList<List<ItemStack>>();
                for (Object inner : coll) {
                    List<List<ItemStack>> innerLists = AdaptiveRecipeConverter.deepFindItemStackLists(inner, depth + 1);
                    result.addAll(innerLists);
                }
                return result;
            }
            ArrayList<ItemStack> extracted = new ArrayList<ItemStack>();
            for (Object item : coll) {
                List<ItemStack> stacks = AdaptiveRecipeConverter.deepFindItemStacks(item, depth + 1);
                extracted.addAll(stacks);
            }
            if (!extracted.isEmpty()) {
                return List.of(extracted);
            }
        }
        for (Method method : obj.getClass().getMethods()) {
            String name = method.getName();
            if (method.getParameterCount() != 0 || !name.startsWith("get") && !name.startsWith("as") || name.equals("getClass")) continue;
            try {
                method.setAccessible(true);
                Object inner = method.invoke(obj, new Object[0]);
                List<List<ItemStack>> found = AdaptiveRecipeConverter.deepFindItemStackLists(inner, depth + 1);
                if (found.isEmpty()) continue;
                return found;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ArrayList<List<ItemStack>>();
    }

    private static Method findAnyMethod(Class<?> clazz, String name) {
        try {
            return clazz.getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            for (Method m : clazz.getMethods()) {
                if (!m.getName().equals(name)) continue;
                return m;
            }
            return null;
        }
    }

    static class RecipeAdapter {
        final Method outputMethod;
        final Method inputMethod;

        RecipeAdapter(Method outputMethod, Method inputMethod) {
            this.outputMethod = outputMethod;
            this.inputMethod = inputMethod;
        }
    }
}

