/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.compat.jei;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.complexityanalyzer.ComplexityAnalyzer;
import org.complexityanalyzer.compat.jei.AdaptiveRecipeConverter;
import org.complexityanalyzer.graph.RecipeCategory;
import org.complexityanalyzer.graph.RecipeGraph;
import org.complexityanalyzer.graph.RecipeNode;

public class DirectRecipeExtractor {
    private static final Set<String> VANILLA_RECIPE_TYPES = Set.of("minecraft:crafting", "minecraft:smelting", "minecraft:blasting", "minecraft:smoking", "minecraft:campfire_cooking", "minecraft:stonecutting", "minecraft:smithing");

    public static void extractCustomRecipes(RecipeGraph graph, Level level) {
        RecipeManager recipeManager = level.getRecipeManager();
        ComplexityAnalyzer.LOGGER.info("Extracting custom recipes directly from RecipeManager...");
        HashSet<RecipeType> recipeTypes = new HashSet<RecipeType>();
        for (RecipeHolder holder : recipeManager.getRecipes()) {
            recipeTypes.add(holder.value().getType());
        }
        int totalImported = 0;
        int customTypes = 0;
        LinkedHashMap<String, Integer> recipeStats = new LinkedHashMap<String, Integer>();
        EnumMap<RecipeCategory, Integer> categoryStats = new EnumMap<RecipeCategory, Integer>(RecipeCategory.class);
        for (RecipeType recipeType : recipeTypes) {
            String typeIdString;
            ResourceLocation typeId = BuiltInRegistries.RECIPE_TYPE.getKey((Object)recipeType);
            if (typeId == null || VANILLA_RECIPE_TYPES.contains(typeIdString = typeId.toString())) continue;
            try {
                List<RecipeNode> converted = DirectRecipeExtractor.extractRecipesOfType(recipeManager, recipeType, level);
                for (RecipeNode node : converted) {
                    graph.addRecipe(node);
                    categoryStats.merge(node.getCategory(), 1, Integer::sum);
                }
                if (converted.isEmpty()) continue;
                recipeStats.put(typeIdString, converted.size());
                totalImported += converted.size();
                ++customTypes;
            }
            catch (Exception e) {
                ComplexityAnalyzer.LOGGER.warn("Failed to process recipe type {}: {}", (Object)typeIdString, (Object)e.getMessage());
            }
        }
        ComplexityAnalyzer.LOGGER.info("Direct extraction complete: {} custom recipe types, {} recipes total", (Object)customTypes, (Object)totalImported);
        if (!recipeStats.isEmpty()) {
            DirectRecipeExtractor.logRecipeStats("Recipe type breakdown", recipeStats);
        }
        if (!categoryStats.isEmpty()) {
            DirectRecipeExtractor.logRecipeStats("Category classification", categoryStats);
        }
    }

    private static void logRecipeStats(String title, Map<?, Integer> stats) {
        ComplexityAnalyzer.LOGGER.info("{}:", (Object)title);
        stats.entrySet().stream().sorted((a, b) -> Integer.compare((Integer)b.getValue(), (Integer)a.getValue())).forEach(entry -> ComplexityAnalyzer.LOGGER.info("  - {}: {} recipes", entry.getKey(), entry.getValue()));
    }

    private static List<RecipeNode> extractRecipesOfType(RecipeManager recipeManager, RecipeType<?> recipeType, Level level) {
        ArrayList<RecipeNode> result = new ArrayList<RecipeNode>();
        try {
            Method method = RecipeManager.class.getMethod("getAllRecipesFor", RecipeType.class);
            Collection recipes = (Collection)method.invoke((Object)recipeManager, recipeType);
            for (RecipeHolder holder : recipes) {
                try {
                    Recipe recipe = holder.value();
                    RecipeNode node = AdaptiveRecipeConverter.convertRecipe(recipe, level);
                    if (node == null) continue;
                    result.add(node);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            ComplexityAnalyzer.LOGGER.debug("Error extracting recipes: {}", (Object)e.getMessage());
        }
        return result;
    }
}

