/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.compat.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.complexityanalyzer.ComplexityAnalyzer;
import org.complexityanalyzer.compat.jei.AdaptiveRecipeConverter;
import org.complexityanalyzer.graph.RecipeCategory;
import org.complexityanalyzer.graph.RecipeNode;

public class JeiRecipeConverter {
    public static List<RecipeNode> convertAll(Map<RecipeType<?>, List<?>> recipesByType, Level level) {
        ArrayList<RecipeNode> result = new ArrayList<RecipeNode>();
        for (Map.Entry<RecipeType<?>, List<?>> entry : recipesByType.entrySet()) {
            RecipeType<?> type = entry.getKey();
            List<?> recipes = entry.getValue();
            int failed = 0;
            for (Object recipe : recipes) {
                try {
                    RecipeNode node = JeiRecipeConverter.convert(recipe, level);
                    if (node != null) {
                        result.add(node);
                        continue;
                    }
                    if (++failed > 3) continue;
                    String className = recipe.getClass().getSimpleName();
                    ComplexityAnalyzer.LOGGER.debug("    Failed to convert recipe: {} (type: {})", (Object)className, (Object)type.getUid());
                }
                catch (Exception e) {
                    if (++failed > 3) continue;
                    ComplexityAnalyzer.LOGGER.debug("    Exception converting recipe: {}", (Object)e.getMessage());
                }
            }
        }
        return result;
    }

    private static RecipeNode convert(Object recipe, Level level) {
        List<ItemStack> outputs = AdaptiveRecipeConverter.extractOutputs(recipe, level);
        if (outputs.isEmpty()) {
            ComplexityAnalyzer.LOGGER.debug("      No outputs found for {}", (Object)recipe.getClass().getSimpleName());
            return null;
        }
        ItemStack primaryOutput = outputs.getFirst();
        Item resultItem = primaryOutput.getItem();
        int resultCount = primaryOutput.getCount();
        RecipeNode.Builder builder = new RecipeNode.Builder(resultItem).resultCount(resultCount).category(RecipeCategory.JEI_IMPORTED);
        builder.priority(900);
        List<List<ItemStack>> inputs = AdaptiveRecipeConverter.extractInputs(recipe, level);
        if (inputs.isEmpty()) {
            ComplexityAnalyzer.LOGGER.debug("      No inputs found for {} -> {}", (Object)recipe.getClass().getSimpleName(), (Object)resultItem);
        }
        for (List<ItemStack> inputVariants : inputs) {
            if (inputVariants.isEmpty()) continue;
            List<Item> items = inputVariants.stream().map(ItemStack::getItem).distinct().toList();
            int count = inputVariants.getFirst().getCount();
            builder.addIngredient(items, count);
        }
        RecipeNode node = builder.build();
        if (node.getIngredients().isEmpty()) {
            ComplexityAnalyzer.LOGGER.debug("      Recipe has no ingredients after conversion: {}", (Object)recipe.getClass().getSimpleName());
            return null;
        }
        return node;
    }
}

