/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.config;

import java.util.Collections;
import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ComplexityConfig {
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.IntValue MAX_DEPTH;
    public static final ModConfigSpec.IntValue MAX_RECURSION_DEPTH;
    public static final ModConfigSpec.IntValue MAX_INGREDIENT_VARIANTS;
    public static final ModConfigSpec.IntValue MAX_ITERATIONS;
    public static final ModConfigSpec.IntValue CYCLE_DETECTION_DEPTH;
    public static final ModConfigSpec.DoubleValue BASE_COMPLEXITY;
    public static final ModConfigSpec.DoubleValue DEPTH_MULTIPLIER;
    public static final ModConfigSpec.DoubleValue INGREDIENT_MULTIPLIER;
    public static final ModConfigSpec.DoubleValue MOB_DIFFICULTY_SCALER;
    public static final ModConfigSpec.DoubleValue BOSS_RARITY_MULTIPLIER;
    public static final ModConfigSpec.DoubleValue TIME_COST_MULTIPLIER;
    public static final ModConfigSpec.DoubleValue BASE_ACTION_COST;
    public static final ModConfigSpec.DoubleValue CONVERGENCE_THRESHOLD;
    public static final ModConfigSpec.DoubleValue SOURCE_BIAS_THRESHOLD;
    public static final ModConfigSpec.BooleanValue ENABLE_JEI_INTEGRATION;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> JEI_PLUGIN_BLACKLIST;

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.push("general");
        builder.push("jei_integration");
        ENABLE_JEI_INTEGRATION = builder.comment("Enable automatic recipe extraction from JEI plugins of other mods").define("enableJeiIntegration", true);
        JEI_PLUGIN_BLACKLIST = builder.comment("List of mod IDs whose JEI plugins should be ignored").defineList("jeiPluginBlacklist", Collections.emptyList(), () -> "", obj -> obj instanceof String);
        builder.pop();
        builder.push("limits");
        MAX_DEPTH = builder.defineInRange("maxDepth", 50, 1, 1000);
        MAX_RECURSION_DEPTH = builder.defineInRange("maxRecursionDepth", 100, 1, 1000);
        MAX_INGREDIENT_VARIANTS = builder.defineInRange("maxIngredientVariants", 20, 1, 100);
        MAX_ITERATIONS = builder.defineInRange("maxIterations", 1000, 10, 10000);
        CYCLE_DETECTION_DEPTH = builder.defineInRange("cycleDetectionDepth", 100, 10, 500);
        builder.pop();
        builder.push("crafting");
        BASE_COMPLEXITY = builder.defineInRange("baseComplexity", 1.0, 0.1, 1000.0);
        DEPTH_MULTIPLIER = builder.defineInRange("depthMultiplier", 2.0, 0.1, 100.0);
        INGREDIENT_MULTIPLIER = builder.defineInRange("ingredientMultiplier", 0.5, 0.0, 10.0);
        builder.pop();
        builder.push("mob_drops");
        MOB_DIFFICULTY_SCALER = builder.defineInRange("mobDifficultyScaler", 0.1, 0.0, 100.0);
        BOSS_RARITY_MULTIPLIER = builder.defineInRange("bossRarityMultiplier", 20.0, 1.0, 500.0);
        builder.pop();
        builder.push("passive_generation");
        TIME_COST_MULTIPLIER = builder.defineInRange("timeCostMultiplier", 0.01, 0.0, 1.0);
        BASE_ACTION_COST = builder.defineInRange("baseActionCost", 10.0, 0.0, 1000.0);
        builder.pop();
        builder.push("solver_internals");
        CONVERGENCE_THRESHOLD = builder.defineInRange("convergenceThreshold", 1.0E-9, 1.0E-12, 0.001);
        SOURCE_BIAS_THRESHOLD = builder.defineInRange("sourceBiasThreshold", 1.01, 1.0, 2.0);
        builder.pop();
        builder.pop();
        SPEC = builder.build();
    }
}

