/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.complexityanalyzer.ComplexityAnalyzer;
import org.complexityanalyzer.analyzer.ComplexityCalculator;
import org.complexityanalyzer.analyzer.DepthAnalyzer;
import org.complexityanalyzer.analyzer.SourcePathAnalyzer;
import org.complexityanalyzer.analyzer.resource.IResourceSource;
import org.complexityanalyzer.analyzer.resource.SourceManager;
import org.complexityanalyzer.analyzer.resource.data.BaseResourceData;
import org.complexityanalyzer.analyzer.resource.providers.BlockPropertyProvider;
import org.complexityanalyzer.analyzer.resource.providers.DimensionRarityAnalyzer;
import org.complexityanalyzer.analyzer.resource.providers.MobPropertyProvider;
import org.complexityanalyzer.analyzer.resource.providers.MobRarityCalculator;
import org.complexityanalyzer.analyzer.resource.providers.TheoreticalDistributionProvider;
import org.complexityanalyzer.analyzer.resource.sources.BlockBreakAsRecipeSource;
import org.complexityanalyzer.analyzer.resource.sources.EmpiricalBlockSource;
import org.complexityanalyzer.analyzer.resource.sources.HardcodedSourcesProvider;
import org.complexityanalyzer.analyzer.resource.sources.MobDropSource;
import org.complexityanalyzer.analyzer.resource.sources.PassiveProductionSource;
import org.complexityanalyzer.analyzer.resource.sources.TheoreticalBlockSource;
import org.complexityanalyzer.analyzer.resource.sources.UniversalLootSource;
import org.complexityanalyzer.analyzer.resource.sources.VillagerTradeSource;
import org.complexityanalyzer.analyzer.solver.IterativeSolver;
import org.complexityanalyzer.analyzer.solver.SolverResult;
import org.complexityanalyzer.cache.ComplexityCache;
import org.complexityanalyzer.data.ItemComplexity;
import org.complexityanalyzer.geoscan.GeoAnalysisManager;
import org.complexityanalyzer.geoscan.GeoDatabase;
import org.complexityanalyzer.graph.GraphBuilder;
import org.complexityanalyzer.graph.RecipeGraph;

public class AnalysisEngine {
    private final AtomicReference<State> currentState = new AtomicReference<State>(State.IDLE);
    private final AtomicReference<ExecutorService> analysisExecutor = new AtomicReference<Object>(null);
    private final AtomicReference<Future<?>> currentAnalysisTask = new AtomicReference<Object>(null);
    private final AtomicBoolean analysisCancelled = new AtomicBoolean(false);
    private final AtomicBoolean isReloading = new AtomicBoolean(false);
    private final ReentrantLock stateLock = new ReentrantLock();
    private final ReentrantLock geoManagerLock = new ReentrantLock();
    private final Object executorLock = new Object();
    private final ComplexityCache complexityCache = new ComplexityCache();
    private volatile RecipeGraph graph;
    private volatile SourceManager sourceManager;
    private volatile ComplexityCalculator calculator;
    private volatile DepthAnalyzer depthAnalyzer;
    private volatile GeoDatabase geoDatabase;
    private volatile BlockPropertyProvider blockPropProvider;
    private volatile MobPropertyProvider mobPropProvider;
    private volatile GeoAnalysisManager geoManager;
    private volatile TheoreticalDistributionProvider theoreticalDistProvider;
    private volatile MobRarityCalculator mobRarityCalculator;

    public static AnalysisEngine getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private AnalysisEngine() {
    }

    public void initializeAsync(Level level, Runnable onComplete) {
        if (!this.currentState.compareAndSet(State.IDLE, State.ANALYZING)) {
            State current = this.currentState.get();
            if (current == State.READY && this.isReady()) {
                this.safeRunCallback(onComplete);
            }
            return;
        }
        if (!(level instanceof ServerLevel)) {
            this.currentState.set(State.FAILED);
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ExecutorService executor = this.ensureExecutorAvailable();
        ComplexityAnalyzer.LOGGER.info("Starting background analysis...");
        Future<?> task = executor.submit(() -> {
            block9: {
                try {
                    this.analysisCancelled.set(false);
                    if (this.isInterrupted()) {
                        this.restoreIdleState();
                        return;
                    }
                    ComplexityAnalyzer.LOGGER.info("Building recipe graph...");
                    this.graph = GraphBuilder.buildFromWorld(level);
                    ComplexityAnalyzer.LOGGER.info("=== [State: ANALYZING] Starting FAST initial analysis ===");
                    if (this.isInterrupted()) {
                        this.restoreIdleState();
                        return;
                    }
                    this.initializeCoreProviders(serverLevel);
                    if (this.isInterrupted()) {
                        this.restoreIdleState();
                        return;
                    }
                    this.initializeResourceSources(serverLevel);
                    if (this.isInterrupted()) {
                        this.restoreIdleState();
                        return;
                    }
                    this.recalculateComplexity();
                    if (this.isInterrupted()) {
                        this.restoreIdleState();
                        return;
                    }
                    ComplexityAnalyzer.LOGGER.info("=== [State: READY] Analysis complete. Mod is operational. ===");
                    this.currentState.set(State.READY);
                    try {
                        this.createGeoManager(serverLevel.getServer());
                        Optional<GeoAnalysisManager> geoMgr = this.getGeoManager();
                        geoMgr.ifPresent(GeoAnalysisManager::startInitialScanIfNeeded);
                    }
                    catch (Exception e) {
                        ComplexityAnalyzer.LOGGER.error("Failed to create or start GeoAnalysisManager", (Throwable)e);
                    }
                    this.safeRunCallback(onComplete);
                }
                catch (Exception e) {
                    if (this.isInterrupted()) break block9;
                    ComplexityAnalyzer.LOGGER.error("Critical error during analysis initialization", (Throwable)e);
                    this.currentState.set(State.FAILED);
                }
            }
        });
        this.currentAnalysisTask.set(task);
    }

    private boolean isInterrupted() {
        return this.analysisCancelled.get() || Thread.currentThread().isInterrupted();
    }

    private static ExecutorService createAnalysisExecutor() {
        return Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r, "Complexity-Analysis-Thread");
            t.setDaemon(true);
            return t;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService ensureExecutorAvailable() {
        ExecutorService current = this.analysisExecutor.get();
        if (current != null && !current.isShutdown()) {
            return current;
        }
        Object object = this.executorLock;
        synchronized (object) {
            current = this.analysisExecutor.get();
            if (current != null && !current.isShutdown()) {
                return current;
            }
            ComplexityAnalyzer.LOGGER.info("Creating new analysis thread pool.");
            ExecutorService newExecutor = AnalysisEngine.createAnalysisExecutor();
            this.analysisExecutor.set(newExecutor);
            return newExecutor;
        }
    }

    private void safeRunCallback(Runnable callback) {
        if (callback == null) {
            return;
        }
        try {
            callback.run();
        }
        catch (Exception e) {
            ComplexityAnalyzer.LOGGER.error("Error in completion callback", (Throwable)e);
        }
    }

    private void restoreIdleState() {
        this.clearDataInternal();
        this.currentState.set(State.IDLE);
    }

    private void initializeCoreProviders(ServerLevel serverLevel) {
        this.blockPropProvider = new BlockPropertyProvider();
        this.blockPropProvider.initialize();
        this.mobPropProvider = new MobPropertyProvider();
        this.mobPropProvider.initialize();
        DimensionRarityAnalyzer dimensionAnalyzer = new DimensionRarityAnalyzer((Level)serverLevel);
        this.mobRarityCalculator = new MobRarityCalculator(dimensionAnalyzer);
        this.mobPropProvider.setRarityCalculator(this.mobRarityCalculator);
        this.geoDatabase = new GeoDatabase(serverLevel.getServer());
        this.geoDatabase.loadAll();
        this.theoreticalDistProvider = new TheoreticalDistributionProvider();
        this.theoreticalDistProvider.initialize((Level)serverLevel);
    }

    private void initializeResourceSources(ServerLevel serverLevel) {
        ArrayList<IResourceSource> initialSources = new ArrayList<IResourceSource>();
        GeoDatabase geoDB = this.geoDatabase;
        BlockPropertyProvider blockProp = this.blockPropProvider;
        if (geoDB != null && geoDB.isLoaded()) {
            initialSources.add(new EmpiricalBlockSource(blockProp, geoDB));
            ComplexityAnalyzer.LOGGER.info("GeoDatabase loaded, skipping theoretical resources.");
        } else {
            initialSources.add(new TheoreticalBlockSource(blockProp, this.theoreticalDistProvider));
        }
        initialSources.add(new UniversalLootSource());
        initialSources.add(new MobDropSource(this.mobPropProvider, (Level)serverLevel));
        initialSources.add(new BlockBreakAsRecipeSource());
        initialSources.add(new VillagerTradeSource());
        initialSources.add(new PassiveProductionSource());
        initialSources.add(new HardcodedSourcesProvider());
        this.sourceManager = new SourceManager(initialSources);
        ComplexityAnalyzer.LOGGER.info("Resource sources configured. Initializing all...");
        this.sourceManager.initialize((Level)serverLevel);
        ComplexityAnalyzer.LOGGER.info("All resource sources initialized.");
    }

    public void recalculateComplexity() {
        RecipeGraph currentGraph = this.graph;
        SourceManager currentSourceManager = this.sourceManager;
        if (this.isInterrupted() || currentGraph == null || currentSourceManager == null) {
            return;
        }
        ComplexityAnalyzer.LOGGER.info("Recalculating all complexity data...");
        this.complexityCache.clear();
        SourcePathAnalyzer pathAnalyzer = new SourcePathAnalyzer(currentGraph, currentSourceManager);
        pathAnalyzer.findItemsWithBasePath();
        if (this.isInterrupted()) {
            return;
        }
        IterativeSolver solver = new IterativeSolver(currentGraph, currentSourceManager);
        SolverResult solverResult = solver.solve();
        if (this.isInterrupted()) {
            ComplexityAnalyzer.LOGGER.info("Analysis was cancelled after solver finished.");
            return;
        }
        this.depthAnalyzer = new DepthAnalyzer(currentGraph, currentSourceManager);
        this.depthAnalyzer.setOptimalRecipes(solverResult.optimalRecipes());
        this.calculator = new ComplexityCalculator(currentGraph, this.depthAnalyzer, solverResult, currentSourceManager);
        ComplexityAnalyzer.LOGGER.info("All systems refreshed with new data.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGeoScanFinished() {
        if (!this.isReady()) {
            ComplexityAnalyzer.LOGGER.warn("onGeoScanFinished called while engine not ready. Ignoring.");
            return;
        }
        this.stateLock.lock();
        try {
            if (!this.isReady()) {
                return;
            }
            SourceManager currentSourceManager = this.sourceManager;
            RecipeGraph currentGraph = this.graph;
            GeoDatabase geoDB = this.geoDatabase;
            BlockPropertyProvider blockProp = this.blockPropProvider;
            if (currentSourceManager == null || currentGraph == null) {
                return;
            }
            ComplexityAnalyzer.LOGGER.info("Geo-scan finished. Updating resource sources...");
            currentSourceManager.removeSourcesByType(TheoreticalBlockSource.class);
            currentSourceManager.removeSourcesByType(EmpiricalBlockSource.class);
            if (geoDB != null && blockProp != null) {
                EmpiricalBlockSource empiricalSource = new EmpiricalBlockSource(blockProp, geoDB);
                currentSourceManager.addSourceAndRefresh(empiricalSource);
            }
            this.recalculateComplexity();
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public ComplexityCache getComplexityCache() {
        return this.complexityCache;
    }

    private void clearDataInternal() {
        this.graph = null;
        this.sourceManager = null;
        this.calculator = null;
        this.depthAnalyzer = null;
        this.complexityCache.clear();
    }

    public void createGeoManager(MinecraftServer server) {
        this.geoManagerLock.lock();
        try {
            if (this.geoManager != null) {
                this.geoManager.shutdown();
            }
            if (this.geoDatabase != null) {
                this.geoManager = new GeoAnalysisManager(server, this.geoDatabase, this);
            }
        }
        finally {
            this.geoManagerLock.unlock();
        }
    }

    public Executor getBackgroundExecutor() {
        return this.analysisExecutor.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearGeoDatabase() {
        if (!this.isReady()) {
            ComplexityAnalyzer.LOGGER.warn("Cannot clear GeoDatabase: engine not ready. Current state: {}", (Object)this.currentState.get());
            return;
        }
        this.stateLock.lock();
        try {
            GeoDatabase geoDB = this.geoDatabase;
            if (geoDB != null) {
                geoDB.clear();
                ComplexityAnalyzer.LOGGER.info("GeoDatabase cleared. Reverting to theoretical sources...");
            }
            SourceManager currentSourceManager = this.sourceManager;
            BlockPropertyProvider blockProp = this.blockPropProvider;
            TheoreticalDistributionProvider theoreticalDist = this.theoreticalDistProvider;
            if (currentSourceManager != null && blockProp != null && theoreticalDist != null) {
                currentSourceManager.removeSourcesByType(EmpiricalBlockSource.class);
                TheoreticalBlockSource theoreticalSource = new TheoreticalBlockSource(blockProp, theoreticalDist);
                currentSourceManager.addSourceAndRefresh(theoreticalSource);
                ComplexityAnalyzer.LOGGER.info("Theoretical block sources restored.");
                this.recalculateComplexity();
            } else {
                ComplexityAnalyzer.LOGGER.warn("Cannot revert to theoretical sources - providers not initialized.");
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public boolean isReady() {
        return this.currentState.get() == State.READY;
    }

    public RecipeGraph getGraph() {
        return this.graph;
    }

    public Optional<SourceManager> getSourceManager() {
        return Optional.ofNullable(this.sourceManager);
    }

    public State getCurrentState() {
        return this.currentState.get();
    }

    public Optional<ItemComplexity> getComplexityResult(Item item) {
        ComplexityCalculator calc = this.calculator;
        if (calc == null || !this.isReady()) {
            return Optional.empty();
        }
        return calc.getOrCalculateComplexity(item);
    }

    public Optional<DepthAnalyzer> getDepthAnalyzer() {
        return Optional.ofNullable(this.depthAnalyzer);
    }

    public double getComplexity(Item item) {
        return this.getComplexityResult(item).map(ItemComplexity::getComplexity).orElse(-1.0);
    }

    public int getUsageCount(Item item) {
        RecipeGraph currentGraph = this.graph;
        return currentGraph != null && this.isReady() ? currentGraph.getUsageCount(item) : 0;
    }

    public boolean hasRecipe(Item item) {
        RecipeGraph currentGraph = this.graph;
        return currentGraph != null && this.isReady() && currentGraph.hasRecipe(item);
    }

    public List<BaseResourceData> findAllSourcesForItem(Item item) {
        SourceManager sm = this.sourceManager;
        return sm != null && this.isReady() ? sm.findAllSources(item) : new ArrayList<BaseResourceData>();
    }

    public Optional<BaseResourceData> getBaseResourceData(Item item) {
        SourceManager sm = this.sourceManager;
        return sm != null && this.isReady() ? sm.analyze(item) : Optional.empty();
    }

    public void reloadAsync(Level level) {
        if (this.isReloading.getAndSet(true)) {
            ComplexityAnalyzer.LOGGER.warn("Reload is already in progress. Ignoring duplicate request.");
            return;
        }
        ComplexityAnalyzer.LOGGER.info("Reload requested. Scheduling full restart...");
        Thread reloadThread = new Thread(() -> {
            try {
                this.shutdown();
                if (Thread.currentThread().isInterrupted()) {
                    ComplexityAnalyzer.LOGGER.info("Reload cancelled due to server shutdown.");
                    return;
                }
                this.clearAllCaches();
                this.initializeAsync(level, () -> ComplexityAnalyzer.LOGGER.info("Reload complete."));
            }
            catch (Exception e) {
                ComplexityAnalyzer.LOGGER.error("Error during reload", (Throwable)e);
            }
            finally {
                this.isReloading.set(false);
            }
        }, "Complexity-Reload-Thread");
        reloadThread.setDaemon(true);
        reloadThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ComplexityAnalyzer.LOGGER.info("Shutdown requested for AnalysisEngine.");
        Future currentTask = this.currentAnalysisTask.getAndSet(null);
        if (currentTask != null && !currentTask.isDone()) {
            this.analysisCancelled.set(true);
            currentTask.cancel(true);
        }
        this.geoManagerLock.lock();
        try {
            GeoAnalysisManager geoMgr = this.geoManager;
            if (geoMgr != null) {
                geoMgr.shutdown();
                this.geoManager = null;
            }
        }
        finally {
            this.geoManagerLock.unlock();
        }
        ExecutorService executor = this.analysisExecutor.getAndSet(null);
        if (executor != null && !executor.isShutdown()) {
            ComplexityAnalyzer.LOGGER.info("Shutting down analysis thread pool gracefully... Attempting to stabilize core.");
            executor.shutdown();
            try {
                String[] countdownMessages = new String[]{"[T-5s] Warning: Analysis core is not responding to shutdown signal. Stabilizing magnetic field...", "[T-4s] Warning: Coolant pressure dropping. Trying to bypass primary calculation loop...", "[T-3s] CRITICAL: Resonance cascade imminent in solver matrix! Attempting to eject complexity queue...", "[T-2s] DANGER: Control rod ejection FAILED! Core temperature rising exponentially!", "[T-1s] !!! CORE INTEGRITY FAILURE IMMINENT. BRACE FOR IMPACT. !!!"};
                boolean terminatedGracefully = false;
                for (int i = 0; i < 5; ++i) {
                    if (executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                        terminatedGracefully = true;
                        ComplexityAnalyzer.LOGGER.info("Graceful shutdown successful. Analysis core is stable.");
                        break;
                    }
                    ComplexityAnalyzer.LOGGER.warn(countdownMessages[i]);
                }
                if (!terminatedGracefully) {
                    ComplexityAnalyzer.LOGGER.error("!!! CONTAINMENT BREACH: ANALYSIS CORE MELTDOWN !!!");
                    ComplexityAnalyzer.LOGGER.error("Forcing emergency shutdown protocol! Data integrity compromised!");
                    List<Runnable> discardedTasks = executor.shutdownNow();
                    ComplexityAnalyzer.LOGGER.error("SCRAM PROTOCOL ENGAGED. Purged {} tasks from execution queue.", (Object)discardedTasks.size());
                    ComplexityAnalyzer.LOGGER.error("System state is UNRECOVERABLE. Full analysis required on next boot.");
                }
            }
            catch (InterruptedException e) {
                ComplexityAnalyzer.LOGGER.error("!!! INTERRUPTED DURING EMERGENCY SHUTDOWN. STATE UNKNOWN. !!!", (Throwable)e);
                executor.shutdownNow();
                Thread.currentThread().interrupt();
            }
            ComplexityAnalyzer.LOGGER.info("Analysis thread pool is now offline.");
        }
        this.stateLock.lock();
        try {
            this.clearDataInternal();
            this.currentState.set(State.IDLE);
            ComplexityAnalyzer.LOGGER.info("AnalysisEngine state reset to IDLE.");
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private void clearAllCaches() {
        ComplexityAnalyzer.LOGGER.info("Clearing all analysis caches...");
        this.complexityCache.clear();
        if (this.mobRarityCalculator != null) {
            this.mobRarityCalculator.clearCache();
        }
        ComplexityAnalyzer.LOGGER.info("All caches cleared.");
    }

    public Optional<MobDropSource> getMobDropSource() {
        SourceManager sm = this.sourceManager;
        if (sm == null) {
            return Optional.empty();
        }
        return sm.getSourceByType(MobDropSource.class);
    }

    public Optional<MobPropertyProvider> getMobPropertyProvider() {
        return Optional.ofNullable(this.mobPropProvider);
    }

    public Optional<GeoAnalysisManager> getGeoManager() {
        return Optional.ofNullable(this.geoManager);
    }

    public EngineStats getStats() {
        if (!this.isReady()) {
            return new EngineStats(this.currentState.get(), 0, 0, 0);
        }
        RecipeGraph currentGraph = this.graph;
        if (currentGraph == null) {
            return new EngineStats(this.currentState.get(), 0, 0, 0);
        }
        return new EngineStats(this.currentState.get(), currentGraph.getAllItems().size(), currentGraph.getTotalRecipeCount(), 0);
    }

    public <T extends IResourceSource> Optional<T> getSourceByType(Class<T> type) {
        SourceManager sm = this.sourceManager;
        if (sm == null) {
            return Optional.empty();
        }
        return sm.getSourceByType(type);
    }

    private static class InstanceHolder {
        private static final AnalysisEngine INSTANCE = new AnalysisEngine();

        private InstanceHolder() {
        }
    }

    public static enum State {
        IDLE,
        ANALYZING,
        READY,
        FAILED;

    }

    public record EngineStats(State state, int itemCount, int recipeCount, int baseResourceCount) {
    }
}

