/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.data;

import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;

public enum ComplexityCategory {
    ABSOLUTE(0.0, "Absolute", ChatFormatting.WHITE),
    TRIVIAL(10.0, "Trivial", ChatFormatting.GRAY),
    SIMPLE(100.0, "Simple", ChatFormatting.GREEN),
    MODERATE(1000.0, "Moderate", ChatFormatting.YELLOW),
    COMPLEX(10000.0, "Complex", ChatFormatting.GOLD),
    DIFFICULT(100000.0, "Difficult", ChatFormatting.RED),
    EXPERT(1000000.0, "Expert", ChatFormatting.DARK_PURPLE),
    MASTER(1.0E7, "Master", ChatFormatting.AQUA),
    MYTHICAL(1.0E8, "Mythical", ChatFormatting.LIGHT_PURPLE),
    TRANSCENDENT(1.0E9, "Transcendent", ChatFormatting.DARK_AQUA),
    ETERNAL(Double.POSITIVE_INFINITY, "Eternal", ChatFormatting.DARK_RED),
    UNCALCULABLE(-1.0, "Uncalculable", ChatFormatting.DARK_GRAY);

    private static final ComplexityCategory[] CALCULABLE_CATEGORIES;
    private static final double[] UPPER_BOUNDS;
    private final double maxComplexity;
    private final String displayName;
    private final ChatFormatting color;

    private ComplexityCategory(double max, String displayName, ChatFormatting color) {
        this.maxComplexity = max;
        this.displayName = displayName;
        this.color = color;
    }

    public static ComplexityCategory fromComplexity(double complexity) {
        if (complexity < 0.0) {
            return UNCALCULABLE;
        }
        if (complexity == 0.0) {
            return ABSOLUTE;
        }
        int categoryIndex = ComplexityCategory.getCategoryIndex(complexity);
        if (categoryIndex >= CALCULABLE_CATEGORIES.length) {
            return ETERNAL;
        }
        return CALCULABLE_CATEGORIES[categoryIndex];
    }

    private static int getCategoryIndex(double complexity) {
        int searchIndex = Arrays.binarySearch(UPPER_BOUNDS, complexity);
        int categoryIndex = searchIndex >= 0 ? searchIndex : -(searchIndex + 1);
        return categoryIndex;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ChatFormatting getColor() {
        return this.color;
    }

    static {
        List<ComplexityCategory> calculable = Arrays.stream(ComplexityCategory.values()).filter(c -> c != UNCALCULABLE && c != ABSOLUTE).toList();
        CALCULABLE_CATEGORIES = calculable.toArray(new ComplexityCategory[0]);
        UPPER_BOUNDS = new double[calculable.size()];
        for (int i = 0; i < calculable.size(); ++i) {
            ComplexityCategory.UPPER_BOUNDS[i] = calculable.get((int)i).maxComplexity;
        }
    }
}

