/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.geoscan.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.complexityanalyzer.geoscan.data.BiomeScanData;

public class BiomeDataMapper {
    public void prepareForSave(BiomeScanData data) {
        data.serializableBlockCounts.clear();
        data.getInternalBlockCounts().forEach((block, count) -> {
            ResourceLocation key = BuiltInRegistries.BLOCK.getKey(block);
            if (!key.equals((Object)BuiltInRegistries.BLOCK.getDefaultKey())) {
                data.serializableBlockCounts.put(key.toString(), count.get());
            }
        });
        data.scannedChunks = data.getInternalScannedChunksSet() != null ? new ArrayList<Long>(data.getInternalScannedChunksSet()) : new ArrayList<Long>();
    }

    public void afterLoad(BiomeScanData data) {
        data.getInternalBlockCounts().clear();
        if (data.serializableBlockCounts != null) {
            data.serializableBlockCounts.forEach((key, count) -> {
                Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)key));
                if (block != Blocks.AIR) {
                    data.getInternalBlockCounts().put(block, new AtomicLong((long)count));
                }
            });
        }
        if (data.scannedChunks != null) {
            data.setInternalScannedChunksSet(new HashSet<Long>(data.scannedChunks));
        } else {
            data.setInternalScannedChunksSet(new HashSet<Long>());
        }
    }
}

