/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.geoscan.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.world.level.block.Block;
import org.complexityanalyzer.geoscan.util.ChunkCoordinateUtil;

public class BiomeScanData {
    private final transient Map<Block, AtomicLong> blockCounts = new ConcurrentHashMap<Block, AtomicLong>();
    private transient Set<Long> scannedChunksSet;
    Map<String, Long> serializableBlockCounts = new ConcurrentHashMap<String, Long>();
    List<Long> scannedChunks = new ArrayList<Long>();

    public BiomeScanData() {
        this.scannedChunksSet = new HashSet<Long>();
    }

    public void addBlock(Block block) {
        this.blockCounts.computeIfAbsent(block, k -> new AtomicLong(0L)).incrementAndGet();
    }

    public void addBlock(Block block, long count) {
        this.blockCounts.computeIfAbsent(block, k -> new AtomicLong(0L)).addAndGet(count);
    }

    public void addScannedChunk(int chunkX, int chunkZ) {
        long coord = ChunkCoordinateUtil.pack(chunkX, chunkZ);
        if (this.scannedChunksSet == null) {
            this.scannedChunksSet = new HashSet<Long>();
        }
        this.scannedChunksSet.add(coord);
    }

    public boolean hasScannedChunk(int chunkX, int chunkZ) {
        if (this.scannedChunksSet == null) {
            return false;
        }
        long coord = ChunkCoordinateUtil.pack(chunkX, chunkZ);
        return this.scannedChunksSet.contains(coord);
    }

    public int getChunksScanned() {
        return this.scannedChunksSet != null ? this.scannedChunksSet.size() : 0;
    }

    public Map<Block, AtomicLong> getBlockCounts() {
        return Collections.unmodifiableMap(this.blockCounts);
    }

    public void merge(BiomeScanData other) {
        if (other == null) {
            return;
        }
        other.getBlockCounts().forEach((block, count) -> this.addBlock((Block)block, count.get()));
        if (other.scannedChunksSet != null) {
            if (this.scannedChunksSet == null) {
                this.scannedChunksSet = new HashSet<Long>();
            }
            this.scannedChunksSet.addAll(other.scannedChunksSet);
        }
    }

    public Map<Block, AtomicLong> getInternalBlockCounts() {
        return this.blockCounts;
    }

    Set<Long> getInternalScannedChunksSet() {
        return this.scannedChunksSet;
    }

    void setInternalScannedChunksSet(Set<Long> newSet) {
        this.scannedChunksSet = newSet;
    }
}

