/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.graph;

import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ArmorDyeRecipe;
import net.minecraft.world.item.crafting.BannerDuplicateRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.MapCloningRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.TippedArrowRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.complexityanalyzer.ComplexityAnalyzer;
import org.complexityanalyzer.compat.jei.JeiCompatibilityModule;
import org.complexityanalyzer.config.ComplexityConfig;
import org.complexityanalyzer.graph.RecipeCategory;
import org.complexityanalyzer.graph.RecipeGraph;
import org.complexityanalyzer.graph.RecipeNode;

public class GraphBuilder {
    private static final TagKey<Item> STORAGE_BLOCKS_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"c:storage_blocks"));
    private static final TagKey<Item> INGOTS_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"c:ingots"));
    private static final TagKey<Item> NUGGETS_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"c:nuggets"));
    private static final TagKey<Item> GEMS_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"c:gems"));

    public static RecipeGraph buildFromWorld(Level level) {
        ComplexityAnalyzer.LOGGER.info("Building recipe graph with advanced classification...");
        RecipeGraph graph = new RecipeGraph();
        RecipeManager recipeManager = level.getRecipeManager();
        int processedCount = 0;
        int skippedCount = 0;
        for (RecipeHolder holder : recipeManager.getRecipes()) {
            try {
                RecipeNode node = GraphBuilder.buildNode(holder.value(), level);
                if (node != null) {
                    graph.addRecipe(node);
                    ++processedCount;
                    continue;
                }
                ++skippedCount;
            }
            catch (Exception e) {
                ComplexityAnalyzer.LOGGER.warn("Failed to process recipe {}: {}", (Object)holder.id(), (Object)e.getMessage());
                ++skippedCount;
            }
        }
        ComplexityAnalyzer.LOGGER.info("Recipe graph built: {} recipes processed, {} skipped", (Object)processedCount, (Object)skippedCount);
        try {
            JeiCompatibilityModule.collectRecipesFromJeiPlugins(graph, level);
        }
        catch (Throwable t) {
            ComplexityAnalyzer.LOGGER.error("JEI compatibility module failed", t);
        }
        return graph;
    }

    private static RecipeNode buildSmithingNode(SmithingTransformRecipe recipe, Item resultItem, int resultCount) {
        RecipeNode.Builder builder = new RecipeNode.Builder(resultItem).resultCount(resultCount).recipeType(RecipeType.SMITHING).category(RecipeCategory.PRIMARY);
        try {
            List<Item> additionVariants;
            List<Item> baseVariants;
            List<Item> templateVariants;
            Field templateField = SmithingTransformRecipe.class.getDeclaredField("template");
            Field baseField = SmithingTransformRecipe.class.getDeclaredField("base");
            Field additionField = SmithingTransformRecipe.class.getDeclaredField("addition");
            templateField.setAccessible(true);
            baseField.setAccessible(true);
            additionField.setAccessible(true);
            Ingredient template = (Ingredient)templateField.get(recipe);
            Ingredient base = (Ingredient)baseField.get(recipe);
            Ingredient addition = (Ingredient)additionField.get(recipe);
            if (!template.isEmpty() && !(templateVariants = Stream.of(template.getItems()).map(ItemStack::getItem).distinct().toList()).isEmpty()) {
                builder.addIngredient(templateVariants, 1);
            }
            if (!base.isEmpty() && !(baseVariants = Stream.of(base.getItems()).map(ItemStack::getItem).distinct().toList()).isEmpty()) {
                builder.addIngredient(baseVariants, 1);
            }
            if (!addition.isEmpty() && !(additionVariants = Stream.of(addition.getItems()).map(ItemStack::getItem).distinct().toList()).isEmpty()) {
                builder.addIngredient(additionVariants, 1);
            }
            builder.priority(2100);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            ComplexityAnalyzer.LOGGER.error("Failed to process SmithingTransformRecipe for {}: {}", (Object)BuiltInRegistries.ITEM.getKey((Object)resultItem), (Object)e.getMessage());
            return null;
        }
        return builder.build();
    }

    private static RecipeNode buildNode(Recipe<?> recipe, Level level) {
        ItemStack resultStack = recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
        if (resultStack.isEmpty()) {
            return null;
        }
        Item resultItem = resultStack.getItem();
        NonNullList ingredients = recipe.getIngredients();
        if (recipe instanceof SmithingTransformRecipe) {
            SmithingTransformRecipe smithing = (SmithingTransformRecipe)recipe;
            return GraphBuilder.buildSmithingNode(smithing, resultItem, resultStack.getCount());
        }
        if (ingredients.isEmpty()) {
            return null;
        }
        RecipeCategory category = GraphBuilder.classifyRecipe(recipe, resultItem, (List<Ingredient>)ingredients);
        if (category == RecipeCategory.UNPROCESSABLE) {
            return null;
        }
        RecipeNode.Builder builder = new RecipeNode.Builder(resultItem).resultCount(resultStack.getCount()).recipeType(recipe.getType()).category(category);
        if (category == RecipeCategory.PRIMARY && (recipe.getType() == RecipeType.SMELTING || recipe.getType() == RecipeType.BLASTING)) {
            builder.priority(2000);
        }
        for (Ingredient ingredient : ingredients) {
            List<Item> itemVariants;
            if (ingredient.isEmpty() || (itemVariants = Stream.of(ingredient.getItems()).limit(((Integer)ComplexityConfig.MAX_INGREDIENT_VARIANTS.get()).intValue()).map(ItemStack::getItem).distinct().toList()).isEmpty()) continue;
            builder.addIngredient(itemVariants, 1);
        }
        return builder.build();
    }

    public static RecipeCategory classifyRecipe(Recipe<?> recipe, Item resultItem, List<Ingredient> ingredients) {
        if (GraphBuilder.isUnprocessable(recipe, resultItem, ingredients)) {
            return RecipeCategory.UNPROCESSABLE;
        }
        if (GraphBuilder.isRecyclingRecipe(recipe, ingredients)) {
            return RecipeCategory.RECYCLING;
        }
        ItemStack resultStack = new ItemStack((ItemLike)resultItem);
        if (ingredients.size() == 1) {
            ItemStack ingredientStack;
            ItemStack itemStack = ingredientStack = ingredients.getFirst().getItems().length > 0 ? ingredients.getFirst().getItems()[0] : ItemStack.EMPTY;
            if (!ingredientStack.isEmpty()) {
                if (ingredientStack.is(STORAGE_BLOCKS_TAG) && (resultStack.is(INGOTS_TAG) || resultStack.is(GEMS_TAG))) {
                    return RecipeCategory.STORAGE_DECOMPRESSION;
                }
                if (ingredientStack.is(INGOTS_TAG) && resultStack.is(NUGGETS_TAG)) {
                    return RecipeCategory.STORAGE_DECOMPRESSION;
                }
            }
        }
        if (GraphBuilder.areAllIngredientsOfTag(ingredients, NUGGETS_TAG) && resultStack.is(INGOTS_TAG)) {
            return RecipeCategory.STORAGE_COMPRESSION;
        }
        if (GraphBuilder.areAllIngredientsOfTag(ingredients, INGOTS_TAG) && resultStack.is(STORAGE_BLOCKS_TAG)) {
            return RecipeCategory.STORAGE_COMPRESSION;
        }
        if (GraphBuilder.areAllIngredientsOfTag(ingredients, GEMS_TAG) && resultStack.is(STORAGE_BLOCKS_TAG)) {
            return RecipeCategory.STORAGE_COMPRESSION;
        }
        return RecipeCategory.PRIMARY;
    }

    private static boolean areAllIngredientsOfTag(List<Ingredient> ingredients, TagKey<Item> tag) {
        if (ingredients.isEmpty()) {
            return false;
        }
        return ingredients.stream().flatMap(ing -> Stream.of(ing.getItems())).allMatch(stack -> !stack.isEmpty() && stack.is(tag));
    }

    private static boolean isUnprocessable(Recipe<?> recipe, Item resultItem, List<Ingredient> ingredients) {
        if (new ItemStack((ItemLike)resultItem).isDamageableItem()) {
            return ingredients.stream().flatMap(ing -> Stream.of(ing.getItems())).anyMatch(stack -> stack.getItem() == resultItem);
        }
        return recipe instanceof TippedArrowRecipe || recipe instanceof MapCloningRecipe || recipe instanceof ArmorDyeRecipe || recipe instanceof BannerDuplicateRecipe;
    }

    private static boolean isRecyclingRecipe(Recipe<?> recipe, List<Ingredient> ingredients) {
        if (ingredients.size() != 1) {
            return false;
        }
        boolean ingredientIsDamageable = Stream.of(ingredients.getFirst().getItems()).anyMatch(ItemStack::isDamageableItem);
        return ingredientIsDamageable && (recipe.getType() == RecipeType.SMELTING || recipe.getType() == RecipeType.BLASTING);
    }
}

