/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.item.Item;

public class IngredientSlot {
    private final List<Item> variants;
    private final int count;

    public IngredientSlot(List<Item> variants, int count) {
        this.variants = new ArrayList<Item>(variants);
        this.count = Math.max(1, count);
    }

    public IngredientSlot(Item singleItem, int count) {
        this.variants = List.of(singleItem);
        this.count = Math.max(1, count);
    }

    public List<Item> getVariants() {
        return Collections.unmodifiableList(this.variants);
    }

    public int getCount() {
        return this.count;
    }

    public boolean hasMultipleVariants() {
        return this.variants.size() > 1;
    }

    public Item getFirstVariant() {
        return this.variants.isEmpty() ? null : this.variants.getFirst();
    }

    public String toString() {
        if (this.variants.size() == 1) {
            return this.count + "x " + String.valueOf(this.variants.getFirst());
        }
        return this.count + "x [" + this.variants.size() + " variants]";
    }
}

