/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.item.Item;
import org.complexityanalyzer.ComplexityAnalyzer;
import org.complexityanalyzer.graph.IngredientSlot;
import org.complexityanalyzer.graph.RecipeCategory;
import org.complexityanalyzer.graph.RecipeNode;
import org.jetbrains.annotations.NotNull;

public class RecipeGraph {
    private final Map<Item, List<RecipeNode>> recipesByItem = new ConcurrentHashMap<Item, List<RecipeNode>>();
    private final Map<Item, Set<Item>> usageMap = new ConcurrentHashMap<Item, Set<Item>>();
    private final Map<Item, RecipeNode> bestRecipeCache = new ConcurrentHashMap<Item, RecipeNode>();

    public Collection<RecipeNode> getAllRecipes() {
        return this.recipesByItem.values().stream().flatMap(Collection::stream).toList();
    }

    public void addRecipe(RecipeNode node) {
        Item result = node.getResultItem();
        this.recipesByItem.computeIfAbsent(result, k -> new ArrayList()).add(node);
        for (IngredientSlot slot : node.getIngredients()) {
            for (Item ingredient : slot.getVariants()) {
                this.usageMap.computeIfAbsent(ingredient, k -> new HashSet()).add(result);
            }
        }
        this.bestRecipeCache.remove(result);
    }

    public List<RecipeNode> getRecipes(Item item) {
        return this.recipesByItem.getOrDefault(item, Collections.emptyList());
    }

    public RecipeNode getBestRecipe(Item item) {
        return this.bestRecipeCache.computeIfAbsent(item, this::findBestRecipe);
    }

    private RecipeNode findBestRecipe(Item item) {
        List<RecipeNode> recipes = this.getRecipes(item);
        if (recipes.isEmpty()) {
            return RecipeNode.empty(item);
        }
        if (recipes.size() == 1) {
            return recipes.getFirst();
        }
        List<RecipeNode> primaryRecipes = recipes.stream().filter(r -> r.getCategory() == RecipeCategory.PRIMARY).toList();
        if (!primaryRecipes.isEmpty()) {
            return primaryRecipes.stream().max(Comparator.comparingInt(RecipeNode::getPriority)).orElse(primaryRecipes.getFirst());
        }
        List<RecipeNode> goodRecipes = recipes.stream().filter(r -> r.getCategory() != RecipeCategory.STORAGE_DECOMPRESSION && r.getCategory() != RecipeCategory.RECYCLING && r.getCategory() != RecipeCategory.UNPROCESSABLE).toList();
        if (!goodRecipes.isEmpty()) {
            return goodRecipes.stream().max(Comparator.comparingInt(RecipeNode::getPriority)).orElse(goodRecipes.getFirst());
        }
        return recipes.stream().max(Comparator.comparingInt(RecipeNode::getPriority)).orElse(recipes.getFirst());
    }

    public boolean hasRecipe(Item item) {
        List<RecipeNode> recipes = this.recipesByItem.get(item);
        return recipes != null && !recipes.isEmpty();
    }

    public int getRecipeCount(Item item) {
        return this.recipesByItem.getOrDefault(item, Collections.emptyList()).size();
    }

    public int getUsageCount(Item item) {
        Set<Item> users = this.usageMap.get(item);
        return users != null ? users.size() : 0;
    }

    public Set<Item> getItemsUsingIngredient(Item ingredient) {
        return this.usageMap.getOrDefault(ingredient, Collections.emptySet());
    }

    public Set<Item> getAllItems() {
        return this.recipesByItem.keySet();
    }

    public int getTotalRecipeCount() {
        return this.recipesByItem.values().stream().mapToInt(List::size).sum();
    }

    public void clear() {
        this.recipesByItem.clear();
        this.usageMap.clear();
        this.bestRecipeCache.clear();
        ComplexityAnalyzer.LOGGER.info("Recipe graph cleared");
    }

    public GraphStats getStats() {
        return new GraphStats(this.recipesByItem.size(), this.getTotalRecipeCount(), this.usageMap.size());
    }

    public Set<Item> getCorpus() {
        HashSet<Item> allItems = new HashSet<Item>(this.recipesByItem.keySet());
        allItems.addAll(this.usageMap.keySet());
        return allItems;
    }

    public record GraphStats(int itemsWithRecipes, int totalRecipes, int itemsUsedAsIngredients) {
        @Override
        @NotNull
        public String toString() {
            return String.format("GraphStats{items=%d, recipes=%d, ingredients=%d}", this.itemsWithRecipes, this.totalRecipes, this.itemsUsedAsIngredients);
        }
    }
}

