/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.analyzer;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.item.Item;
import org.complexityanalyzer.analyzer.resource.SourceManager;
import org.complexityanalyzer.config.ComplexityConfig;
import org.complexityanalyzer.graph.IngredientSlot;
import org.complexityanalyzer.graph.RecipeGraph;
import org.complexityanalyzer.graph.RecipeNode;

public class DepthAnalyzer {
    private final RecipeGraph graph;
    private final Map<Item, Integer> cache;
    private final Map<Item, Optional<RecipeNode>> recipeCache = new ConcurrentHashMap<Item, Optional<RecipeNode>>();
    private Map<Item, RecipeNode> optimalRecipes = new HashMap<Item, RecipeNode>();
    private static final int CYCLE_DEPTH = Integer.MAX_VALUE;
    private static final int IN_PROGRESS = -999;

    public DepthAnalyzer(RecipeGraph graph, SourceManager ignoredSourceManager) {
        this.graph = graph;
        this.cache = new ConcurrentHashMap<Item, Integer>();
    }

    public void setOptimalRecipes(Map<Item, RecipeNode> optimalRecipes) {
        this.optimalRecipes = new HashMap<Item, RecipeNode>(optimalRecipes);
        this.recipeCache.clear();
    }

    public int getDepth(Item item) {
        Integer cachedDepth = this.cache.get(item);
        if (cachedDepth != null) {
            return cachedDepth;
        }
        return this.calculateDepth(item);
    }

    private int calculateDepth(Item item) {
        int finalDepth;
        Integer cached = this.cache.get(item);
        if (cached != null) {
            if (cached == -999) {
                return Integer.MAX_VALUE;
            }
            return cached;
        }
        this.cache.put(item, -999);
        Optional<RecipeNode> recipeOpt = this.getRecipeToFollow(item);
        if (recipeOpt.isEmpty()) {
            this.cache.put(item, 0);
            return 0;
        }
        RecipeNode recipeToFollow = recipeOpt.get();
        int maxIngredientDepth = 0;
        boolean cycleDetected = false;
        for (IngredientSlot slot : recipeToFollow.getIngredients()) {
            int slotDepth = this.calculateSlotDepth(slot);
            if (slotDepth == Integer.MAX_VALUE) {
                cycleDetected = true;
                break;
            }
            maxIngredientDepth = Math.max(maxIngredientDepth, slotDepth);
        }
        if (cycleDetected) {
            finalDepth = Integer.MAX_VALUE;
        } else {
            long calculatedDepth = 1L + (long)maxIngredientDepth;
            finalDepth = (int)Math.min(calculatedDepth, Integer.MAX_VALUE);
        }
        int limitedDepth = Math.min(finalDepth, (Integer)ComplexityConfig.MAX_DEPTH.get());
        this.cache.put(item, limitedDepth);
        return limitedDepth;
    }

    private int calculateSlotDepth(IngredientSlot slot) {
        if (slot.getVariants().isEmpty()) {
            return 0;
        }
        int minDepth = Integer.MAX_VALUE;
        for (Item variant : slot.getVariants()) {
            int variantDepth = this.getDepth(variant);
            minDepth = Math.min(minDepth, variantDepth);
        }
        return minDepth;
    }

    public Optional<RecipeNode> getRecipeToFollow(Item item) {
        return this.recipeCache.computeIfAbsent(item, key -> {
            RecipeNode bestFromGraph;
            RecipeNode optimalRecipe = this.optimalRecipes.get(key);
            if (optimalRecipe != null) {
                return Optional.of(optimalRecipe);
            }
            if (this.graph != null && this.graph.hasRecipe((Item)key) && (bestFromGraph = this.graph.getBestRecipe((Item)key)) != null && !bestFromGraph.isBaseRecipe()) {
                return Optional.of(bestFromGraph);
            }
            return Optional.empty();
        });
    }
}

