/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.analyzer;

import java.util.HashSet;
import net.minecraft.world.item.Item;
import org.complexityanalyzer.analyzer.resource.SourceManager;
import org.complexityanalyzer.analyzer.resource.data.BaseResourceData;
import org.complexityanalyzer.graph.IngredientSlot;
import org.complexityanalyzer.graph.RecipeGraph;
import org.complexityanalyzer.graph.RecipeNode;

public class SourcePathAnalyzer {
    private final RecipeGraph graph;
    private final SourceManager sourceManager;

    public SourcePathAnalyzer(RecipeGraph graph, SourceManager sourceManager) {
        this.graph = graph;
        this.sourceManager = sourceManager;
    }

    public void findItemsWithBasePath() {
        int lastSize;
        HashSet<Item> itemsWithBasePath = new HashSet<Item>();
        for (Item item : this.graph.getAllItems()) {
            BaseResourceData.ResourceSourceType type;
            if (this.graph.hasRecipe(item) || (type = this.sourceManager.analyze(item).map(BaseResourceData::getSourceType).orElse(BaseResourceData.ResourceSourceType.UNKNOWN)) == BaseResourceData.ResourceSourceType.UNKNOWN) continue;
            itemsWithBasePath.add(item);
        }
        do {
            lastSize = itemsWithBasePath.size();
            for (RecipeNode recipe : this.graph.getAllRecipes()) {
                Item result = recipe.getResultItem();
                if (itemsWithBasePath.contains(result)) continue;
                boolean allIngredientsHaveBasePath = true;
                for (IngredientSlot slot : recipe.getIngredients()) {
                    if (!slot.getVariants().stream().noneMatch(itemsWithBasePath::contains)) continue;
                    allIngredientsHaveBasePath = false;
                    break;
                }
                if (!allIngredientsHaveBasePath) continue;
                itemsWithBasePath.add(result);
            }
        } while (itemsWithBasePath.size() > lastSize);
    }
}

