/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.analyzer.resource.providers;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.complexityanalyzer.ComplexityAnalyzer;

public class BlockPropertyProvider {
    private final Map<Block, BlockProperties> propertiesCache = new HashMap<Block, BlockProperties>();
    private boolean initialized = false;

    public void initialize() {
        if (this.initialized) {
            return;
        }
        ComplexityAnalyzer.LOGGER.info("Initializing BlockPropertyProvider...");
        int analyzed = 0;
        for (Block block : BuiltInRegistries.BLOCK) {
            try {
                BlockProperties props = this.analyzeBlock(block);
                this.propertiesCache.put(block, props);
                ++analyzed;
            }
            catch (Exception e) {
                ComplexityAnalyzer.LOGGER.warn("Failed to analyze block {}: {}", (Object)BuiltInRegistries.BLOCK.getKey((Object)block), (Object)e.getMessage());
            }
        }
        this.initialized = true;
        ComplexityAnalyzer.LOGGER.info("BlockPropertyProvider initialized, analyzed {} blocks.", (Object)analyzed);
    }

    private BlockProperties analyzeBlock(Block block) {
        float explosionResistance;
        BlockState state = block.defaultBlockState();
        float hardness = block.defaultDestroyTime();
        Tier requiredTier = this.determineRequiredTier(block);
        boolean canHarvestByHand = hardness >= 0.0f && requiredTier == Tiers.WOOD && !state.requiresCorrectToolForDrops();
        try {
            explosionResistance = state.getExplosionResistance(null, null, null);
        }
        catch (Exception e) {
            explosionResistance = 0.0f;
        }
        return new BlockProperties(hardness, requiredTier, canHarvestByHand, explosionResistance);
    }

    private Tier determineRequiredTier(Block block) {
        BlockState state = block.defaultBlockState();
        if (state.is(BlockTags.NEEDS_DIAMOND_TOOL)) {
            return Tiers.DIAMOND;
        }
        if (state.is(BlockTags.NEEDS_IRON_TOOL)) {
            return Tiers.IRON;
        }
        if (state.is(BlockTags.NEEDS_STONE_TOOL)) {
            return Tiers.STONE;
        }
        return Tiers.WOOD;
    }

    public Optional<BlockProperties> getProperties(Block block) {
        return Optional.ofNullable(this.propertiesCache.get(block));
    }

    public Optional<BlockProperties> getProperties(Item item) {
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return this.getProperties(blockItem.getBlock());
        }
        return Optional.empty();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public record BlockProperties(float hardness, Tier requiredTier, boolean canHarvestByHand, float explosionResistance) {
        public double getHardnessMultiplier() {
            if (this.hardness < 0.0f) {
                return 10.0;
            }
            if (this.hardness == 0.0f) {
                return 0.1;
            }
            return 1.0 + Math.log1p(this.hardness);
        }

        public double getToolMultiplier() {
            if (this.requiredTier == Tiers.WOOD) {
                return 1.0;
            }
            if (this.requiredTier == Tiers.STONE) {
                return 1.5;
            }
            if (this.requiredTier == Tiers.IRON) {
                return 2.5;
            }
            if (this.requiredTier == Tiers.DIAMOND) {
                return 4.0;
            }
            if (this.requiredTier == Tiers.NETHERITE) {
                return 5.0;
            }
            return 1.0;
        }

        public String getTierName() {
            if (this.canHarvestByHand) {
                return "HAND";
            }
            if (this.requiredTier == Tiers.WOOD) {
                return "WOOD";
            }
            if (this.requiredTier == Tiers.STONE) {
                return "STONE";
            }
            if (this.requiredTier == Tiers.IRON) {
                return "IRON";
            }
            if (this.requiredTier == Tiers.DIAMOND) {
                return "DIAMOND";
            }
            if (this.requiredTier == Tiers.NETHERITE) {
                return "NETHERITE";
            }
            return "UNKNOWN";
        }
    }
}

