/*
 * Decompiled with CFR 0.152.
 */
package org.complexityanalyzer.analyzer.resource.sources;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.complexityanalyzer.ComplexityAnalyzer;
import org.complexityanalyzer.analyzer.resource.IMultiSourceProvider;
import org.complexityanalyzer.analyzer.resource.IResourceSource;
import org.complexityanalyzer.analyzer.resource.data.BaseResourceData;

public class BlockBreakAsRecipeSource
implements IResourceSource,
IMultiSourceProvider {
    private static final int SAMPLE_COUNT = 100;
    private static final double BASE_MINING_COST = 2.0;
    private final Map<Item, List<BaseResourceData>> allPaths = new HashMap<Item, List<BaseResourceData>>();
    private static Field randomField = null;

    @Override
    public void initialize(Level level) {
        if (!(level instanceof ServerLevel)) {
            ComplexityAnalyzer.LOGGER.warn("[{}] requires a ServerLevel. Skipping.", (Object)this.getName());
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.allPaths.clear();
        ComplexityAnalyzer.LOGGER.info("[{}] Initializing... Analyzing all block drop recipes.", (Object)this.getName());
        long startTime = System.currentTimeMillis();
        int pathsFound = 0;
        int blocksSkipped = 0;
        MinecraftServer server = serverLevel.getServer();
        List<ItemStack> toolsToTest = this.createTestTools(serverLevel);
        for (Block blockToMine : BuiltInRegistries.BLOCK) {
            if (blockToMine == Blocks.AIR || blockToMine == Blocks.CAVE_AIR || blockToMine == Blocks.VOID_AIR) continue;
            if (blockToMine.defaultDestroyTime() < 0.0f) {
                ++blocksSkipped;
                continue;
            }
            BlockState defaultState = blockToMine.defaultBlockState();
            Item blockAsItem = blockToMine.asItem();
            for (ItemStack toolStack : toolsToTest) {
                if (defaultState.requiresCorrectToolForDrops() && !toolStack.isCorrectToolForDrops(defaultState)) continue;
                try {
                    Map<Item, Double> averageDrop;
                    LootTable lootTable = server.reloadableRegistries().getLootTable(blockToMine.getLootTable());
                    if (lootTable == LootTable.EMPTY || (averageDrop = this.getStableDrop(lootTable, serverLevel, defaultState, toolStack, blockToMine)).isEmpty()) continue;
                    for (Map.Entry<Item, Double> entry : averageDrop.entrySet()) {
                        double durability;
                        Item toolItem;
                        Item droppedItem = entry.getKey();
                        double itemsPerAction = entry.getValue();
                        if (itemsPerAction <= 0.0 || blockAsItem != Items.AIR && droppedItem == blockAsItem) continue;
                        HashMap<Item, Double> sourceItems = new HashMap<Item, Double>();
                        if (blockAsItem != Items.AIR) {
                            sourceItems.put(blockAsItem, 1.0 / itemsPerAction);
                        }
                        if ((toolItem = toolStack.getItem()) != Items.AIR && (durability = (double)toolStack.getMaxDamage()) > 0.0) {
                            double toolWearPerDrop = 1.0 / durability / itemsPerAction;
                            sourceItems.put(toolItem, toolWearPerDrop);
                        }
                        String toolName = toolStack.isEmpty() ? "Hand" : toolStack.getDisplayName().getString();
                        String avgFormatted = this.formatAverage(itemsPerAction);
                        BaseResourceData data = new BaseResourceData.Builder(droppedItem, this).sourceType(this.getSourceType()).details(String.format("Mined from %s with %s (avg: %s)", blockToMine.getName().getString(), toolName, avgFormatted)).baseFactor(2.0).sourceItems(sourceItems).build();
                        this.allPaths.computeIfAbsent(droppedItem, k -> new ArrayList()).add(data);
                        ++pathsFound;
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        for (List<BaseResourceData> paths : this.allPaths.values()) {
            paths.sort((a, b) -> {
                double sumB;
                int typeCompare = Double.compare(a.getSourceType().getBaseMultiplier(), b.getSourceType().getBaseMultiplier());
                if (typeCompare != 0) {
                    return typeCompare;
                }
                int factorCompare = Double.compare(a.getBaseFactor(), b.getBaseFactor());
                if (factorCompare != 0) {
                    return factorCompare;
                }
                int sizeCompare = Integer.compare(a.getSourceItems().size(), b.getSourceItems().size());
                if (sizeCompare != 0) {
                    return sizeCompare;
                }
                double sumA = a.getSourceItems().values().stream().mapToDouble(Double::doubleValue).sum();
                int sumCompare = Double.compare(sumA, sumB = b.getSourceItems().values().stream().mapToDouble(Double::doubleValue).sum());
                if (sumCompare != 0) {
                    return sumCompare;
                }
                return a.getDetails().compareTo(b.getDetails());
            });
        }
        ComplexityAnalyzer.LOGGER.info("[{}] Initialization complete in {}ms. Found {} block drop paths for {} unique items. Skipped {} indestructible blocks.", new Object[]{this.getName(), System.currentTimeMillis() - startTime, pathsFound, this.allPaths.size(), blocksSkipped});
    }

    private List<ItemStack> createTestTools(ServerLevel serverLevel) {
        ArrayList<ItemStack> tools = new ArrayList<ItemStack>();
        tools.add(ItemStack.EMPTY);
        tools.add(new ItemStack((ItemLike)Items.WOODEN_PICKAXE));
        tools.add(new ItemStack((ItemLike)Items.WOODEN_AXE));
        tools.add(new ItemStack((ItemLike)Items.WOODEN_SHOVEL));
        tools.add(new ItemStack((ItemLike)Items.STONE_PICKAXE));
        tools.add(new ItemStack((ItemLike)Items.STONE_AXE));
        tools.add(new ItemStack((ItemLike)Items.STONE_SHOVEL));
        tools.add(new ItemStack((ItemLike)Items.IRON_PICKAXE));
        tools.add(new ItemStack((ItemLike)Items.IRON_AXE));
        tools.add(new ItemStack((ItemLike)Items.IRON_SHOVEL));
        tools.add(new ItemStack((ItemLike)Items.GOLDEN_PICKAXE));
        tools.add(new ItemStack((ItemLike)Items.GOLDEN_AXE));
        tools.add(new ItemStack((ItemLike)Items.GOLDEN_SHOVEL));
        tools.add(new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        tools.add(new ItemStack((ItemLike)Items.DIAMOND_AXE));
        tools.add(new ItemStack((ItemLike)Items.DIAMOND_SHOVEL));
        tools.add(new ItemStack((ItemLike)Items.NETHERITE_PICKAXE));
        tools.add(new ItemStack((ItemLike)Items.NETHERITE_AXE));
        tools.add(new ItemStack((ItemLike)Items.NETHERITE_SHOVEL));
        tools.add(new ItemStack((ItemLike)Items.SHEARS));
        ItemStack silkTouchPickaxe = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
        Optional silkTouchHolder = serverLevel.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(Enchantments.SILK_TOUCH);
        silkTouchHolder.ifPresent(holder -> silkTouchPickaxe.enchant((Holder)holder, 1));
        tools.add(silkTouchPickaxe);
        return tools;
    }

    private Map<Item, Double> getStableDrop(LootTable lootTable, ServerLevel level, BlockState blockState, ItemStack tool, Block block) {
        long baseSeed = this.generateStableSeed(block, tool);
        HashMap<Item, Long> totalCounts = new HashMap<Item, Long>();
        boolean injectionWorked = false;
        for (int i = 0; i < 100; ++i) {
            RandomSource deterministicRandom = RandomSource.create((long)(baseSeed + (long)i));
            ObjectArrayList drops = new ObjectArrayList();
            LootParams params = new LootParams.Builder(level).withParameter(LootContextParams.BLOCK_STATE, (Object)blockState).withParameter(LootContextParams.TOOL, (Object)tool).withParameter(LootContextParams.ORIGIN, (Object)Vec3.ZERO).create(LootContextParamSets.BLOCK);
            LootContext context = new LootContext.Builder(params).create(Optional.empty());
            if (i == 0) {
                injectionWorked = this.injectRandomIntoContext(context, deterministicRandom);
            } else if (injectionWorked) {
                this.injectRandomSilently(context, deterministicRandom);
            }
            lootTable.getRandomItems(context, arg_0 -> ((ObjectArrayList)drops).add(arg_0));
            for (ItemStack stack : drops) {
                if (stack.isEmpty()) continue;
                totalCounts.merge(stack.getItem(), Long.valueOf(stack.getCount()), Long::sum);
            }
        }
        HashMap<Item, Double> averages = new HashMap<Item, Double>();
        for (Map.Entry entry : totalCounts.entrySet()) {
            averages.put((Item)entry.getKey(), (double)((Long)entry.getValue()).longValue() / 100.0);
        }
        return averages;
    }

    private boolean injectRandomIntoContext(LootContext context, RandomSource random) {
        if (randomField == null) {
            randomField = this.findRandomFieldAggressively(context);
            if (randomField != null) {
                ComplexityAnalyzer.LOGGER.info("[{}] Successfully found RandomSource field: {}", (Object)this.getName(), (Object)randomField.getName());
            } else {
                ComplexityAnalyzer.LOGGER.warn("[{}] Could not find RandomSource field", (Object)this.getName());
            }
        }
        return this.injectRandomSilently(context, random);
    }

    private boolean injectRandomSilently(LootContext context, RandomSource random) {
        if (randomField == null) {
            return false;
        }
        try {
            randomField.set(context, random);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Field findRandomFieldAggressively(LootContext context) {
        Class<?> clazz;
        for (clazz = context.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!RandomSource.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                return field;
            }
        }
        String[] possibleNames = new String[]{"random", "rand", "randomSource", "rng", "f_79024_"};
        for (clazz = context.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (String name : possibleNames) {
                try {
                    Field field = clazz.getDeclaredField(name);
                    field.setAccessible(true);
                    return field;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
            }
        }
        return null;
    }

    private long generateStableSeed(Block block, ItemStack tool) {
        long seed = BuiltInRegistries.BLOCK.getKey((Object)block).toString().hashCode();
        if (!tool.isEmpty()) {
            seed = seed * 31L + (long)BuiltInRegistries.ITEM.getKey((Object)tool.getItem()).toString().hashCode();
            ItemEnchantments enchantments = (ItemEnchantments)tool.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
            if (!enchantments.isEmpty()) {
                seed = seed * 31L + (long)enchantments.hashCode();
            }
        } else {
            seed = seed * 31L + (long)"empty_hand".hashCode();
        }
        return seed;
    }

    private String formatAverage(double value) {
        if (value < 1.0E-4) {
            return String.format("%.6f", value);
        }
        if (value < 0.01) {
            return String.format("%.4f", value);
        }
        return String.format("%.2f", value);
    }

    @Override
    public boolean canProvide(Item item) {
        return this.allPaths.containsKey(item);
    }

    @Override
    public Optional<BaseResourceData> analyze(Item item) {
        List<BaseResourceData> paths = this.allPaths.get(item);
        if (paths == null || paths.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(paths.getFirst());
    }

    @Override
    public List<BaseResourceData> findAllSources(Item item) {
        return this.allPaths.getOrDefault(item, Collections.emptyList());
    }

    @Override
    public int getPriority() {
        return 25;
    }

    @Override
    public String getName() {
        return "Block Break as Recipe";
    }

    @Override
    public BaseResourceData.ResourceSourceType getSourceType() {
        return BaseResourceData.ResourceSourceType.BLOCK_TRANSFORMATION;
    }
}

